<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/key/Key.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/key/Key.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Key</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;
IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>;
IMPORT <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../../ui/src/vbt/Latin1Key.i3">Latin1Key</A>;

TYPE
  KeyVBT = TextVBT.T OBJECT
           METHODS
             init (t: TEXT; f := Font.BuiltIn): KeyVBT := Init
           OVERRIDES
             position := Position;
             key      := Key;
           END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: KeyVBT; t: TEXT; f := Font.BuiltIn): KeyVBT =
  BEGIN
    EVAL TextVBT.T.init(v, t, fnt := f);
    RETURN v;                    (* Return KeyVBT, not TextVBT.T *)
  END Init;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (v: KeyVBT; READONLY cd: VBT.PositionRec) =
  BEGIN
    (* Notify us whenever cursor enters the window. *)
    VBT.SetCage(v, VBT.GoneCage);
    (* Take keyboard focus if mouse moves in our window. *)
    VBT.Acquire(v, VBT.KBFocus, cd.time)
  END Position;

PROCEDURE <A NAME="Key"><procedure>Key</procedure></A> (v: KeyVBT; READONLY cd: VBT.KeyRec) =
  CONST
    (* in [sp ..  td], the range of ascii printable characters, the
       KeyboardKey.KeySym's coincide *)
    sp = Latin1Key.space;
    td = Latin1Key.asciitilde;
  VAR
    wc       := cd.whatChanged;
    c : CHAR;
  BEGIN
    IF NOT cd.wentDown OR Rect.IsEmpty(VBT.Domain(v)) THEN RETURN END;
    IF sp &lt;= wc AND wc &lt;= td THEN
      c := VAL(ORD(wc), CHAR);
      TextVBT.Put(v, &quot;character \'&quot; &amp; Fmt.Char(c) &amp; &quot;\'&quot;);
    END;
  END Key;

VAR
  times14 := &quot;-*-times-*-r-*-*-14-*-*-*-*-*-*-*&quot;;
  font    := Font.FromName(ARRAY OF TEXT{times14});
  key     := NEW(KeyVBT).init(&quot;[uninitialized]&quot;, font);
  main    := BorderedVBT.New(RigidVBT.FromHV(key, 30.0, 10.0));
BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main);
END Key.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
