<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/source/Source.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/source/Source.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Source</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;
IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../lego/src/SourceVBT.i3">SourceVBT</A>;
IMPORT <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../../lego/src/Shadow.i3">Shadow</A>, <A HREF="../../../lego/src/FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../random/src/Common/Random.i3">Random</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;
FROM <A HREF="../common/Colors.i3">Colors</A> IMPORT lblue, dblue, lred, dred;
TYPE
  Source = SourceVBT.T OBJECT
           METHODS
             init (f: FeedbackVBT.T; t1, t2: VBT.T): Source := Init
           OVERRIDES
             hit      := SourceVBT.AlwaysHit;
             callback := Callback;
           END;
PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: Source; f: FeedBackVBT.T; t1, t2: VBT.T): Source =
  BEGIN
    SourceVBT.BeTarget(t1, SourceVBT.NewTarget());
    SourceVBT.BeTarget(t2, SourceVBT.NewTarget());
    EVAL SourceVBT.T.init(v, f);
    RETURN v;
  END Init;
PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (v: Source; READONLY cd: VBT.MouseRec) =
  VAR t := SourceVBT.GetTarget(v);
  BEGIN
    IF (t # NIL) THEN
      IF t = target1 THEN
        TextVBT.Put(slot1, TextVBT.Get(number));
      ELSE                       (* t = target2 *)
        TextVBT.Put(slot2, TextVBT.Get(number));
      END;
      TextVBT.Put(number, Fmt.Int(Random.Subrange(seed, 0, 100)));
    END;
  END Callback;
PROCEDURE <A NAME="New"><procedure>New</procedure></A> (t: TextVBT.T; s: Shadow.T): ShadowedFeedbackVBT.T =
  VAR r := RigidVBT.FromHV(t, hMin := 15.0, vMin := 10.0);
  BEGIN
    RETURN (NEW(ShadowedFeedbackVBT.T).init(r, s));
  END New;
VAR
  seed    := Random.New(-1);
  number  := TextVBT.New(Fmt.Int(Random.Subrange(seed, 0, 100)));
  slot1   := TextVBT.New(&quot;&quot;);
  slot2   := TextVBT.New(&quot;&quot;);
  red_sh  := Shadow.New(5.0, light := lred, dark := dred);
  blue_sh := Shadow.New(5.0, light := lblue, dark := dblue);
  target1 := New(slot1, blue_sh);
  target2 := New(slot2, blue_sh);
  source  := NEW(Source).init(New(number, red_sh), target1, target2);
  vbt     := RigidVBT.FromHV(TextVBT.New(&quot;Drag and Drop&quot;), 25.0, 15.0);
  hsplit  := HVSplit.Cons(Axis.T.Hor, target1, target2);
  main    := HVSplit.Cons(Axis.T.Ver, source, vbt, hsplit);
BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main);
END Source.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
