<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/switches/Switches.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/switches/Switches.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Switches</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../lego/src/ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="../../../lego/src/Shadow.i3">Shadow</A>,
       <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../../ui/src/split/HVBar.i3">HVBar</A>;
IMPORT <A HREF="../../../lego/src/GuardedBtnVBT.i3">GuardedBtnVBT</A>, <A HREF="../../../lego/src/QuickSwitchVBT.i3">QuickSwitchVBT</A>, <A HREF="../../../lego/src/TrillSwitchVBT.i3">TrillSwitchVBT</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;
FROM <A HREF="../common/Colors.i3">Colors</A> IMPORT lblue, dblue;

TYPE
  S = ShadowedFeedbackVBT.T;     (* A shorter synonym *)
  TrillSwitch = TrillSwitchVBT.T OBJECT
                  callbackcount := 0;
                OVERRIDES
                  callback := Trill;
                END;

PROCEDURE <A NAME="Guard"><procedure>Guard</procedure></A> (v: GuardedBtnVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    TextVBT.Put(display, &quot;callback of GuardedBtn called&quot;);
  END Guard;

PROCEDURE <A NAME="Quick"><procedure>Quick</procedure></A> (v: QuickSwitchVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    TextVBT.Put(display, &quot;callback of QuickSwitch called&quot;);
  END Quick;

PROCEDURE <A NAME="Trill"><procedure>Trill</procedure></A> (v: TrillSwitch; READONLY cd: VBT.MouseRec) =
  BEGIN
    INC(v.callbackcount);
    TextVBT.Put(display, &quot;callback of TrillSwitch called &quot;
                           &amp; Fmt.Int(v.callbackcount) &amp; &quot; times&quot;);
  END Trill;

CONST
  shsize = 5.0;                  (* shadow size in points *)
  size   = 40.0;                 (* size of textVBT in millimeters *)
VAR
  sh      := Shadow.New(size := shsize, light := lblue, dark := dblue);
  gfb     := NEW(S).init(ch := TextVBT.New(&quot;GuardedBtn&quot;), shadow := sh);
  qfb     := NEW(S).init(ch := TextVBT.New(&quot;QuickSwitch&quot;), shadow := sh);
  tfb     := NEW(S).init(ch := TextVBT.New(&quot;TrillSwitch&quot;), shadow := sh);
  guard   := NEW(GuardedBtnVBT.T, callback := Guard).init(gfb);
  quick   := NEW(QuickSwitchVBT.T, callback := Quick).init(qfb);
  trill   := NEW(TrillSwitch).init(tfb);
  display := TextVBT.New(&quot;&quot;);
  rtext   := RigidVBT.FromHV(TextVBT.New(&quot;Switches&quot;), size, size / 3.0);
  hsplit := HVSplit.Cons(
              Axis.T.Hor, guard, HVBar.New(), quick, HVBar.New(), trill);
  main := HVSplit.Cons(
            Axis.T.Ver, hsplit, HVBar.New(), display, HVBar.New(), rtext);
BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main);
END Switches.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
