<HTML>
<HEAD>
<TITLE>SRC Modula-3: trestle_by_example/src/update/Update.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>trestle_by_example/src/update/Update.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module>Update</module> EXPORTS <A HREF="../../../main/src/Main.i3"><implements>Main</A></implements>;

IMPORT <A HREF="../../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../../ui/src/vbt/VBT.i3">VBT</A>;
IMPORT <A HREF="../../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../../ui/src/split/RigidVBT.i3">RigidVBT</A>, <A HREF="../../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../../ui/src/split/HVSplit.i3">HVSplit</A>;
IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>;                     (* Trestle auxiliary library module. *)
IMPORT <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>;                      (* Standard Modula-3 library module. *)

PROCEDURE <A NAME="DoInc"><procedure>DoInc</procedure></A> (b: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    INC(num);                    (* Change to non-local variable! *)
    TextVBT.Put(text, Fmt.Int(num));
  END DoInc;

PROCEDURE <A NAME="DoExit"><procedure>DoExit</procedure></A> (b: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    Trestle.Delete(main);
  END DoExit;

CONST
  bs = 2.0;                      (* Size of border around main window (in
                                    millimeters). *)
  ws = 20.0;                     (* Width of window around text (in
                                    millimeters). *)

VAR
  num   := 97;                   (* Value for display in text VBT. *)
  item1 := ButtonVBT.New(TextVBT.New(&quot;Inc&quot;), DoInc);
  item2 := ButtonVBT.New(TextVBT.New(&quot;Exit&quot;), DoExit);
  bar   := HVSplit.Cons(Axis.T.Hor, item1, item2);
  line  := RigidVBT.FromHV(TextureVBT.New(), hMin := 0.0, vMin := bs);
  text  := TextVBT.New(Fmt.Int(num));
  work  := RigidVBT.FromHV(text, hMin := ws, vMin := ws / 2.0);
  main  := BorderedVBT.New(HVSplit.Cons(Axis.T.Ver, bar, line, work), bs);

BEGIN
  Trestle.Install(main);
  Trestle.AwaitDelete(main);
END Update.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
