<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/confctl/TrestleConf.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/confctl/TrestleConf.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="../trestle/TrestleConf.i3">TrestleConf</A></implements></module>;
  IMPORT ArgoCtl, ArgoProp, ArgoClient;
  IMPORT <A HREF="../vbt/VBT.i3">VBT</A>;
  IMPORT <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../../../libm3/derived/RefList.i3">RefList</A>, <A HREF="../../../params/src/Env.i3">Env</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../netobjrt/src/NetObj.i3">NetObj</A>;

REVEAL
  <A NAME="User">User</A> = UserPublic BRANDED OBJECT
           valid: BOOLEAN;       (* Is this a real User created by
                                    Trestle? *)
           ccUser: CCUser;
         OVERRIDES
           register := RegisterUser;
         END;

REVEAL
  <A NAME="App">App</A> = AppPublic BRANDED OBJECT
          conf     : Conf;
          handler  : Handler;
          localUser: User;       (* Only used for non-conference mode *)
        OVERRIDES
          init    := InitApp;
          destroy := DestroyApp;
        END;

TYPE
  CCUser = ArgoCtl.User;
  Conf = ArgoCtl.Conf;
  Member = ArgoCtl.Member;
  Members = ArgoCtl.Members;
  Event = ArgoCtl.Event;
  Events = ArgoCtl.Events;
  Tkt = ArgoCtl.Tkt;
  Activity = ArgoCtl.Activity;

CONST
  UserNameProp    = ArgoProp.UserName;
  DisplayNameProp = ArgoProp.DisplayName;
  Global          = NIL;

CONST
  MyEvents = Events{Event.Activated, Event.Deactivated, Event.Joined,
                    Event.Left};
  Active = Activity.Active;
  Either = Activity.Either;
  Any    = NIL;                  (* ArgoCtl wildcard for Confs and Users *)

VAR
  userCreate: UserProc;          (* Trestle-supplied proc to create User
                                    objects *)
</PRE> TrestleConf operates in either Conference mode or Local mode.
   If:
   - the conference-control server is reachable,
   - the local user is found to be registered, and
   - the local user is active in a conference
   then mode = Conference and the application is shared. If any of the above
   conditions fails to hold, then mode = Local and the application is private. 

<P><PRE>TYPE Mode = {Local, Conference};
CONST
  Local      = Mode.Local;
  Conference = Mode.Conference;
VAR
  mode: Mode;
</PRE>** User methods **

<P><PRE>PROCEDURE <A NAME="RegisterUser"><procedure>RegisterUser</procedure></A> (self: User) =
  BEGIN
    IF mode = Conference THEN KnowUser(self) END
  END RegisterUser;
</PRE>** App methods **

<P><PRE>PROCEDURE <A NAME="InitApp"><procedure>InitApp</procedure></A> (self: App; user: User) =
  VAR ccUser: CCUser;
  PROCEDURE Process (m: Member) =
  &lt;* FATAL ArgoCtl.Error, NetObj.Error, Thread.Alerted *&gt;
    VAR
      u: User   := NewUserFromCCUser(m.user(tag := tag));
    BEGIN
      IF u.valid THEN
        self.add(u);
        IF m.active(tag := tag) THEN self.activate(u) END;
      END;
    END Process;
  BEGIN
    IF mode = Conference THEN
      ccUser := FindCCUser(user.name);
      IF ccUser = NIL THEN mode := Local END;
    END;
    IF mode = Conference THEN
      self.conf := CurrentConf(ccUser);
      IF self.conf = NIL THEN mode := Local END;
    END;
    IF mode = Conference THEN
      self.conf := CurrentConf(ccUser);
      VAR rl := ConfMembers(self.conf); BEGIN
        WHILE rl # NIL DO
          Process(rl.head);
          rl := rl.tail
        END
      END;
      (* race here: what if events before we register? *)
      RegisterForEvents(self, self.conf);
    ELSE
      self.localUser := user;
      self.add(user);
      self.activate(user);
    END;
  END InitApp;

PROCEDURE <A NAME="DestroyApp"><procedure>DestroyApp</procedure></A> (self: App) =
  PROCEDURE Process (m: Member) =
    &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
    VAR
      u: User   := KnownUserFromCCUser(m.user(tag := tag));
    BEGIN
      IF u.valid THEN
        IF m.active(tag := tag) THEN self.suspend(u) END;
        self.delete(u);
      END;
    END Process;
  BEGIN
    IF mode = Local THEN
      self.suspend(self.localUser);
      self.delete(self.localUser);
    ELSE
      UnregisterForEvents(self);
      (* race here: what if events after we unregister? *)
      VAR rl := ConfMembers(self.conf); BEGIN
        WHILE rl # NIL DO
          Process(rl.head);
          rl := rl.tail
        END
      END;
    END;
  END DestroyApp;
</PRE>** TrestleConf.Init procedure **

<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (createUser: UserProc) =
  BEGIN
    userCreate := createUser;
    ImportServer();
  END Init;
</PRE>** Routines to access ArgoCtl conference control server **

<P> Import the server as a network object 

<P><PRE>VAR cct: ArgoCtl.T;
    tag: ArgoCtl.Tag;

PROCEDURE <A NAME="ImportServer"><procedure>ImportServer</procedure></A> () =
  BEGIN
    IF Env.Get(&quot;ARGOENABLED&quot;) # NIL THEN
      cct := ArgoClient.ImportServer();
      IF cct = NIL THEN
        mode := Local
      ELSE
        tag := ArgoClient.MakeTag(&quot;TrestleApplication&quot;);
        mode := Conference       (* conf control available =&gt; assume conf
                                    mode *)
      END
    ELSE
      mode := Local;
      cct := NIL
    END
  END ImportServer;
</PRE> ArgoCtl Event callback machinery 

<P><PRE>TYPE
  Handler = ArgoCtl.Handler OBJECT
              app: App;
            OVERRIDES
              joined      := Joined;
              left        := Left;
              activated   := Activated;
              deactivated := Deactivated;
            END;

PROCEDURE <A NAME="RegisterForEvents"><procedure>RegisterForEvents</procedure></A> (app: App; conf: Conf) =
  &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
  VAR myFilter := Members{user := Any, conf := conf, activity := Either};
  BEGIN
    app.handler := NEW(Handler, app := app);
    cct.register(app.handler, MyEvents, myFilter, tag := tag);
  END RegisterForEvents;

PROCEDURE <A NAME="UnregisterForEvents"><procedure>UnregisterForEvents</procedure></A> (app: App) =
  &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
  BEGIN
    cct.unregister(app.handler, tag := tag);
  END UnregisterForEvents;

PROCEDURE <A NAME="Joined"><procedure>Joined</procedure></A> (self: Handler; m: Member; t: Tkt)
  RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* FATAL ArgoCtl.Error *&gt;
  VAR user: User;
  BEGIN
    LOCK VBT.mu DO
      user := NewUserFromCCUser(m.user(t, tag := tag), t);
      IF user.valid THEN self.app.add(user) END;
    END;
  END Joined;

PROCEDURE <A NAME="Left"><procedure>Left</procedure></A> (self: Handler; m: Member; t: Tkt)
  RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* FATAL ArgoCtl.Error *&gt;
  VAR user := KnownUserFromCCUser(m.user(t, tag := tag));
  BEGIN
    IF user.valid THEN LOCK VBT.mu DO self.app.delete(user) END END;
  END Left;

PROCEDURE <A NAME="Activated"><procedure>Activated</procedure></A> (self: Handler; m: Member; t: Tkt)
  RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* FATAL ArgoCtl.Error *&gt;
  VAR user := KnownUserFromCCUser(m.user(t, tag := tag));
  BEGIN
    IF user.valid THEN LOCK VBT.mu DO self.app.activate(user) END END;
  END Activated;

PROCEDURE <A NAME="Deactivated"><procedure>Deactivated</procedure></A> (self: Handler; m: Member; t: Tkt)
  RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* FATAL ArgoCtl.Error *&gt;
  VAR user := KnownUserFromCCUser(m.user(t, tag := tag));
  BEGIN
    IF user.valid THEN LOCK VBT.mu DO self.app.suspend(user) END END;
  END Deactivated;
</PRE> Find CCUser having the given value of the UserNameProp property, or return 
   NIL 

<P><PRE>PROCEDURE <A NAME="FindCCUser"><procedure>FindCCUser</procedure></A> (name: TEXT): CCUser =
  BEGIN
    TRY
      VAR
        user, res: CCUser := NIL;
        cnt := 0;
        rl          := cct.getObjectsWith(UserNameProp, tag := tag);
      BEGIN
        WHILE rl # NIL DO
          user := rl.head;
          IF Text.Equal(name, user.getProp(UserNameProp, tag := tag)) THEN
            res := user;
            INC(cnt);
          END;
          rl := rl.tail
        END;
        IF cnt # 1 THEN
          res := ArgoClient.GetUser(tag := tag, userName := name)
        END;
        RETURN res
      END
    EXCEPT
      NetObj.Error, Thread.Alerted, ArgoCtl.Error =&gt; RETURN NIL
    END;
  END FindCCUser;

PROCEDURE <A NAME="ConfMembers"><procedure>ConfMembers</procedure></A> (conf: Conf): RefList.T =
  &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
  VAR myFilter := Members{user := Any, conf := conf, activity := Either};
  BEGIN
    RETURN cct.getMembers(myFilter, tag := tag)
  END ConfMembers;

PROCEDURE <A NAME="CurrentConf"><procedure>CurrentConf</procedure></A> (ccUser: CCUser): Conf =
  &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
  VAR
    myMemb : Member;
    myMembs := cct.getMembers(
                 Members{user := ccUser, conf := Any, activity := Active}, tag := tag);
  BEGIN
    IF myMembs = NIL THEN
      RETURN NIL
    ELSE
      myMemb := myMembs.head;
      RETURN myMemb.conf(tag := tag)
    END;
  END CurrentConf;
</PRE>**  Procedures to maintain table of known Users  **

<P><PRE>VAR
  table         := NEW(MUTEX);
  users: RefList.T;                 (* List of known user objects *)
</PRE> Add to table of known Users 

<P><PRE>PROCEDURE <A NAME="KnowUser"><procedure>KnowUser</procedure></A> (u: User) =
  BEGIN
    LOCK table DO
      IF NOT KnownUser(u) THEN
        u.ccUser := FindCCUser(u.name);
        u.valid := u.ccUser # NIL;
        users := RefList.Cons(u, users);
      END;
    END;
  END KnowUser;
</PRE> Is User already known? 

<P><PRE>PROCEDURE <A NAME="KnownUser"><procedure>KnownUser</procedure></A> (u: User): BOOLEAN = &lt;* LL = table *&gt;
  VAR ul := users;
  BEGIN
    WHILE ul # NIL DO
      IF ul.head = u THEN RETURN TRUE END;
      ul := ul.tail;
    END;
    RETURN FALSE
  END KnownUser;
</PRE> Find known User given CCUser, else create and register it 

<P><PRE>PROCEDURE <A NAME="NewUserFromCCUser"><procedure>NewUserFromCCUser</procedure></A> (ccUser: CCUser; tkt: Tkt := ArgoCtl.None):
  User =
  &lt;* FATAL NetObj.Error, Thread.Alerted, ArgoCtl.Error *&gt;
  VAR
    result, recheck: User;
    name, disp     : TEXT;
  BEGIN
    LOCK table DO result := UserFromCCUserInternal(ccUser) END;
    IF result = NIL THEN
      name := ccUser.getProp(UserNameProp, Global, tkt, tag := tag);
      disp := ccUser.getProp(DisplayNameProp, Global, tkt, tag := tag);
      result := userCreate(name, disp);
      IF result # NIL THEN
        result.valid := TRUE;
      ELSE
        result := NEW(User, valid := FALSE);
      END;
      result.ccUser := ccUser;
      LOCK table DO              (* recheck, since lock was released
                                    above *)
        recheck := UserFromCCUserInternal(ccUser);
        IF recheck = NIL THEN    (* Did it pop into table when we weren't
                                    looking? *)
          users := RefList.Cons(result, users) (* no *)
        ELSE
          result := recheck;     (* yes *)
        END;
      END;
    END;
    RETURN result
  END NewUserFromCCUser;
</PRE> Find known User given CCUser, else error 

<P><PRE>PROCEDURE <A NAME="KnownUserFromCCUser"><procedure>KnownUserFromCCUser</procedure></A> (ccUser: CCUser): User =
  VAR result: User;
  BEGIN
    LOCK table DO result := UserFromCCUserInternal(ccUser) END;
    &lt;*ASSERT result # NIL *&gt;
    RETURN result
  END KnownUserFromCCUser;
</PRE> Find known User given CCUser, else return NIL 

<P><PRE>PROCEDURE <A NAME="UserFromCCUserInternal"><procedure>UserFromCCUserInternal</procedure></A> (ccUser: CCUser): User = &lt;* LL = table *&gt;
  VAR ul := users; res: User;
  BEGIN
    WHILE ul # NIL DO
      res := ul.head;
      IF res.ccUser = ccUser THEN RETURN res END;
      ul := ul.tail
    END;
    RETURN NIL
  END UserFromCCUserInternal;

BEGIN
END TrestleConf.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
