<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTClient.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTClient.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 

<P>
<P>
<P><PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTClient.i3">NTClient</A></implements></module>;

IMPORT <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="NT.i3">NT</A>, <A HREF="NTClientF.i3">NTClientF</A>, <A HREF="NTMsgs.i3">NTMsgs</A>, <A HREF="NTPaint.i3">NTPaint</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>,
       <A HREF="../split/ProperSplit.i3">ProperSplit</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="../trestle/TrestleImpl.i3">TrestleImpl</A>, <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="../../../win32/src/WinUser.i3">WinUser</A>;
</PRE> IMPORT NTDebug; 

<P><PRE>FROM <A HREF="../vbt/TrestleClass.i3">TrestleClass</A> IMPORT Decoration;
FROM <A HREF="NTClientF.i3">NTClientF</A> IMPORT Child;
FROM <A HREF="TrestleOnNT.i3">TrestleOnNT</A> IMPORT Enter, Exit;

REVEAL
  <A NAME="T">T</A> = NTPaint.T BRANDED OBJECT
      OVERRIDES
        beChild          := BeChild;
        replace          := Replace;
        setcage          := SetCage;
</PRE><BLOCKQUOTE><EM><P>
        sync             := Sync;
        setcursor        := SetCursor;
        newShape         := NewShape;
        readUp           := ReadUp;
        writeUp          := WriteUp;
        redisplay        := Redisplay;
        acquire          := Acquire;
        release          := Release;
        put              := Put;
        forge            := Forge;
</EM></BLOCKQUOTE><PRE>
        attach           := Attach;
        decorate         := Decorate;
        iconize          := Iconize;
        overlap          := Overlap;
        moveNear         := MoveNear;
        getScreens       := GetScreens;
        screenOf         := ScreenOf;
</PRE><BLOCKQUOTE><EM><P>
        installOffscreen := InstallOffscreen;
        setColorMap      := SetColorMap;
        allCeded         := AllCeded;
        tickTime         := TickTime;
</EM></BLOCKQUOTE><PRE>
        trestleId        := TrestleID;
        windowId         := WindowID;
</PRE><BLOCKQUOTE><EM><P>
        updateBuddies    := UpdateBuddies;
</EM></BLOCKQUOTE><PRE>
      END;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A> (trsl: T; ch: VBT.T) RAISES {} =
  BEGIN
    IF ch.upRef = NIL THEN
      ch.upRef := NEW(Child, ch := ch, owns := NEW(NTClientF.OwnsArray, 0))
    ELSE
      WITH ur = NARROW(ch.upRef, Child) DO
        ur.ch := ch;
        ur.owns := NEW(NTClientF.OwnsArray, 0)
      END
    END;
    ch.parent := trsl;
  END BeChild;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (trsl: T; ch, new: VBT.T) RAISES {} =
  VAR ur: Child := ch.upRef;
  BEGIN
    IF new # NIL THEN Crash() END;
    NTClientF.Delete(trsl, ch, ur)
  END Replace;

PROCEDURE <A NAME="SetCage"><procedure>SetCage</procedure></A> (v: T; ch: VBT.T) RAISES {} =
  VAR ur: Child := ch.upRef;
  BEGIN
    WITH cage = VBTClass.Cage(ch) DO
</PRE><BLOCKQUOTE><EM><P>
      NTDebug.PInt(<CODE>NTSetCage v: </CODE>, LOOPHOLE(v, INTEGER));
      NTDebug.PRect(<CODE> </CODE>, cage.rect);
      NTDebug.PText(Fmt.F(<CODE> inout: {%s %s}</CODE>, Fmt.Bool(FALSE IN cage.inOut),
                    Fmt.Bool(TRUE IN cage.inOut)));
      NTDebug.NewLine();
</EM></BLOCKQUOTE><PRE>
      IF ch.st = NIL OR ur = NIL OR ch.parent # v THEN
        IF NOT (TRUE IN cage.inOut) THEN VBTClass.ForceEscape(ch) END;
        RETURN
      END;
      TRY
        Enter(v);
        TRY
          IF ur.cageCovered THEN RETURN END;
          ur.cage := cage;
          ur.everywhereCage := cage = VBT.EverywhereCage;
          IF NOT ur.inside THEN
            IF NOT (TRUE IN cage.inOut) THEN VBTClass.ForceEscape(ch) END
          END
        FINALLY
          Exit(v)
        END
      EXCEPT
        TrestleComm.Failure =&gt;   (* skip *)
      END
    END
  END SetCage;

PROCEDURE <A NAME="Attach"><procedure>Attach</procedure></A> (trsl: T; v: VBT.T) RAISES {} =
  BEGIN
    LOCK v DO LOCK trsl DO ProperSplit.Insert(trsl, NIL, v) END END
  END Attach;

PROCEDURE <A NAME="Decorate"><procedure>Decorate</procedure></A> (trsl: T; v: VBT.T; old, new: Decoration)
  RAISES {TrestleComm.Failure} =
  BEGIN
    TYPECASE v.upRef OF
      NULL =&gt;                    (*skip*)
    | Child (ch) =&gt;
        Enter(trsl);
        TRY
          NTClientF.SetDecoration(trsl, v, ch, ch.hwnd, old, new)
        FINALLY
          Exit(trsl)
        END
    ELSE                         (* skip*)
    END
  END Decorate;

PROCEDURE <A NAME="Iconize"><procedure>Iconize</procedure></A> (trsl: T; v: VBT.T) RAISES {TrestleComm.Failure} =
  VAR alreadyMapped: BOOLEAN;
  BEGIN
    alreadyMapped := v.st # NIL;
    IF alreadyMapped THEN
      VAR
        ur : Child         := v.upRef;
      BEGIN
        Enter(trsl);
        TRY
          NT.Assert(WinUser.CloseWindow(ur.hwnd));
          NTClientF.SetTitle(trsl, v, ur);
        FINALLY
          Exit(trsl)
        END
      END
    ELSE
      NTMsgs.CreateNTWindow(trsl, v, NIL, iconic := TRUE)
    END
  END Iconize;

PROCEDURE <A NAME="Overlap"><procedure>Overlap</procedure></A> (         trsl: T;
                            v   : VBT.T;
                            id  : Trestle.ScreenID;
                   READONLY nw  : Point.T           )
  RAISES {TrestleComm.Failure} =
  BEGIN
    InnerOverlap(trsl, v, id, nw, TRUE)
  END Overlap;

PROCEDURE <A NAME="InnerOverlap"><procedure>InnerOverlap</procedure></A> (         trsl         : T;
                                 v            : VBT.T;
                                 id           : Trestle.ScreenID;
                        READONLY nw           : Point.T;
                                 knownPosition: BOOLEAN;
                                 iconic                            := FALSE)
  RAISES {TrestleComm.Failure} =
  VAR
    st           : NTScreenType.T;
    alreadyMapped: BOOLEAN;
  BEGIN
    LOCK trsl DO
      IF id &lt; FIRST(trsl.screens^) OR id &gt; LAST(trsl.screens^) THEN
        id := trsl.defaultScreen
      END;
      st := trsl.screens[id];
      IF knownPosition OR v.st = NIL OR v.st = st THEN
        alreadyMapped := v.st = st
      ELSE
        alreadyMapped := FALSE;
        FOR i := FIRST(trsl.screens^) TO LAST(trsl.screens^) DO
          IF trsl.screens[i] = v.st THEN
            alreadyMapped := TRUE;
            st := v.st
          END
        END
      END
    END;
    IF alreadyMapped THEN
      VAR ur: Child := v.upRef;
      BEGIN
        Enter(trsl);
        TRY
          NT.Assert(WinUser.SetWindowPos(
                      ur.hwnd, WinUser.HWND_TOP, nw.h, nw.v,
                      Rect.HorSize(v.domain), Rect.VerSize(v.domain),
                      WinUser.SWP_NOZORDER));
          IF iconic THEN
            EVAL WinUser.CloseWindow(ur.hwnd);
          ELSE
            EVAL WinUser.OpenIcon(ur.hwnd);
          END;
          NTClientF.SetTitle(trsl, v, ur);
        FINALLY
          Exit(trsl)
        END
      END
    ELSE
      NTMsgs.CreateNTWindow(trsl, v, st, nw.h, nw.v, iconic := iconic)
    END
  END InnerOverlap;

PROCEDURE <A NAME="MoveNear"><procedure>MoveNear</procedure></A> (trsl: T; v, w: VBT.T) RAISES {TrestleComm.Failure} =
  VAR
    st: NTScreenType.T;
    nw                := Point.T{50, 50};
    ch: Child;
    wtr: Trestle.T;
    id := Trestle.NoScreen;
  BEGIN
    LOOP
      IF w = NIL THEN EXIT END;
      IF NOT TrestleImpl.RootChild(w, wtr, w) THEN w := NIL; EXIT END;
      IF wtr = trsl THEN EXIT END;
      w := w.parent;
    END;
    IF w = v THEN w := NIL END;
    IF w # NIL THEN
      ch := w.upRef;
      IF w.st = NIL THEN w := NIL END
    END;
    IF w # NIL THEN
      st := w.st;
      id := st.screenID;
      Enter(trsl);
      TRY
        NTClientF.ValidateNW(trsl, ch, st);
        nw := Point.Add(nw, ch.nw)
      FINALLY
        Exit(trsl)
      END;
    END;
    InnerOverlap(trsl, v, id, nw, w # NIL)
  END MoveNear;

PROCEDURE <A NAME="GetScreens"><procedure>GetScreens</procedure></A> (trsl: T): Trestle.ScreenArray RAISES {} =
  VAR res: Trestle.ScreenArray;
  BEGIN
    LOCK trsl DO
      res := NEW(Trestle.ScreenArray, NUMBER(trsl.screens^));
      FOR i := 0 TO LAST(res^) DO
        res[i].id := i;
        res[i].dom := trsl.screens[i].rootDom;
        res[i].delta := Point.Origin;
        res[i].type := trsl.screens[i]
      END
    END;
    RETURN res
  END GetScreens;

PROCEDURE <A NAME="ScreenOf"><procedure>ScreenOf</procedure></A> (trsl: T; ch: VBT.T; READONLY pt: Point.T):
  Trestle.ScreenOfRec RAISES {} =
  VAR
    ur : Child               := ch.upRef;
    st : NTScreenType.T      := ch.st;
    res: Trestle.ScreenOfRec;
  BEGIN
    res.trsl := trsl;
    IF st = NIL OR ur = NIL THEN
      res.id := Trestle.NoScreen
    ELSE
      TRY
        Enter(trsl);
        TRY
          res.id := st.screenID;
          res.dom := st.rootDom;
          IF ur.hwnd # NT.CNULL THEN
            NTClientF.ValidateNW(trsl, ur, st);
            res.q := Point.Add(pt, ur.nw)
          ELSE
            res.q := pt
          END
        FINALLY
          Exit(trsl)
        END
      EXCEPT
        TrestleComm.Failure =&gt; res.id := Trestle.NoScreen
      END
    END;
    RETURN res
  END ScreenOf;

PROCEDURE <A NAME="TrestleID"><procedure>TrestleID</procedure></A>(t: T): TEXT =
  BEGIN
    RETURN t.inst
  END TrestleID;

PROCEDURE <A NAME="WindowID"><procedure>WindowID</procedure></A>(&lt;* UNUSED *&gt;t: T; v: VBT.T): TEXT =
  BEGIN
    RETURN Fmt.Unsigned(LOOPHOLE(TrestleOnNT.HWND(v), INTEGER), base := 10)
  END WindowID;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> () =
  BEGIN
    TrestleClass.RegisterConnectClosure(
      NEW(TrestleClass.ConnectClosure, apply := NTClientF.DoConnect));
    NTMsgs.Init();
  END Init;

EXCEPTION Fatal;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;* FATAL Fatal *&gt;
  BEGIN
    RAISE Fatal;
  END Crash;

BEGIN
END NTClient.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
