<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTClientF.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTClientF.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 

<P>
<P><PRE>&lt;*PRAGMA LL*&gt;
</PRE> Partitioning following the efforts of
   Steve.Freeman@computer-lab.cambridge.ac.uk - 92-05-13 

<P><PRE>UNSAFE INTERFACE <interface><A HREF="NTClientF.m3">NTClientF</A></interface>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="NTClient.i3">NTClient</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../split/ProperSplit.i3">ProperSplit</A>,
       <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>;

REVEAL
  TrestleClass.RootVBT &lt;: ProperSplit.T;
  TrestleOnNT.Display &lt;: T_Abs;

TYPE
  <A HREF="NTClientF.m3#T_Abs">T_Abs</A> &lt;: T_Rel;
  T_Rel =
    NTClient.T_Public OBJECT
      (* protection = self *)
      dead (*, hasMessenger, hasSelectThread *) := FALSE;
      vbts : IntRefTbl.T;
      sel: SelArray           := NIL;
      (*params: Trestle.Parameters;*)
      screens: REF ARRAY OF NTScreenType.T;
      (* Types of the screens on the NT server. *)
      defaultScreen: CARDINAL;
      (* index in screens of default screen for this NT server. *)

      (* The next fields are protected by VBT.mu and self *)
      current, mouseFocus: VBT.T := NIL;
      (* The child that has received a FirstDown but no corresponding
         LastUp, or NIL if there is no such child. *)
      otherCages: BOOLEAN := FALSE;

      (* protection = scheduler *)
      inst: TEXT;
    END;

TYPE
  Child = ProperSplit.Child OBJECT
            (* fields below protected by parent lock *)
            hwnd   : WinDef.HWND;
            conn   : NTClient.T;
            nwValid                := FALSE;
            nw     : Point.T;
            (* The nw field is the location of the northwest corner of the
               window on the root window, if nwValid is TRUE.*)
            inside := FALSE;
            (* whether the cursor is inside the window. *)
            isNTFocus, underNTFocus := FALSE;
            (* The boolean isNTFocus is true if this window has the X
               keyboard focus, and underNTFocus is true if the XNTkeyboard
               focus is an ancestor of this window. *)
            owns           : OwnsArray := NIL;
            recentlyOutside            := TRUE;
            (* true if the cursor has been outside our window since the
               last time a takefocus message was sent *)
            width, height: CARDINAL;
            (* width and height of NT window. *)
            oldWidth, oldHeight                        := LAST(INTEGER);
            serial             : Ctypes.UnsignedLong;
            userPosition                               := FALSE;
            (* indicates whether the position to be set was generated by a
               user-specification in global coordinates *)
            (* everywhereCage = TRUE, =&gt; ignore all mouse motion events *)
            everywhereCage: BOOLEAN    := TRUE;
            cage          : VBT.Cage;
            badR                       := Region.Empty;
            (* The actual bad region of a Child ur is ur.badR union
               bad(ur.ch). *)
            sh, sv: VBT.SizeRange;
            (* The last hor and ver sizeranges that were reported to NT. *)
            csid: WinDef.HCURSOR;
            (* The last cursor that was reported to NT. *)
            cageCovered := FALSE;
            (* TRUE during delivery of a button click, to avoid setting the
               cage twice. *)
          END;

TYPE
  SelectionRecord = RECORD
                      v   : VBT.T         := NIL;
                      ts  : VBT.TimeStamp := 0;
                    END;

  SelArray = REF ARRAY OF SelectionRecord;

  OwnsArray = REF ARRAY OF BOOLEAN;

TYPE
  NewScreenProp = REF RECORD
                        len, format: INTEGER;
                        data       : REF ARRAY OF Ctypes.char
                      END;

PROCEDURE <A HREF="NTClientF.m3#Kill">Kill</A> (trsl: NTClient.T);
&lt;* LL.sup = trsl *&gt;
</PRE><BLOCKQUOTE><EM> clean way to close a Trestle </EM></BLOCKQUOTE><PRE>
</PRE> ---------- various utilities ---------- 
<PRE>PROCEDURE <A HREF="NTClientF.m3#ValidateNW">ValidateNW</A> (trsl: NTClient.T; ch: Child; st: NTScreenType.T)
  RAISES {TrestleComm.Failure};

PROCEDURE <A HREF="NTClientF.m3#SetTitle">SetTitle</A>(trsl: NTClient.T; v: VBT.T; ch: Child) RAISES {TrestleComm.Failure};
&lt;* LL = trsl *&gt;

PROCEDURE <A HREF="NTClientF.m3#SetDecoration">SetDecoration</A> (trsl    : NTClient.T;
                         v       : VBT.T;
                         ch      : Child;
                         hwnd    : WinDef.HWND;
                         old, new: TrestleClass.Decoration)
  RAISES {TrestleComm.Failure};

PROCEDURE <A HREF="NTClientF.m3#GetDomain">GetDomain</A> (ur: Child; VAR (* OUT*) width, height: CARDINAL);
</PRE><BLOCKQUOTE><EM> Return the domain of ur's NT window, or 0,0 when the window is unmapped,
   and clear ur.reshapeComing.  LL = ur.ch.parent </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NTClientF.m3#AdjustCoverage">AdjustCoverage</A> (xcon: NTClient.T; d: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure};
</PRE><BLOCKQUOTE><EM> see TrestleOnNT.Enter() </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NTClientF.m3#Delete">Delete</A> (trsl: NTClient.T; ch: VBT.T; ur: Child);

PROCEDURE <A HREF="NTClientF.m3#Reshape">Reshape</A> (ch: VBT.T; width, height: CARDINAL; sendMoved := FALSE);
</PRE><BLOCKQUOTE><EM> Reshape ch to new width and height.  LL = VBT.mu </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="NTClientF.m3#Connect">Connect</A> (inst: TEXT; t: NTClient.T := NIL): Trestle.T
  RAISES {TrestleComm.Failure};
</PRE><BLOCKQUOTE><EM> If t is NIL, allocate a new T and return it.  In any case, connect
   t to the X server named inst. </EM></BLOCKQUOTE><PRE>
</PRE> ---------- connection management ---------- 
<PRE>PROCEDURE <A HREF="NTClientF.m3#DoConnect">DoConnect</A> (             self     : TrestleClass.ConnectClosure;
                                  inst     : TEXT;
                                  localOnly: BOOLEAN;
                     VAR (* OUT*) t        : Trestle.T                    ):
  BOOLEAN;
</PRE><BLOCKQUOTE><EM> Apply procedure for TrestleClass.ConnectClosure.  Establishes connection
   with NT server </EM></BLOCKQUOTE><PRE>

END NTClientF.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
