<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTDebug.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTDebug.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                         </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="NTDebug.i3">NTDebug</A></implements></module>;
</PRE> Writes messages to a visible console log 

<P><PRE>IMPORT <A HREF="../../../os/src/WIN32/FileWin32.i3">FileWin32</A>, <A HREF="../../../rw/src/Common/FileWr.i3">FileWr</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../../win32/src/WinBase.i3">WinBase</A>, <A HREF="../../../win32/src/WinCon.i3">WinCon</A>, <A HREF="../../../rw/src/Common/Wr.i3">Wr</A>;

&lt;* FATAL OSError.E, Wr.Failure, Thread.Alerted *&gt;

PROCEDURE <A NAME="NewLine"><procedure>NewLine</procedure></A>() =
  BEGIN
   Wr.PutText(con, &quot;\r\n&quot;);
    Wr.Flush(con);
  END NewLine;

PROCEDURE <A NAME="PText"><procedure>PText</procedure></A> (msg: TEXT; data: TEXT := &quot;&quot;) =
  BEGIN
    Wr.PutText(con, Fmt.F(&quot;%s%s&quot;, msg, data));
    Wr.Flush(con);
  END PText;

PROCEDURE <A NAME="PBool"><procedure>PBool</procedure></A> (msg: TEXT; b: BOOLEAN)  =
  VAR data: TEXT;
  BEGIN
    IF b THEN
      data := &quot;TRUE&quot;
    ELSE
      data := &quot;FALSE&quot;
    END;
    Wr.PutText(con, Fmt.F(&quot;%s %s&quot;, msg, data));
    Wr.Flush(con);
  END PBool;

PROCEDURE <A NAME="PInt"><procedure>PInt</procedure></A> (msg: TEXT; int: INTEGER)  =
  VAR data := Fmt.Int(int);
  BEGIN
    Wr.PutText(con, Fmt.F(&quot;%s %s&quot;, msg, data));
    Wr.Flush(con);
  END PInt;

PROCEDURE <A NAME="PPoint"><procedure>PPoint</procedure></A> (msg: TEXT; READONLY pt: Point.T)  =
  VAR data := Fmt.F(&quot;%s (%s, %s) &quot;, msg, Fmt.Int(pt.h), Fmt.Int(pt.v));
  BEGIN
    Wr.PutText(con, data);
    Wr.Flush(con);
  END PPoint;

PROCEDURE <A NAME="PRect"><procedure>PRect</procedure></A> (msg: TEXT; READONLY r: Rect.T) =
  VAR
    data := Fmt.F(&quot;%s (%s, %s, %s, %s) &quot;, msg, Fmt.Int(r.west), Fmt.Int(r.east),
                  Fmt.Int(r.north), Fmt.Int(r.south));
  BEGIN
    Wr.PutText(con, data);
    Wr.Flush(con);
  END PRect;

VAR
  con: FileWr.T;

BEGIN
  EVAL WinCon.AllocConsole();
    con := NEW(FileWr.T).init(FileWin32.New(
                               WinBase.GetStdHandle(WinBase.STD_OUTPUT_HANDLE),
                               FileWin32.Write));
END NTDebug.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
