<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTPaint.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTPaint.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTPaint.i3">NTPaint</A></implements></module>;

IMPORT <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchRep.i3">BatchRep</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="NT.i3">NT</A>, <A HREF="NTClientF.i3">NTClientF</A>, <A HREF="NTScrnPxmp.i3">NTScrnPxmp</A>, <A HREF="NTScreenType.i3">NTScreenType</A>,
       <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A>, <A HREF="../../../geometry/src/Path.i3">Path</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../../../geometry/src/Trapezoid.i3">Trapezoid</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinGDI.i3">WinGDI</A>,
       <A HREF="../../../win32/src/WinUser.i3">WinUser</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

FROM <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A> IMPORT CommandPtr;

REVEAL
  <A NAME="T">T</A> = TrestleOnNT.Display BRANDED OBJECT
      OVERRIDES
        paintbatch    := PaintBatch;
      END;

TYPE PC = PaintPrivate.PaintCommand;

CONST ComSize = ADRSIZE(PaintPrivate.CommandRec);

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A> (v: T; ch: VBT.T; ba: Batch.T) RAISES {} =
  VAR
    cmd : CommandPtr;
    ur  : NTClientF.Child := ch.upRef;
    w   : WinDef.HWND;
    hdc : WinDef.HDC;
    pAdr                  := ADR(ba.b[0]);
    endP                  := ba.next;
    st  : NTScreenType.T  := ch.st;
  BEGIN
    IF ba.clip.west &gt;= ba.clip.east OR st = NIL THEN
      Batch.Free(ba);
      RETURN
    END;
    IF ba.clipped = BatchUtil.ClipState.Unclipped THEN
      BatchUtil.Clip(ba)
    END;
    TRY
      TrestleOnNT.Enter(v);
      TRY
        w := ur.hwnd;
        hdc := WinUser.GetDC(w);
        WHILE pAdr &lt; endP DO
          cmd := pAdr;
          CASE cmd.command OF
            PC.TintCom =&gt; pAdr := TintCom(cmd, pAdr, endP, hdc, st);
          | PC.TextureCom =&gt; pAdr := TextureCom(cmd, pAdr, endP, hdc, st);
          | PC.PixmapCom =&gt; pAdr := PixmapCom(cmd, pAdr, endP, hdc, st);
          | PC.ScrollCom =&gt; pAdr := ScrollCom(cmd, pAdr, hdc, ur, st);
          | PC.TrapCom =&gt; pAdr := TrapCom(cmd, pAdr, endP, hdc, st);
          | PC.TextCom =&gt; pAdr := TextCom(cmd, pAdr, endP, hdc, st, ba);
          | PC.ExtensionCom =&gt;
              pAdr := ExtensionCom(cmd, pAdr, endP, hdc, v, st);
          | PC.RepeatCom =&gt; INC(pAdr, ComSize)
          ELSE
            RETURN
          END
        END
      FINALLY
        Batch.Free(ba);
        TrestleOnNT.Exit(v)
      END
    EXCEPT
      TrestleComm.Failure =&gt;     (* skip *)
    END
  END PaintBatch;

TYPE
  Bits = ARRAY [0..7] OF Word.T;
  PackedDIB = RECORD
    bi: WinGDI.BITMAPINFO;
    (* space for second rgb entry *)
    rgb2: WinGDI.RGBQUAD := WinGDI.RGBQUAD{0, 0, 0, 0};
    bits: Bits := Bits{0, ..};
  END;

VAR
  SolidDIB: PackedDIB := PackedDIB{
    bi := WinGDI.BITMAPINFO {
      bmiColors := ARRAY [0 .. 0] OF WinGDI.RGBQUAD{WinGDI.RGBQUAD{0, 0, 0, 0}},
      bmiHeader := WinGDI.BITMAPINFOHEADER {
            biSize := BYTESIZE(WinGDI.BITMAPINFOHEADER),
            biWidth := 8,
            biHeight := 8,
            biPlanes := 1,
            biBitCount := 1,
            biCompression := WinGDI.BI_RGB,
            biSizeImage := 0,
            biXPelsPerMeter := 1, (* ??? *)
            biYPelsPerMeter := 1,
            biClrUsed := 1,
            biClrImportant := 0}}};

PROCEDURE <A NAME="TintCom"><procedure>TintCom</procedure></A> (cmd       : CommandPtr;
                   pAdr, endP: ADDRESS;
                   hdc       : WinDef.HDC;
                   st        : NTScreenType.T): CommandPtr
  RAISES {TrestleComm.Failure} =
  VAR
    rpt     : CommandPtr;
    hbr: WinDef.HBRUSH;
  BEGIN
    TRY
      WITH op = LOOPHOLE(cmd, PaintPrivate.TintPtr) DO
        INC(pAdr, ADRSIZE(op^));
        WITH tbl = st.optable[op.op] DO
          NT.Assert(WinGDI.SetROP2(hdc, tbl.rop));
          hbr := WinGDI.CreateSolidBrush(16_1000000 + tbl.fg);
        END;
        FillRect(hdc, op.clip, hbr);
        LOOP
          IF pAdr &gt;= endP THEN EXIT END;
          rpt := pAdr;
          IF rpt.command # PC.RepeatCom THEN EXIT END;
          INC(pAdr, ComSize);
          FillRect(hdc, rpt.clip, hbr)
        END
      END;
    FINALLY
      NT.Assert(WinGDI.DeleteObject(hbr));
    END;
    RETURN pAdr;
  END TintCom;

PROCEDURE <A NAME="TextureCom"><procedure>TextureCom</procedure></A> (cmd       : CommandPtr;
                      pAdr, endP: ADDRESS;
                      hdc       : WinDef.HDC;
                      st        : NTScreenType.T  ): CommandPtr
  RAISES {TrestleComm.Failure} =
  BEGIN
   NT.Assert(0);
  END TextureCom;

PROCEDURE <A NAME="PixmapCom"><procedure>PixmapCom</procedure></A> (cmd       : CommandPtr;
                     pAdr, endP: ADDRESS;
                     hdc: WinDef.HDC;
                     st        : NTScreenType.T  ): CommandPtr
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);
  END PixmapCom;

PROCEDURE <A NAME="ScrollCom"><procedure>ScrollCom</procedure></A> (cmd : CommandPtr;
                     pAdr: ADDRESS;
                     hdc: WinDef.HDC;
                     ur  : NTClientF.Child;
                     st  : NTScreenType.T   ): CommandPtr
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);
  END ScrollCom;

PROCEDURE <A NAME="TrapCom"><procedure>TrapCom</procedure></A> (cmd       : CommandPtr;
                   pAdr, endP: ADDRESS;
                   hdc: WinDef.HDC;
                   st        : NTScreenType.T  ): CommandPtr
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);
  END TrapCom;

PROCEDURE <A NAME="TextCom"><procedure>TextCom</procedure></A> (cmd       : CommandPtr;
                   pAdr, endP: ADDRESS;
                   hdc: WinDef.HDC;
                   st        : NTScreenType.T;
                   ba        : Batch.T        ): CommandPtr
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);
  END TextCom;

PROCEDURE <A NAME="ExtensionCom"><procedure>ExtensionCom</procedure></A> (cmd       : CommandPtr;
                        pAdr, endP: ADDRESS;
                        hdc: WinDef.HDC;
                        v         : T;
                        st        : NTScreenType.T  ): CommandPtr
  RAISES {TrestleComm.Failure} =
  &lt;* FATAL Path.Malformed *&gt;
  BEGIN
     NT.Assert(0);
  END ExtensionCom;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Div"><procedure>Div</procedure></A> (n: INTEGER; d: CARDINAL): INTEGER =
  BEGIN
    RETURN n DIV d
  END Div;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Mod"><procedure>Mod</procedure></A> (n: INTEGER; d: CARDINAL): INTEGER =
  BEGIN
    RETURN n MOD d
  END Mod;
</PRE> Steve: M2+E requires these versions of Div and Mod:
<P>
   PROCEDURE Div(n: INTEGER; d: CARDINAL): INTEGER; BEGIN IF n &gt;= 0 THEN
   RETURN n DIV d ELSE RETURN -1 - (-n - 1) DIV d END END Div;
<P>
   PROCEDURE Mod(n: INTEGER; d: CARDINAL): INTEGER; BEGIN IF n &gt;= 0 THEN
   RETURN n MOD d ELSE RETURN d - 1 - (-n - 1) MOD d END END Mod; 

<P><PRE>PROCEDURE <A NAME="HW"><procedure>HW</procedure></A> (READONLY m: Trapezoid.Rational;
              READONLY p: Point.T;
                       v: INTEGER             ): INTEGER =
  (* Return ceiling of the h-coordinate of the intersection of the
     trapezoid edge determined by (m, p) with the horizontal line at height
     v. *)
  BEGIN
    RETURN p.h + Div(m.d * (v - p.v) + m.n - 1, m.n)
  END HW;

PROCEDURE <A NAME="HF"><procedure>HF</procedure></A> (READONLY m: Trapezoid.Rational;
              READONLY p: Point.T;
                       v: INTEGER             ): INTEGER =
  (* Return fractional part of (ceiling - actual) of intersection above *)
  BEGIN
    RETURN Mod(-m.d * (v - p.v), m.n)
  END HF;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="FillRect"><procedure>FillRect</procedure></A> (hdc: WinDef.HDC; READONLY r: Rect.T; hbr: WinDef.HBRUSH)
  RAISES {TrestleComm.Failure} =
  BEGIN
    IF r.west &lt; r.east THEN
      VAR rc := NT.FromRect(r); oldBr := WinGDI.SelectObject(hdc, hbr);
      BEGIN
        (* NT.Assert(WinUser.FillRect(hdc, ADR(rc), hbr)); *)
        EVAL WinGDI.SelectObject(hdc, WinGDI.GetStockObject(WinGDI.NULL_PEN));
        NT.Assert(WinGDI.Rectangle(hdc, r.west, r.north, r.east+1, r.south+1));
        EVAL WinGDI.SelectObject(hdc, oldBr);
      END;
    END;
  END FillRect;

BEGIN
END NTPaint.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
