<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScreenType.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScreenType.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 

<P>
<P><PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScreenType.i3">NTScreenType</A></implements></module>;

IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="NTClient.i3">NTClient</A>, <A HREF="NTMsgs.i3">NTMsgs</A>, <A HREF="NTScrnCmap.i3">NTScrnCmap</A>, <A HREF="NTScrnCrsr.i3">NTScrnCrsr</A>, <A HREF="NTScrnFont.i3">NTScrnFont</A>,
       <A HREF="NTScrnPntOp.i3">NTScrnPntOp</A>, <A HREF="NTScrnPxmp.i3">NTScrnPxmp</A>, <A HREF="NTScrnTpRep.i3">NTScrnTpRep</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinGDI.i3">WinGDI</A>, <A HREF="../../../win32/src/WinUser.i3">WinUser</A>;

CONST
  Black = 16_0;
  White = 16_FFFFFF;

REVEAL
  <A NAME="T">T</A> = NTScrnPntOp.T BRANDED OBJECT END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (trsl: NTClient.T; i: INTEGER): T =
  VAR
    res             := NEW(T, trsl := trsl);
    hdc: WinDef.HDC;
  BEGIN
    TRY
      TrestleOnNT.Enter(trsl);
      TRY
        hdc := WinUser.GetDC(NTMsgs.NullWindow(trsl));

        (* res.depth &gt; 0, since the default visual must be supported. *)
        res.depth := WinGDI.GetDeviceCaps(hdc, WinGDI.BITSPIXEL);
        res.color := TRUE;       (* ??? *)
        WITH hpal = WinGDI.GetCurrentObject(hdc, WinGDI.OBJ_PAL) DO
          res.bg := WinGDI.GetNearestPaletteIndex(hpal, White);
          res.fg := WinGDI.GetNearestPaletteIndex(hpal, Black);
        END;
        New2(hdc, i, res);
        res.font := NTScrnFont.NewOracle(res);
        res.cmap := NTScrnCmap.NewOracle(res);
        res.nullCursor := NTScrnCrsr.NullCursor()
      FINALLY
        TrestleOnNT.Exit(trsl)
      END;
      res.bits := NewDepthOne(trsl, hdc, i)
    EXCEPT
      TrestleComm.Failure =&gt;     (*skip*)
    END;
    RETURN res
  END New;

PROCEDURE <A NAME="New2"><procedure>New2</procedure></A> (hdc: WinDef.HDC; i: INTEGER; res: T)
  RAISES {TrestleComm.Failure} =
  (* The initialization common to st and st.bits.  LL = trsl *)
  VAR
    w := WinGDI.GetDeviceCaps(hdc, WinGDI.HORZRES);
    h := WinGDI.GetDeviceCaps(hdc, WinGDI.VERTRES);
  BEGIN
    res.rootDom := Rect.FromSize(w, h);
    res.res[Axis.T.Hor] :=
      FLOAT(WinGDI.GetDeviceCaps(hdc, WinGDI.HORZSIZE)) / FLOAT(w);
    res.res[Axis.T.Ver] :=
      FLOAT(WinGDI.GetDeviceCaps(hdc, WinGDI.VERTSIZE)) / FLOAT(h);
    res.op := NTScrnPntOp.NewOracle(res);
    res.cursor := NTScrnCrsr.NewOracle(res);
    res.pixmap := NTScrnPxmp.NewOracle(res);
    res.optable :=
      NEW(REF ARRAY OF NTScrnTpRep.OpRecord, NUMBER(PaintOp.Predefined));
    res.pmtable := NEW(REF ARRAY OF NTScrnTpRep.PixmapRecord,
                       NUMBER(Pixmap.Predefined));
    res.screenID := i;
  END New2;

PROCEDURE <A NAME="NewDepthOne"><procedure>NewDepthOne</procedure></A> (trsl: NTClient.T; hdc: WinDef.HDC; i: INTEGER):
  T =
  VAR res := NEW(T, trsl := trsl);
  BEGIN
    TRY
      TrestleOnNT.Enter(trsl);
      TRY
        res.depth := 1;
        res.color := FALSE;
        res.bg := 0;
        res.fg := 1;
        res.bits := res;
        New2(hdc, i, res);
        res.font := NTScrnFont.NewOracle(res, TRUE);
        res.cmap := NIL
      FINALLY
        TrestleOnNT.Exit(trsl)
      END
    EXCEPT
      TrestleComm.Failure =&gt;    (*skip*)
    END;
    RETURN res
  END NewDepthOne;

BEGIN
END NTScreenType.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
