<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScrnCmap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScrnCmap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScrnCmap.i3">NTScrnCmap</A></implements></module>;

IMPORT <A HREF="NT.i3">NT</A>, <A HREF="NTMsgs.i3">NTMsgs</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="NTScrnTpRep.i3">NTScrnTpRep</A>, <A HREF="../vbt/ScrnColorMap.i3">ScrnColorMap</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinGDI.i3">WinGDI</A>, <A HREF="../../../win32/src/WinUser.i3">WinUser</A>;

TYPE
  ColorMapOracle =
    ScrnColorMap.Oracle OBJECT
      st       : NTScreenType.T;
      defaultCM: NTColorMap;
    METHODS
      &lt;* LL.sup = SELF.st.trsl *&gt;
      init (st: NTScreenType.T):
            ColorMapOracle RAISES {TrestleComm.Failure} := InitColorMapOracle;
    OVERRIDES
      standard := ColorMapDefault;
      new      := ColorMapNew;
      list     := ColorMapList;
      lookup   := ColorMapLookup
    END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: NTScreenType.T):
  ScrnColorMap.Oracle RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NEW(ColorMapOracle).init(scrn)
  END NewOracle;

TYPE
  Prim = ScrnColorMap.Primary;
  NTColorMap = ScrnColorMap.T OBJECT
                st    : NTScreenType.T;
                direct: BOOLEAN;
                hpal   : WinDef.HPALETTE;
              OVERRIDES
                fromRGB := ColorMapFromRGB;
                new     := ColorMapCube;
                read    := ColorMapRead;
                write   := ColorMapWrite;
                free    := ColorMapFreeCube;
              END;
</PRE><BLOCKQUOTE><EM> For all v: VBT.T, all cm: NTColorMap, cm &lt; v </EM></BLOCKQUOTE><PRE>

PROCEDURE <A NAME="ColorMapID"><procedure>ColorMapID</procedure></A> (cm: ScrnColorMap.T): WinDef.HPALETTE =
  BEGIN
    TYPECASE cm OF
      NULL =&gt; RETURN NT.CNULL
    | NTColorMap (cm) =&gt; RETURN cm.hpal
    ELSE
      RETURN NT.CNULL
    END
  END ColorMapID;

PROCEDURE <A NAME="ColorMapFromRGB"><procedure>ColorMapFromRGB</procedure></A> (cm  : NTColorMap;
                           rgb : ScrnColorMap.RGB;
                           mode: ScrnColorMap.Mode ): ScrnColorMap.Pixel
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
 END ColorMapFromRGB;

PROCEDURE <A NAME="ColorMapRead"><procedure>ColorMapRead</procedure></A> (cm: NTColorMap; VAR res: ARRAY OF ScrnColorMap.Entry)
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapRead;

PROCEDURE <A NAME="ColorMapWrite"><procedure>ColorMapWrite</procedure></A> (         cm : NTColorMap;
                         READONLY new: ARRAY OF ScrnColorMap.Entry)
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapWrite;

PROCEDURE <A NAME="ColorMapCube"><procedure>ColorMapCube</procedure></A> (cm: NTColorMap; d: CARDINAL): ScrnColorMap.Cube
  RAISES {ScrnColorMap.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapCube;

PROCEDURE <A NAME="ColorMapFreeCube"><procedure>ColorMapFreeCube</procedure></A> (cm: NTColorMap; READONLY cb: ScrnColorMap.Cube)
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END ColorMapFreeCube;

TYPE Card16 = BITS 16 FOR [0 .. 16_ffff];

PROCEDURE <A NAME="InitColorMapOracle"><procedure>InitColorMapOracle</procedure></A> (orc: ColorMapOracle; st: NTScreenType.T):
  ColorMapOracle RAISES {TrestleComm.Failure}
  &lt;* LL.sup = st.trsl *&gt; =
  VAR
    hpal := WinGDI.GetCurrentObject(
              WinUser.GetDC(NTMsgs.NullWindow(st.trsl)), WinGDI.OBJ_PAL);
  BEGIN
    orc.st := st;
    orc.defaultCM := InnerColorMapNew(orc, hpal, TRUE (* ??? *));
    RETURN orc
  END InitColorMapOracle;

PROCEDURE <A NAME="ColorMapDefault"><procedure>ColorMapDefault</procedure></A> (orc: ColorMapOracle): ScrnColorMap.T RAISES {} =
  BEGIN
    RETURN orc.defaultCM
  END ColorMapDefault;

PROCEDURE <A NAME="ColorMapList"><procedure>ColorMapList</procedure></A> (&lt;*UNUSED*&gt; orc       : ColorMapOracle;
                        &lt;*UNUSED*&gt; pat       : TEXT;
                        &lt;*UNUSED*&gt; maxResults: CARDINAL        ):
  REF ARRAY OF TEXT RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapList;

PROCEDURE <A NAME="ColorMapLookup"><procedure>ColorMapLookup</procedure></A> (&lt;*UNUSED*&gt; orc: ColorMapOracle;
                          &lt;*UNUSED*&gt; pat: TEXT            ): ScrnColorMap.T
  RAISES {} =
  BEGIN
    RETURN NIL
  END ColorMapLookup;

PROCEDURE <A NAME="ColorMapNew"><procedure>ColorMapNew</procedure></A> (           orc      : ColorMapOracle;
                                  nm       : TEXT             := NIL;
                       &lt;*UNUSED*&gt; preLoaded                   := TRUE ):
  ScrnColorMap.T RAISES {TrestleComm.Failure} =
  VAR
    res : ScrnColorMap.T;
  BEGIN
    IF orc.defaultCM.readOnly THEN RETURN orc.defaultCM END;
    TrestleOnNT.Enter(orc.st.trsl);
    TRY
      NT.Assert(0); (* NYI *)
      RETURN res
    FINALLY
      TrestleOnNT.Exit(orc.st.trsl)
    END
  END ColorMapNew;

PROCEDURE <A NAME="InnerColorMapNew"><procedure>InnerColorMapNew</procedure></A> (orc     : ColorMapOracle;
                            hpal    : WinDef.HPALETTE;
                            readOnly: BOOLEAN          ): NTColorMap =
  BEGIN
    RETURN
      NEW(NTColorMap, st := orc.st, hpal := hpal, readOnly := readOnly)
  END InnerColorMapNew;

BEGIN
END NTScrnCmap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
