<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScrnCrsr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScrnCrsr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScrnCrsr.i3">NTScrnCrsr</A></implements></module>;

IMPORT <A HREF="../vbt/Cursor.i3">Cursor</A>, <A HREF="NT.i3">NT</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="../vbt/ScrnCursor.i3">ScrnCursor</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="TrestleOnNT.i3">TrestleOnNT</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../win32/src/WinNT.i3">WinNT</A>, <A HREF="../../../win32/src/WinUser.i3">WinUser</A>;

REVEAL <A NAME="T">T</A> = T_Pub BRANDED OBJECT  END;

TYPE
  CursorOracle = ScrnCursor.Oracle OBJECT
                   st: NTScreenType.T;
                 OVERRIDES
                   load    := CursorRegister;
                   list    := CursorList;
                   lookup  := CursorLookup;
                   builtIn := CursorBuiltIn
                 END;

  NTCursor = ScrnCursor.T OBJECT
            OVERRIDES
              unload   := CursorUnregister;
              localize := CursorLocalize
            END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: NTScreenType.T): ScrnCursor.Oracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NEW(CursorOracle, st := scrn)
  END NewOracle;

PROCEDURE <A NAME="NullCursor"><procedure>NullCursor</procedure></A> (): WinDef.HCURSOR
  RAISES {TrestleComm.Failure} &lt;* LL.sup = trsl, such that trsl.dpy = dpy *&gt; =
  BEGIN
    RETURN WinUser.LoadCursor(
             NT.CNULL, LOOPHOLE(WinUser.IDC_ARROW, WinNT.LPCTSTR));
  END NullCursor;

PROCEDURE <A NAME="CursorRegister"><procedure>CursorRegister</procedure></A> (                    orc: CursorOracle;
                                     READONLY c  : ScrnCursor.Raw;
                          &lt;*UNUSED*&gt;          nm : TEXT             := NIL):
  ScrnCursor.T RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
 END CursorRegister;

PROCEDURE <A NAME="CursorList"><procedure>CursorList</procedure></A> (&lt;*UNUSED*&gt; orc       : CursorOracle;
                      &lt;*UNUSED*&gt; pat       : TEXT;
                      &lt;*UNUSED*&gt; maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END CursorList;

PROCEDURE <A NAME="CursorLookup"><procedure>CursorLookup</procedure></A> (orc: CursorOracle; name: TEXT): ScrnCursor.T
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
    RETURN NIL
  END CursorLookup;

PROCEDURE <A NAME="CursorBuiltIn"><procedure>CursorBuiltIn</procedure></A> (orc: CursorOracle; cs: Cursor.Predefined):
  ScrnCursor.T =
  VAR hc: WinDef.HCURSOR;
      trsl := orc.st.trsl;
  BEGIN
    TRY
      TrestleOnNT.Enter(trsl);
      TRY
        CASE cs OF
          Cursor.DontCare.cs =&gt; RETURN ScrnCursor.DontCare
        | Cursor.TextPointer.cs =&gt;
            hc := WinUser.LoadCursor(NT.CNULL, WinUser.IDC_IBEAM);
        | Cursor.NotReady.cs =&gt;
            hc := WinUser.LoadCursor(NT.CNULL, WinUser.IDC_WAIT);
        ELSE
          hc := NT.CNULL;
        END
      FINALLY
        TrestleOnNT.Exit(trsl)
      END
    EXCEPT
      TrestleComm.Failure =&gt; RETURN ScrnCursor.DontCare
    END;
    RETURN NEW(NTCursor, id := LOOPHOLE(hc, INTEGER))
  END CursorBuiltIn;

PROCEDURE <A NAME="CursorLocalize"><procedure>CursorLocalize</procedure></A> (&lt;*UNUSED*&gt; cs: NTCursor): ScrnCursor.Raw
  RAISES {TrestleComm.Failure, ScrnCursor.Failure} =
  BEGIN
    RAISE ScrnCursor.Failure
  END CursorLocalize;

PROCEDURE <A NAME="CursorUnregister"><procedure>CursorUnregister</procedure></A> (&lt;*UNUSED*&gt; cs: NTCursor)
  RAISES {TrestleComm.Failure} =
  BEGIN
  END CursorUnregister;

BEGIN
END NTScrnCrsr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
