<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScrnFont.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScrnFont.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScrnFont.i3">NTScrnFont</A></implements></module>;

IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="../../../C/src/Common/M3toC.i3">M3toC</A>, <A HREF="NT.i3">NT</A>, <A HREF="NTScreenType.i3">NTScreenType</A>,
       <A HREF="NTScrnTpRep.i3">NTScrnTpRep</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/ScrnFont.i3">ScrnFont</A>, <A HREF="../../../text/src/Text.i3">Text</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>,
       <A HREF="TrestleOnNT.i3">TrestleOnNT</A> ;

TYPE
  DeepFontOracle =
    ScrnFont.Oracle OBJECT
      st: NTScreenType.T;
    METHODS
      init (st: NTScreenType.T): DeepFontOracle := DeepInitFontOracle;
      (* LL = st.trsl *)
    OVERRIDES
      list    := DeepFontList;
      match   := DeepFontMatch;
      lookup  := DeepFontLookup;
      builtIn := DeepFontBuiltIn
    END;
  FontOracle =
    ScrnFont.Oracle OBJECT
      st: NTScreenType.T;
    METHODS
      init (st: NTScreenType.T): FontOracle RAISES {TrestleComm.Failure} := InitFontOracle;
      (* LL = st.trsl *)
    OVERRIDES
      list    := FontList;
      match   := FontMatch;
      lookup  := FontLookup;
      builtIn := FontBuiltIn
    END;
  NTFont = ScrnFont.T;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (scrn: NTScreenType.T; depthOne := FALSE): ScrnFont.Oracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    IF depthOne THEN
      RETURN NEW(FontOracle).init(scrn);
    ELSE
      RETURN NEW(DeepFontOracle).init(scrn);
    END;
  END NewOracle;

PROCEDURE <A NAME="DeepFontMatch"><procedure>DeepFontMatch</procedure></A> (orc            : DeepFontOracle;
                         family         : TEXT;
                         pointSize      : INTEGER;
                         slant          : ScrnFont.Slant;
                         maxResults     : CARDINAL;
                         weightName     : TEXT;
                         version        : TEXT;
                         foundry        : TEXT;
                         width          : TEXT;
                         pixelsize      : INTEGER;
                         hres, vres     : INTEGER;
                         spacing        : ScrnFont.Spacing;
                         averageWidth   : INTEGER;
                         charsetRegistry: TEXT;
                         charsetEncoding: TEXT              ):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.match(
             family, pointSize, slant, maxResults, weightName, version,
             foundry, width, pixelsize, hres, vres, spacing, averageWidth,
             charsetRegistry, charsetEncoding)
  END DeepFontMatch;

PROCEDURE <A NAME="DeepFontList"><procedure>DeepFontList</procedure></A> (orc: DeepFontOracle; pat: TEXT; maxResults: INTEGER):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.list(pat, maxResults)
  END DeepFontList;

PROCEDURE <A NAME="FontMatch"><procedure>FontMatch</procedure></A> (orc            : FontOracle;
                     family         : TEXT;
                     pointSize      : INTEGER;
                     slant          : ScrnFont.Slant;
                     maxResults     : CARDINAL;
                     weightName     : TEXT;
                     version        : TEXT;
                     foundry        : TEXT;
                     width          : TEXT;
                     pixelsize      : INTEGER;
                     hres, vres     : INTEGER;
                     spacing        : ScrnFont.Spacing;
                     averageWidth   : INTEGER;
                     charsetRegistry: TEXT;
                     charsetEncoding: TEXT              ):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  VAR fname: TEXT;
  BEGIN
    IF Text.Length(version) # 0 THEN
      fname := &quot;+&quot; &amp; version
    ELSE
      fname := &quot;&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; foundry &amp; &quot;-&quot; &amp; family &amp; &quot;-&quot; &amp; weightName &amp; &quot;-&quot;;
    CASE slant OF
      ScrnFont.Slant.Roman =&gt; fname := fname &amp; &quot;R&quot;
    | ScrnFont.Slant.Italic =&gt; fname := fname &amp; &quot;I&quot;
    | ScrnFont.Slant.Oblique =&gt; fname := fname &amp; &quot;O&quot;
    | ScrnFont.Slant.ReverseItalic =&gt; fname := fname &amp; &quot;RI&quot;
    | ScrnFont.Slant.ReverseOblique =&gt; fname := fname &amp; &quot;RO&quot;
    | ScrnFont.Slant.Other =&gt; fname := fname &amp; &quot;OT&quot;
    | ScrnFont.Slant.Any =&gt; fname := fname &amp; &quot;*&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; width &amp; &quot;-*-&quot; &amp; Num(pixelsize) &amp; Num(pointSize)
               &amp; ResNum(hres, orc.st.res[Axis.T.Hor])
               &amp; ResNum(vres, orc.st.res[Axis.T.Ver]);
    CASE spacing OF
      ScrnFont.Spacing.Proportional =&gt; fname := fname &amp; &quot;P&quot;
    | ScrnFont.Spacing.Monospaced =&gt; fname := fname &amp; &quot;M&quot;
    | ScrnFont.Spacing.CharCell =&gt; fname := fname &amp; &quot;C&quot;
    | ScrnFont.Spacing.Any =&gt; fname := fname &amp; &quot;*&quot;
    END;
    fname := fname &amp; &quot;-&quot; &amp; Num(averageWidth) &amp; charsetRegistry &amp; &quot;-&quot;
               &amp; charsetEncoding;
    RETURN orc.list(fname, maxResults)
  END FontMatch;

PROCEDURE <A NAME="FontList"><procedure>FontList</procedure></A> (orc: FontOracle; pat: TEXT; maxResults: INTEGER):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END FontList;

PROCEDURE <A NAME="Num"><procedure>Num</procedure></A> (n: INTEGER): TEXT =
  BEGIN
    IF n &lt; 0 THEN RETURN &quot;*-&quot; ELSE RETURN Fmt.Int(n) &amp; &quot;-&quot; END
  END Num;

PROCEDURE <A NAME="ResNum"><procedure>ResNum</procedure></A> (n: INTEGER; res: REAL): TEXT =
  BEGIN
    (* Gross hack to deal with the fact that all available fonts for X are
       either scaled for 75 pixel per inch or 100 pixel per inch
       displays *)
    IF n = -2 THEN
      RETURN Num(ROUND(res * 25.4 / 25.0) * 25)
    ELSE
      RETURN Num(n)
    END
  END ResNum;

PROCEDURE <A NAME="DeepFontLookup"><procedure>DeepFontLookup</procedure></A> (orc: DeepFontOracle; name: TEXT): ScrnFont.T
  RAISES {ScrnFont.Failure, TrestleComm.Failure} =
  BEGIN
    RETURN orc.st.bits.font.lookup(name)
  END DeepFontLookup;

PROCEDURE <A NAME="FontLookup"><procedure>FontLookup</procedure></A> (orc: FontOracle; name: TEXT): ScrnFont.T
  RAISES {ScrnFont.Failure, TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END FontLookup;

CONST
  BuiltInNames = ARRAY OF
                   TEXT{
                   &quot;-adobe-helvetica-medium-r-normal--*-100-*-*-p-*-iso8859-1&quot;,
                   &quot;-*-helvetica-medium-r-*-*-*-10?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-times-medium-r-*-*-*-10?-*-*-*-*-iso8859-1&quot;,
                   &quot;fixed&quot;, &quot;-*-helvetica-*-r-*-*-*-11?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-helvetica-*-r-*-*-*-12?-*-*-*-*-iso8859-1&quot;,
                   &quot;-*-helvetica-*-r-*-*-*-1??-*-*-*-*-iso8859-?&quot;,
                   &quot;-*-times-*-r-*-*-*-1??-*-*-*-*-iso8859-?&quot;, &quot;timrom1?&quot;,
                   &quot;times_roman1?&quot;, &quot;*&quot;};

PROCEDURE <A NAME="DeepFontBuiltIn"><procedure>DeepFontBuiltIn</procedure></A> (orc: DeepFontOracle; id: Font.Predefined):
  ScrnFont.T =
  BEGIN
    RETURN Palette.ResolveFont(orc.st.bits, Font.T{id})
  END DeepFontBuiltIn;

PROCEDURE <A NAME="FontBuiltIn"><procedure>FontBuiltIn</procedure></A> (orc: FontOracle; id: Font.Predefined): ScrnFont.T =
  BEGIN
    IF id # Font.BuiltIn.fnt THEN Crash() END;
    RETURN
      NEW(ScrnFont.T, id := 0,
          metrics := NEW(NullMetrics,
                         minBounds := ScrnFont.CharMetric{0, Rect.Empty},
                         maxBounds := ScrnFont.CharMetric{0, Rect.Empty},
                         firstChar := 0, lastChar := 0,
                         selfClearing := TRUE, charMetrics := NIL))
  END FontBuiltIn;

TYPE
  NullMetrics = ScrnFont.Metrics OBJECT
                OVERRIDES
                  intProp  := NullIntProp;
                  textProp := NullTextProp
                END;

PROCEDURE <A NAME="NullIntProp"><procedure>NullIntProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                       &lt;*UNUSED*&gt; name: TEXT;
                       &lt;*UNUSED*&gt; ch  : INTEGER       := -1): INTEGER
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullIntProp;

PROCEDURE <A NAME="NullTextProp"><procedure>NullTextProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                        &lt;*UNUSED*&gt; name: TEXT;
                        &lt;*UNUSED*&gt; ch  : INTEGER       := -1): TEXT
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullTextProp;

PROCEDURE <A NAME="InitFontOracle"><procedure>InitFontOracle</procedure></A> (orc: FontOracle; st: NTScreenType.T): FontOracle
  RAISES {TrestleComm.Failure} =
  BEGIN
    orc.st := st;
    RETURN orc
  END InitFontOracle;

PROCEDURE <A NAME="DeepInitFontOracle"><procedure>DeepInitFontOracle</procedure></A> (orc: DeepFontOracle; st: NTScreenType.T):
  DeepFontOracle =
  BEGIN
    orc.st := st;
    RETURN orc
  END DeepInitFontOracle;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A>() =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;

BEGIN
END NTScrnFont.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
