<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScrnPntOp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScrnPntOp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScrnPntOp.i3">NTScrnPntOp</A></implements></module>;

IMPORT <A HREF="NT.i3">NT</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="NTScrnTpRep.i3">NTScrnTpRep</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/ScrnPaintOp.i3">ScrnPaintOp</A>,
       <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../win32/src/WinGDI.i3">WinGDI</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  <A NAME="T">T</A> = T_Pub BRANDED OBJECT
        opcount: CARDINAL := 0;
        (* numbers of entries in optable. *)
      END;

TYPE
  NTPaintOp = ScrnPaintOp.T;
  OpOracle = ScrnPaintOp.Oracle OBJECT
               st: NTScreenType.T
             OVERRIDES
               opaque      := Opaque;
               bgfg        := Bgfg;
               swap        := Swap;
               transparent := Transparent;
               copy        := Copy;
               builtIn     := OpBuiltIn;
             END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (st: NTScreenType.T): ScrnPaintOp.Oracle =
  BEGIN
    RETURN NEW(OpOracle, st := st)
  END NewOracle;

PROCEDURE <A NAME="Opaque"><procedure>Opaque</procedure></A> (orc: OpOracle; pix: ScrnPaintOp.Pixel): ScrnPaintOp.T
  RAISES {} =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    rec.rop := WinGDI.R2_COPYPEN;
    rec.fg := pix;
    rec.bg := pix;
    RETURN NewPaintOp(orc.st, rec, pix)
  END Opaque;

PROCEDURE <A NAME="Swap"><procedure>Swap</procedure></A> (orc: OpOracle; p, q: ScrnPaintOp.Pixel): ScrnPaintOp.T
  RAISES {} =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    IF p = q THEN RETURN Transparent(orc) END;
    rec.rop := WinGDI.R2_XORPEN;
    rec.fg := Word.Xor(p, q);
    rec.bg := Word.Xor(p, q);
    RETURN NewPaintOp(orc.st, rec)
  END Swap;

PROCEDURE <A NAME="Transparent"><procedure>Transparent</procedure></A> (orc: OpOracle): ScrnPaintOp.T RAISES {} =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    rec.rop := WinGDI.R2_NOP;
    rec.fg := 0;
    rec.bg := 0;
    RETURN NewPaintOp(orc.st, rec)
  END Transparent;

PROCEDURE <A NAME="Copy"><procedure>Copy</procedure></A> (orc: OpOracle): ScrnPaintOp.T RAISES {} =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    rec.rop := WinGDI.R2_COPYPEN;
    rec.fg := 0;
    rec.bg := 0;
    RETURN NewPaintOp(orc.st, rec)
  END Copy;

PROCEDURE <A NAME="Bgfg"><procedure>Bgfg</procedure></A> (orc: OpOracle; bg, fg: ScrnPaintOp.T): ScrnPaintOp.T
  RAISES {ScrnPaintOp.Failure} =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    LOCK orc.st.trsl DO
      IF (bg.id &lt; 0) OR (bg.id &gt;= orc.st.opcount) OR (fg.id &lt; 0)
           OR (fg.id &gt;= orc.st.opcount) THEN
        RAISE ScrnPaintOp.Failure
      END;
      WITH bgrec = orc.st.optable[bg.id],
           fgrec = orc.st.optable[fg.id]  DO
        IF (bgrec.rop = WinGDI.R2_NOP) THEN
          rec := fgrec;
          rec.bgMode := WinGDI.TRANSPARENT;
        ELSIF (bgrec.rop = fgrec.rop) THEN
          rec := fgrec;
          rec.bg := bgrec.bg;
        ELSE
          RAISE ScrnPaintOp.Failure
        END
      END
    END;
    RETURN NewPaintOp(orc.st, rec)
  END Bgfg;

PROCEDURE <A NAME="OpBuiltIn"><procedure>OpBuiltIn</procedure></A> (orc: OpOracle; op: PaintOp.Predefined):
  ScrnPaintOp.T =
  VAR rec: NTScrnTpRep.OpRecord;
  BEGIN
    CASE op OF
      PaintOp.Bg.op =&gt; RETURN Opaque(orc, orc.st.bg)
    | PaintOp.Fg.op =&gt; RETURN Opaque(orc, orc.st.fg)
    | PaintOp.Transparent.op =&gt; RETURN Transparent(orc)
    | PaintOp.Swap.op =&gt; RETURN Swap(orc, orc.st.bg, orc.st.fg)
    | PaintOp.Copy.op =&gt; RETURN Copy(orc)
    | PaintOp.BgFg.op =&gt;
        rec.rop := WinGDI.R2_COPYPEN;
        rec.fg := orc.st.fg;
        rec.bg := orc.st.bg ;
    | PaintOp.FgBg.op =&gt;
        rec.rop := WinGDI.R2_COPYPEN;
        rec.fg := orc.st.fg;
        rec.bg := orc.st.bg ;
    | PaintOp.TransparentBg.op =&gt;
        rec.rop := WinGDI.R2_COPYPEN;
        rec.fg := orc.st.bg;
        rec.bg := 0;
        rec.bgMode := WinGDI.TRANSPARENT;
    | PaintOp.TransparentFg.op =&gt;
        rec.rop := WinGDI.R2_COPYPEN;
        rec.fg := orc.st.fg;
        rec.bg := 0;
        rec.bgMode := WinGDI.TRANSPARENT;
    | PaintOp.TransparentSwap.op =&gt;
        rec.rop := WinGDI.R2_XORPEN;
        rec.fg := Word.Xor(orc.st.bg, orc.st.fg);
        rec.bg := 0;
        rec.bgMode := WinGDI.TRANSPARENT;
    | PaintOp.SwapTransparent.op =&gt;
        NT.Assert(1); (* NYI *)
    ELSE
      NT.Assert(1); (* NYI *)
    END;
    RETURN NewPaintOp(orc.st, rec)
  END OpBuiltIn;

PROCEDURE <A NAME="NewPaintOp"><procedure>NewPaintOp</procedure></A> (VAR      st : NTScreenType.T;
                      READONLY rec: NTScrnTpRep.OpRecord;
                               pix                         := -1):
  NTPaintOp =
  VAR res := NEW(NTPaintOp, pix := pix);
  BEGIN
    LOCK st.trsl DO
      WITH n = NUMBER(st.optable^) DO
        IF n = st.opcount THEN
          WITH new = NEW(REF ARRAY OF NTScrnTpRep.OpRecord, 2 * n) DO
            FOR i := 0 TO n - 1 DO new[i] := st.optable[i] END;
            st.optable := new
          END
        END
      END;
      res.id := st.opcount;
      st.optable[res.id] := rec;
      INC(st.opcount)
    END;
    RETURN res
  END NewPaintOp;

BEGIN
END NTScrnPntOp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
