<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/NTScrnPxmp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/NTScrnPxmp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="NTScrnPxmp.i3">NTScrnPxmp</A></implements></module>;

IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="NT.i3">NT</A>, <A HREF="NTScreenType.i3">NTScreenType</A>, <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>,
       <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>, <A HREF="../../../word/src/Word.i3">Word</A>;

REVEAL
  <A NAME="T">T</A> = T_Pub BRANDED OBJECT
      END;

TYPE
  NTPixmap = ScrnPixmap.T OBJECT
              st: NTScreenType.T;
            OVERRIDES
              unload   := PixmapUnregister;
              localize := PixmapLocalize;
              free     := PixmapFree
            END;

  PixmapOracle = ScrnPixmap.Oracle OBJECT
                   st: NTScreenType.T;
                 OVERRIDES
                   load    := PixmapRegister;
                   list    := PixmapList;
                   lookup  := PixmapLookup;
                   builtIn := PixmapBuiltIn
                 END;

PROCEDURE <A NAME="NewOracle"><procedure>NewOracle</procedure></A> (st: NTScreenType.T): ScrnPixmap.Oracle =
  BEGIN
    RETURN NEW(PixmapOracle, st := st)
  END NewOracle;

PROCEDURE <A NAME="PixmapDomain"><procedure>PixmapDomain</procedure></A> (st: NTScreenType.T; pmId: INTEGER): Rect.T =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapDomain;
</PRE> PixmapRegister, List, and Lookup must be changed to use the names. 

<P><PRE>PROCEDURE <A NAME="PixmapRegister"><procedure>PixmapRegister</procedure></A> (                    orc: PixmapOracle;
                                     READONLY pm : ScrnPixmap.Raw;
                          &lt;*UNUSED*&gt;          nm : TEXT             := NIL):
  ScrnPixmap.T RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapRegister;

PROCEDURE <A NAME="PixmapList"><procedure>PixmapList</procedure></A> (&lt;*UNUSED*&gt; orc       : PixmapOracle;
                      &lt;*UNUSED*&gt; pat       : TEXT;
                      &lt;*UNUSED*&gt; maxResults: CARDINAL       := 1):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END PixmapList;

PROCEDURE <A NAME="PixmapLookup"><procedure>PixmapLookup</procedure></A> (&lt;*UNUSED*&gt; orc: PixmapOracle; &lt;*UNUSED*&gt; name: TEXT):
  ScrnPixmap.T RAISES {TrestleComm.Failure} =
  BEGIN
    RETURN NIL
  END PixmapLookup;

PROCEDURE <A NAME="PixmapBuiltIn"><procedure>PixmapBuiltIn</procedure></A> (orc: PixmapOracle; pm: Pixmap.Predefined):
  ScrnPixmap.T =
  VAR res: ScrnPixmap.T;
  BEGIN
    IF orc.st.bits # orc.st THEN
      res := Palette.ResolvePixmap(orc.st.bits, Pixmap.T{pm});
      IF pm = Pixmap.Empty.pm THEN orc.st.empty := res.id END;
      RETURN res
    END;
    RETURN NEW(NTPixmap, id := 0, depth := 1, bounds := Rect.Empty)
  END PixmapBuiltIn;

PROCEDURE <A NAME="PixmapLocalize"><procedure>PixmapLocalize</procedure></A> (pm: NTPixmap; READONLY rect: Rect.T):
  ScrnPixmap.Raw RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0); (* NYI *)
  END PixmapLocalize;

PROCEDURE <A NAME="PixmapUnregister"><procedure>PixmapUnregister</procedure></A> (&lt;*UNUSED*&gt; pm: ScrnPixmap.T)
  RAISES {TrestleComm.Failure} =
  BEGIN
  END PixmapUnregister;

PROCEDURE <A NAME="PixmapFree"><procedure>PixmapFree</procedure></A> (pm: NTPixmap) RAISES {TrestleComm.Failure} =
  BEGIN
   NT.Assert(0); (* NYI *)
  END PixmapFree;

PROCEDURE <A NAME="FromNTPixmap"><procedure>FromNTPixmap</procedure></A> (         st    : NTScreenType.T;
                                 hbm   : WinDef.HBITMAP;
                        READONLY bounds: Rect.T;
                                 depth : INTEGER         ): ScrnPixmap.T =
  BEGIN
    NT.Assert(0);                (* NYI *)
  END FromNTPixmap;

PROCEDURE <A NAME="PixmapFromRaw"><procedure>PixmapFromRaw</procedure></A> (st: NTScreenType.T; pm: ScrnPixmap.Raw): WinDef.HBITMAP
  RAISES {TrestleComm.Failure} =
  BEGIN
    NT.Assert(0);                (* NYI *)
  END PixmapFromRaw;

BEGIN
END NTScrnPxmp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
