<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/nt/TrestleOnNT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/nt/TrestleOnNT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson 
<PRE>&lt;*PRAGMA LL*&gt;

UNSAFE MODULE <module><implements><A HREF="TrestleOnNT.i3">TrestleOnNT</A></implements></module>;

IMPORT <A HREF="NT.i3">NT</A>, <A HREF="NTClientF.i3">NTClientF</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../win32/src/WinDef.i3">WinDef</A>;

PROCEDURE <A NAME="HWND"><procedure>HWND</procedure></A> (v: VBT.T): WinDef.HWND =
  BEGIN
    LOOP
      IF v = NIL THEN RETURN NT.CNULL END;
      TYPECASE v.upRef OF
        NTClientF.Child (ch) =&gt; IF ch # NIL THEN RETURN ch.hwnd END
      ELSE                      (* skip *)
      END;
      v := v.parent
    END
  END HWND;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Enter"><procedure>Enter</procedure></A> (t: Display) RAISES {TrestleComm.Failure} =
  BEGIN
    Thread.Acquire(t);
    IF t.dead THEN Thread.Release(t); RAISE TrestleComm.Failure END
  END Enter;

&lt;*INLINE*&gt; PROCEDURE <A NAME="Exit"><procedure>Exit</procedure></A> (t: Display; deltaCoverage: [-1 .. 1] := 0)
  RAISES {TrestleComm.Failure} =
  BEGIN
    TRY
      IF t.dead THEN RAISE TrestleComm.Failure END;
      NTClientF.AdjustCoverage(t, deltaCoverage)
    FINALLY
      Thread.Release(t)
    END
  END Exit;

BEGIN
END TrestleOnNT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
