<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/picture/Completion.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/picture/Completion.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="Completion.i3">Completion</A></implements></module>;

IMPORT <A HREF="../../derived/CompletionSeq.i3">CompletionSeq</A>, <A HREF="#x1">Picture</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        cond     : Thread.Condition := NIL;
        count    : CARDINAL         := 0;
        next     : T                := NIL; (* for free list *)
        freeProc : Picture.FreeProc := NIL;
        freeParam: REFANY           := NIL;
      OVERRIDES
        init          := Init;
        inc           := Inc;
        dec           := Dec;
        isFree        := IsFree;
        waitUntilFree := WaitUntilFree;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (c           : T;
                initialCount                   := 1;
                freeProc    : Picture.FreeProc := NIL;
                freeParam   : REFANY           := NIL  ): T =
  BEGIN
    IF c.cond = NIL THEN c.cond := NEW(Thread.Condition); END;
    c.count := initialCount;
    c.freeProc := freeProc;
    c.freeParam := freeParam;
    RETURN c;
  END Init;

PROCEDURE <A NAME="Inc"><procedure>Inc</procedure></A> (c: T) =
  BEGIN
    LOCK c DO INC(c.count); END;
  END Inc;

PROCEDURE <A NAME="Dec"><procedure>Dec</procedure></A> (c: T) =
  VAR signal := FALSE;
  BEGIN
    LOCK c DO
      CASE c.count OF
      | 0 =&gt; RETURN;
      | 1 =&gt; DEC(c.count); signal := TRUE;
      ELSE
        DEC(c.count);
      END;
    END;
    IF signal THEN
      IF c.freeProc # NIL THEN
        SetupCallback(c)
      ELSE
        Thread.Broadcast(c.cond);
      END;
    END;
  END Dec;

PROCEDURE <A NAME="IsFree"><procedure>IsFree</procedure></A> (c: T): BOOLEAN =
  BEGIN
    RETURN c.count = 0;
  END IsFree;

PROCEDURE <A NAME="WaitUntilFree"><procedure>WaitUntilFree</procedure></A> (c: T) RAISES {Thread.Alerted} =
  BEGIN
    LOCK c DO WHILE c.count &gt; 0 DO Thread.AlertWait(c, c.cond); END; END;
  END WaitUntilFree;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): T =
  VAR res: T := NIL;
  BEGIN
    LOCK freeMu DO
      IF free # NIL THEN res := free; free := res.next; END;
    END;
    IF res = NIL THEN res := NEW(T); END;
    RETURN res;
  END New;

PROCEDURE <A NAME="Dispose"><procedure>Dispose</procedure></A> (c: T) =
  BEGIN
    &lt;* ASSERT c.count = 0 *&gt;
    LOCK freeMu DO c.next := free; free := c; END;
  END Dispose;

VAR
  freeMu    := NEW(MUTEX);
  free  : T := NIL;
</PRE> -- callback handling -- 
 when we need to call the freeProc for a Completion.T, we do it in
   another thread to avoid locking problems.  This thread is started the
   first time we need to call a freeProc.  Its creation is protected by
   /mu/.  Completions waiting for their callbacks to be called are put into
   the Sequence /seq/ which is also protected by /mu/ 
<PRE>VAR
  mu                    := NEW(MUTEX);
  thread     : Thread.T := NIL;
  seq                   := NEW(CompletionSeq.T).init();
  seqNotEmpty           := NEW(Thread.Condition);
</PRE> start the callback thread if necessary. Add the T to its input queue 
<PRE>PROCEDURE <A NAME="SetupCallback"><procedure>SetupCallback</procedure></A> (c: T) =
  VAR signal := FALSE;
  BEGIN
    LOCK mu DO
      IF thread = NIL THEN
        thread := Thread.Fork(NEW(Thread.Closure, apply := Apply));
      END;
      seq.addhi(c);
      IF seq.size() = 1 THEN signal := TRUE; END;
    END;
    IF signal THEN Thread.Signal(seqNotEmpty); END;
  END SetupCallback;
</PRE> pull Ts off the queue and call each callback and notify any other
   threads waiting for the T 
<PRE>PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (&lt;*UNUSED*&gt;cl: Thread.Closure): REFANY =
  VAR c: T;
  BEGIN
    LOOP
      LOCK mu DO
        WHILE seq.size() = 0 DO Thread.Wait(mu, seqNotEmpty); END;
        c := seq.remlo();
      END;

      &lt;* ASSERT c.freeProc # NIL *&gt;
      c.freeProc(c.freeParam);
      Thread.Broadcast(c.cond);
      Dispose(c);
    END;
  END Apply;

BEGIN
END Completion.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Picture is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
