<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/picture/FreeList.mg</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/picture/FreeList.mg</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

GENERIC MODULE <genericModule>FreeList</genericModule>(Elem);
</PRE> where Elem is an Image.T and so has a field
<P>
<PRE>
      next: Elem.T := NIL;
</PRE>
   and a method.
<P>
<PRE>
       destroy();
</PRE>
<PRE>
      New (): Elem.T;
</PRE>
   returns an Elem.T object, possibly from the free list.  Elem.Ts from
   this procedure will be put onto the free list and destroy() will be
   called.
<P>
<PRE>
      Free(t: Elem.T)
</PRE>
   explicitly calls t.destroy() and puts it on the free list 

<P><PRE>IMPORT <A HREF="../../../weakref/src/WeakRef.i3">WeakRef</A>, <A HREF="PictureRep.i3">PictureRep</A>;

VAR
  freeMu         := NEW(MUTEX);
  free  : Elem.T := NIL;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (): Elem.T =
  VAR res: Elem.T := NIL;
  BEGIN
    LOCK freeMu DO
      IF free # NIL THEN res := free; free := res.next; END;
    END;
    IF res = NIL THEN res := NEW(T); END;
    EVAL WeakRef.FromRef(res, CleanUp);
    RETURN res;
  END New;

PROCEDURE <A NAME="CleanUp"><procedure>CleanUp</procedure></A> (&lt;*UNUSED*&gt; READONLY w: WeakRef.T; r: REFANY) =
  BEGIN
    Free(NARROW(r, Elem.T));
  END CleanUp;

PROCEDURE <A NAME="Free"><procedure>Free</procedure></A> (t: Elem.T) =
  BEGIN
    t.destroy();
    LOCK freeMu DO t.next := free; free := t; END;
  END Free;

BEGIN
END FreeList.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
