<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/picture/Picture.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/picture/Picture.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="#x1">Picture</A></interface>;
</PRE> this interface supports writing Pictures to the display.  It is supposed
   to be platform-independant but bears a striking resemblance to the X
   version.  It also includes some hooks for shared memory transmission of
   the pictures; these are ignored if the implementation does not support
   them. 

<P><PRE>IMPORT <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

EXCEPTION
  ScreenTypeNotSupported;
  TrestleFail;                   (* the implementation returned an error *)

&lt;*PRAGMA LL *&gt;

TYPE <A HREF="Picture.m3#T">T</A> &lt;: ROOT;

PROCEDURE <A HREF="../xvbt/PictureImpl.m3#New">New</A> (st: VBT.ScreenType; width, height: CARDINAL): T
  RAISES {ScreenTypeNotSupported, TrestleFail};
</PRE><BLOCKQUOTE><EM> create a new T of size /width/ * /height/, based on origin =
   Point.Origin.  Further details, including the use of shared memory, are
   extracted from /v/.  All the fields in the Picture.Image which are not
   accessible in the interface are set to the server's defaults </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../xvbt/PictureImpl.m3#FromImage">FromImage</A> (st          : VBT.ScreenType;
                     image       : ImageStar;
                     sharedMemory                   := FALSE): T
  RAISES {ScreenTypeNotSupported, TrestleFail};
</PRE><BLOCKQUOTE><EM> create a new T based on an existing Picture.  The caller is also
   responsible for freeing /image/ as Picture.T will not do so for storage
   it has not allocated.  /sharedMemory/ is a hint to the implementation </EM></BLOCKQUOTE><PRE>

TYPE FreeProc = PROCEDURE (param: REFANY);
PROCEDURE <A HREF="Picture.m3#Paint">Paint</A> (         v        : VBT.Leaf;
                          src      : T;
                 READONLY clip                  := Rect.Full;
                 READONLY delta                 := Point.Origin;
                          freeProc : FreeProc   := NIL;
                          freeParam: REFANY     := NIL           )
  RAISES {Thread.Alerted};
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> translate the picture /src/ by /delta/, and paint it to the screen of
   /v/, clipping to rectangle /clip/.  To place the picture with the top
   left corner aligned with /v/, set /delta/ := Rect.NorthWest(v.domain).
<P>
   If /freeProc/ # NIL then /Put/ will return after the paint request has
   been made and /freeProc/ will be called with parameter /freeParam/ when
   the Picture data structures may safely be changed.  If /freeProc/ = NIL,
   then /Put/ will not return until the Picture data structures are safe </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Picture.m3#Destroy">Destroy</A> (picture: T);
</PRE><BLOCKQUOTE><EM> destroy /picture/, detaching any shared memory segments first.  This
   procedure will be called before /picture/ is collected if it hasn't been
   already. </EM></BLOCKQUOTE><PRE>

TYPE
  SharedMemInfo = OBJECT
                    id     : Ctypes.int;  (* shared memory identifier *)
                    address: ADDRESS      := NIL;
                    (* address to which shared memory is attached *)
                    readOnly := FALSE;
                    (* is the server allowed to write to the segment? *)
                  END;

PROCEDURE <A HREF="Picture.m3#AttachData">AttachData</A> (picture: T;
                      dataPtr: Ctypes.char_star;
                      shmInfo: SharedMemInfo      := NIL)
  RAISES {TrestleFail};
</PRE><BLOCKQUOTE><EM> attach the data segment /dataPtr/ to the Picture.  The caller is
   expected to have acquired the memory in which to put the picture.  If
   /shmInfo/ # NIL then the implementation will use shared memory to
   transmit the picture if it can.  The caller is responsible for freeing
   the data segment </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Picture.m3#DetachData">DetachData</A> (picture: T) RAISES {TrestleFail};
</PRE><BLOCKQUOTE><EM> detach the data from <CODE>picture</CODE>.  This call does not free any data
   allocated </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="Picture.m3#Image">Image</A> (picture: T): ImageStar;
</PRE><BLOCKQUOTE><EM> return the X.ImageStar associated with /picture/.  Can be NIL </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../xvbt/PictureImpl.m3#MakeImage">MakeImage</A> (st            : VBT.ScreenType;
                     width, height : Ctypes.int;
                     xoffset       : Ctypes.int       := 0;
                     bitmap_pad    : Ctypes.int       := 0;
                     bytes_per_line: Ctypes.int       := 0  ): ImageStar
  RAISES {ScreenTypeNotSupported, TrestleFail};
&lt;* LL &gt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> create an ImageRec for the given parameters.  The format is assumed to
   be ZPixmap.  It is the caller's responsibility to free the storage.
<P>
   The ImageStar is not suitable for use with Shared Memory </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../xvbt/PictureImpl.m3#Supported">Supported</A> (st: VBT.ScreenType; sharedMem := FALSE): BOOLEAN;
</PRE><BLOCKQUOTE><EM> return TRUE if this screen type is supported by the Picture module.  If
   <CODE>sharedMem</CODE> is TRUE then also test whether the screen type supports
   shared memory for the transmission of pictures </EM></BLOCKQUOTE><PRE>
</PRE> the following is the raw structure for an image, which bears a
   remarkable resemblance to an XImage structure.  See the X manuals for a
   description of its fields 

<P><PRE>TYPE
  CreateImageProc = PROCEDURE (): ImageStar;
  DestroyImageProc = PROCEDURE (i: ImageStar): Ctypes.int;
  GetPixelProc =
    PROCEDURE (i: ImageStar; x, y: Ctypes.int): Ctypes.unsigned_long;
  PutPixelProc =
    PROCEDURE (i: ImageStar; x, y: Ctypes.int; p: Ctypes.unsigned_long):
      Ctypes.int;
  SubImageProc =
    PROCEDURE (i: ImageStar; x, y: Ctypes.int; w, h: Ctypes.unsigned_int):
      ImageStar;
  AddPixelProc = PROCEDURE (i: ImageStar): Ctypes.int;

  ImageRec =
    RECORD
      width, height: Ctypes.int;  (* size of image *)
      xoffset: Ctypes.int;       (* number of pixels offset in X
                                    direction *)
      format: Ctypes.int;        (* XYBitmap, XYPixmap, ZPixmap *)
      data  : Ctypes.char_star;  (* pointer to image data *)
      byte_order : Ctypes.int;   (* data byte order, LSBFirst, MSBFirst *)
      bitmap_unit: Ctypes.int;   (* quant.  of scanline 8, 16, 32 *)
      bitmap_bit_order: Ctypes.int;  (* LSBFirst, MSBFirst *)
      bitmap_pad      : Ctypes.int;  (* 8, 16, 32 either XY or ZPixmap *)
      depth           : Ctypes.int;  (* depth of image *)
      bytes_per_line  : Ctypes.int;  (* accelarator to next line *)
      bits_per_pixel  : Ctypes.int;  (* bits per pixel (ZPixmap) *)
      red_mask  : Ctypes.unsigned_long;  (* bits in z arrangment *)
      green_mask: Ctypes.unsigned_long;
      blue_mask : Ctypes.unsigned_long;
      obdata: Ctypes.char_star;  (* hook for the object routines to hang
                                    on *)
      f: RECORD                  (* image manipulation routines *)
           create_image : CreateImageProc;
           destroy_image: DestroyImageProc;
           get_pixel    : GetPixelProc;
           put_pixel    : PutPixelProc;
           sub_image    : SubImageProc;
           add_pixel    : AddPixelProc;
         END;
    END;
  ImageStar = UNTRACED REF ImageRec;

END Picture.
</PRE>
</inInterface>
<HR>
<A NAME="x1">Picture's implementation  is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.m3#0TOP0">trestle_by_example/src/common/Picture.m3</A>
<LI><A HREF="Picture.m3#0TOP0">ui/src/picture/Picture.m3</A>
<LI><A HREF="../xvbt/PictureImpl.m3#0TOP0">ui/src/xvbt/PictureImpl.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
