<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/picture/Picture.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/picture/Picture.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

UNSAFE MODULE <module>Picture</module> EXPORTS <A HREF="#x1"><implements>Picture</A></implements>, <A HREF="PictureRep.i3"><implements>PictureRep</A></implements>;

IMPORT <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchRep.i3">BatchRep</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="Completion.i3">Completion</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="PictureRep.i3">PictureRep</A>,
       <A HREF="../vbt/PaintExt.i3">PaintExt</A>, <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>,
       <A HREF="../../../word/src/Word.i3">Word</A>;
</PRE> -- public procedures -- 
 New and NewFromImage are implementation-specific and contained in
   PictureImpl.m3 

<P><PRE>PROCEDURE <A NAME="Paint"><procedure>Paint</procedure></A> (         v        : VBT.Leaf;
                          src      : T;
                 READONLY clip                  := Rect.Full;
                 READONLY delta                 := Point.Origin;
                          freeProc : FreeProc   := NIL;
                          freeParam: REFANY     := NIL           )
  RAISES {Thread.Alerted} =
  CONST
    bsize = ADRSIZE(PaintExt.PictureRec);
    size  = bsize DIV ADRSIZE(Word.T);
  VAR
    p: PaintExt.PicturePtr;
    completion := PictureRep.MakeCompletion(src).init(
                    1, freeProc, freeParam);
  BEGIN
    LOCK v DO
      IF v.remaining &lt; bsize THEN
        IF v.st = NIL THEN RETURN END;
        VBTRep.NewBatch(v, size);
      END;

      DEC(v.remaining, bsize);
      WITH b = v.batch DO
        p := b.next;
        INC(b.next, bsize);
        p.ext.command := PaintPrivate.PaintCommand.ExtensionCom;
        p.ext.clip := clip;
        p.ext.szOfRec := size;
        p.ext.delta := delta;
        p.ext.subCommand := PaintExt.PictureCommand;
        p.picture := LOOPHOLE(src, ADDRESS); (* see the note PaintExt.i3 *)
        p.completion := LOOPHOLE(completion, ADDRESS);
        BatchUtil.SetPicture(b);
      END;
      VBTRep.ForceBatch(v);
    END;

    VBT.Sync(v, FALSE);

    IF freeProc = NIL THEN
      (* synchronous version *)
      TRY
        completion.waitUntilFree();
      FINALLY
        IF NOT completion.isFree() THEN completion.dec(); END;
        Completion.Dispose(completion);
      END;
    END;
  END Paint;

PROCEDURE <A NAME="Destroy"><procedure>Destroy</procedure></A> (picture: T) =
  BEGIN
    picture.destroy();
  END Destroy;

PROCEDURE <A NAME="AttachData"><procedure>AttachData</procedure></A> (picture: T;
                      dataPtr: Ctypes.char_star;
                      shmInfo: SharedMemInfo      := NIL)
  RAISES {TrestleFail} =
  BEGIN
    picture.attachData(dataPtr, shmInfo);
  END AttachData;

PROCEDURE <A NAME="DetachData"><procedure>DetachData</procedure></A> (picture: T) RAISES {TrestleFail} =
  BEGIN
    picture.detachData();
  END DetachData;

PROCEDURE <A NAME="Image"><procedure>Image</procedure></A> (picture: T): ImageStar =
  BEGIN
    RETURN picture.image;
  END Image;
</PRE> -- types and methods -- 

<P><PRE>REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
      OVERRIDES
        init          := TInit;
        initFromImage := TInitFromImage;
        attachData    := TAttachData;
        detachData    := TDetachData;
        destroy       := DestroyCrash;
      END;

PROCEDURE <A NAME="TInit"><procedure>TInit</procedure></A> (            t            : T;
                 &lt;* UNUSED*&gt; st           : VBT.ScreenType;
                 &lt;* UNUSED*&gt; width, height: CARDINAL        ): T =
  BEGIN
    RETURN t;
  END TInit;

PROCEDURE <A NAME="TInitFromImage"><procedure>TInitFromImage</procedure></A> (            t    : T;
                          &lt;* UNUSED*&gt; st   : VBT.ScreenType;
                                      image: ImageStar;
                          &lt;* UNUSED*&gt; sharedMemory := FALSE): T =
  BEGIN
    t.allocByCaller := TRUE;
    t.image := image;
    RETURN t;
  END TInitFromImage;

PROCEDURE <A NAME="TAttachData"><procedure>TAttachData</procedure></A> (            picture: T;
                                   dataPtr: Ctypes.char_star;
                       &lt;* UNUSED*&gt; shmInfo: SharedMemInfo      := NIL) =
  BEGIN
    picture.image.data := dataPtr;
  END TAttachData;

PROCEDURE <A NAME="TDetachData"><procedure>TDetachData</procedure></A> (picture: T) =
  BEGIN
    picture.image.data := NIL;
  END TDetachData;

EXCEPTION Fatal;

PROCEDURE <A NAME="DestroyCrash"><procedure>DestroyCrash</procedure></A> (&lt;* UNUSED *&gt; picture: T) =
  &lt;* FATAL Fatal *&gt;
  BEGIN
    RAISE Fatal;
  END DestroyCrash;
</PRE> -- utilities -- 

<P><PRE>PROCEDURE <A NAME="Freeze"><procedure>Freeze</procedure></A> (picture: T): Lock =
  VAR res := LOOPHOLE(ADR(picture), Lock);
  BEGIN
    RETURN res;
  END Freeze;

PROCEDURE <A NAME="Thaw"><procedure>Thaw</procedure></A> (&lt;*UNUSED*&gt; l: Lock) =
  BEGIN
  END Thaw;

TYPE WalkProc = PROCEDURE (completion: Completion.T);

PROCEDURE <A NAME="DecrementBatch"><procedure>DecrementBatch</procedure></A> (ba: Batch.T) =
  PROCEDURE Dec (comp: Completion.T) =
    BEGIN
      comp.dec();
    END Dec;
  BEGIN
    WalkBatch(ba, Dec);
  END DecrementBatch;

PROCEDURE <A NAME="IncrementBatch"><procedure>IncrementBatch</procedure></A> (ba: Batch.T) =
  PROCEDURE Inc (comp: Completion.T) =
    BEGIN
      comp.inc();
    END Inc;
  BEGIN
    WalkBatch(ba, Inc);
  END IncrementBatch;

PROCEDURE <A NAME="WalkBatch"><procedure>WalkBatch</procedure></A> (ba: Batch.T; proc: WalkProc) =
  VAR cptr: PaintPrivate.CommandPtr := BatchUtil.Succ(ba, NIL);
  BEGIN
    WHILE cptr # NIL DO
      IF cptr.command = PaintPrivate.PaintCommand.ExtensionCom THEN
        WITH op = LOOPHOLE(cptr, PaintExt.PicturePtr) DO
          IF op.ext.subCommand = PaintExt.PictureCommand THEN
            (* see PaintExt.i3 for LOOPHOLE *)
            proc(LOOPHOLE(op.completion, Completion.T));
          END;
        END;
      END;
      cptr := BatchUtil.Succ(ba, cptr);
    END;
  END WalkBatch;

BEGIN
END Picture.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Picture is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
