<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/picture/PictureImpl.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/picture/PictureImpl.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module>PictureImpl</module> EXPORTS <A HREF="#x1"><implements>Picture</A></implements>, <A HREF="PictureRep.i3"><implements>PictureRep</A></implements>;

IMPORT <A HREF="Completion.i3">Completion</A>, <A HREF="../../../C/src/Common/Ctypes.i3">Ctypes</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../X11R4/src/Common/X.i3">X</A>, <A HREF="../xvbt/XPicture.i3">XPicture</A>, <A HREF="../xvbt/XScreenType.i3">XScreenType</A>, <A HREF="../xvbt/XSharedMem.i3">XSharedMem</A>;
</PRE> this module provides the implementation-dependant parts of Picture.i3;
   in particular, X provides routines for allocating XImages. 

<P><PRE>EXCEPTION Fatal;                 &lt;* FATAL Fatal *&gt;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (st: VBT.ScreenType; width, height: CARDINAL): T
  RAISES {ScreenTypeNotSupported, TrestleFail} =
  BEGIN
    TYPECASE (st) OF
    | XScreenType.T =&gt; RETURN NewPicture(st).init(st, width, height);
    ELSE
      RAISE ScreenTypeNotSupported;
    END;
  END New;

PROCEDURE <A NAME="FromImage"><procedure>FromImage</procedure></A> (st          : VBT.ScreenType;
                     image       : ImageStar;
                     sharedMemory                   := FALSE): T
  RAISES {ScreenTypeNotSupported, TrestleFail} =
  BEGIN
    TYPECASE (st) OF
    | XScreenType.T =&gt;
        RETURN NewPicture(st).initFromImage(st, image, sharedMemory);
    ELSE
      RAISE ScreenTypeNotSupported;
    END;
  END FromImage;

PROCEDURE <A NAME="NewPicture"><procedure>NewPicture</procedure></A> (st: XScreenType.T): XPicture.T =
  BEGIN
    IF XSharedMem.UsesExtension(st) THEN
      RETURN XSharedMem.New();
    ELSE
      RETURN XPicture.New();
    END;
  END NewPicture;

PROCEDURE <A NAME="MakeImage"><procedure>MakeImage</procedure></A> (st            : VBT.ScreenType;
                     width, height : Ctypes.int;
                     xoffset       : Ctypes.int       := 0;
                     bitmap_pad    : Ctypes.int       := 0;
                     bytes_per_line: Ctypes.int       := 0  ): ImageStar
  RAISES {ScreenTypeNotSupported, TrestleFail} =
  BEGIN
    TYPECASE (st) OF
    | XScreenType.T =&gt;
        RETURN XPicture.MakeImage(
                 st, width, height, xoffset, bitmap_pad, bytes_per_line);
    ELSE
      RAISE ScreenTypeNotSupported;
    END;
  END MakeImage;

PROCEDURE <A NAME="MakeCompletion"><procedure>MakeCompletion</procedure></A> (picture: T): Completion.T =
  BEGIN
    TYPECASE (picture) OF
    | XSharedMem.T (xsh) =&gt; RETURN XSharedMem.MakeCompletion(xsh);
    | XPicture.T (xim) =&gt; RETURN XPicture.MakeCompletion(xim);
    ELSE
      RETURN Completion.New();
    END
  END MakeCompletion;

PROCEDURE <A NAME="Supported"><procedure>Supported</procedure></A> (st: VBT.ScreenType; sharedMem := FALSE): BOOLEAN =
  BEGIN
    TYPECASE st OF
    | XScreenType.T (xst) =&gt;
        IF sharedMem THEN
          RETURN XSharedMem.UsesExtension(xst);
        ELSE
          RETURN TRUE;
        END;
    ELSE
      RETURN FALSE;
    END;
  END Supported;

BEGIN
  (* this is a dumb check to try to keep Picture and XPicture in step *)
  IF BYTESIZE(X.XImage) # BYTESIZE(ImageRec) THEN RAISE Fatal; END;
END PictureImpl.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Picture is in:
</A><UL>
<LI><A HREF="../../../trestle_by_example/src/common/Picture.i3#0TOP0">trestle_by_example/src/common/Picture.i3</A>
<LI><A HREF="Picture.i3#0TOP0">ui/src/picture/Picture.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
