<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/rpcvbt/RPCVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/rpcvbt/RPCVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

INTERFACE <interface>RPCVBT</interface>;

IMPORT <A HREF="VBTProvider.i3">VBTProvider</A>, RPC, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>;

TYPE
  Child = OBJECT METHODS
    getCursor(): ScrnCursorT;
    axisOrder(): Axis.T;
    read
    write
    discard
    shape
    prod(READONLY ev: Event; startMessenger: BOOLEAN);
  END;
  Parent = OBJECT METHODS
    setcage(READONLY cage: VBT.Cage; seqno: Word.T);
    setcursor(cs: ScrnCursorT);
    paint(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      seqno: Word.T);
    sync
    readUp
    writeUp
    capture
    screenOf
    newShape
    acquire
    release
    put
    forge
    paintAndGet(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      READONLY cage: VBT.Cage;
      seqno: Word.T): Event
      RAISES {Thread.Alerted, RPC.CallFailed};
    setCageAndPaint(
      READONLY batch: ARRAY OF Word.T;
      READONLY clip, scrollSource: Rect.T;
      clipState: BatchUtil.ClipState;
      READONLY cage: VBT.Cage;
      seqno: Word.T) RAISES {Thread.Alerted, RPC.CallFailed};
    setCageAndGet(READONLY cage: VBT.Cage; seqno: Word.T): Event
      RAISES {Thread.Alerted, RPC.CallFailed};
    getScreenType
    getBadRegion
  END;
  Connection = OBJECT METHODS
    apply(t: TEXT; prnt: Parent): Child
    RAISES {VBTProvider.Error, RPC.CallFailed}
    &lt;* LL = parent address space VBT.mu *&gt;
  END;

TYPE
  Event = RECORD
    type: EventType;
    whatButtonChanged: VBT.Button;
    time: VBT.TimeStamp;
    cp: VBT.CursorPosition;
    modifiers: VBT.Modifiers;
    clickType: VBT.ClickType;
    clickCount: INTEGER;
    new, saved, badRect: Rect.T;
    badRegionIsRect: BOOLEAN;
    marked: BOOLEAN;
    miscType: VBT.MiscCodeType;
    detail: VBT.MiscCodeDetail;
    selection: VBT.SelectionOrNil;
    whatKeyChanged: VBT.KeySym;
    wentDown: BOOLEAN;
  END;
  EventType = {None, Mouse, Position, Redisplay, Reshape, Rescreen,
    Repaint, Misc, Key}
</PRE> An <CODE>Event</CODE> <CODE>e</CODE> represents the forwarding from parent to child of
   call to the VBT down method <CODE>e.type</CODE>, unless <CODE>type</CODE> is <CODE>None</CODE>, in
   which case the event directs the child address space to kill its
   messenger thread.  Only a subset of the remaining fields are
   relevant, as determined by the <CODE>VBT</CODE> interface; for example, in a
   <CODE>Position</CODE> event, only the <CODE>cp</CODE>, <CODE>time</CODE>, and <CODE>modifiers</CODE> fields are
   relevant.  The <CODE>whatChanged</CODE> fields of Button and Key events have
   been renamed into whatButtonChanged and whatKeyChanged, since they
   have different types.  In a <CODE>Repaint</CODE> event, the whole bad region
   is not transferred: instead the rectangle <CODE>badRect</CODE> is the bounding
   box of the bad region, and the boolean <CODE>badRegionIsRect</CODE> is <CODE>TRUE</CODE>
   if the badRegion equals the badRect.  The <CODE>prev</CODE> field of a
   <CODE>Rescreen</CODE> or <CODE>Reshape</CODE> event is not transferred, since it equals
   the child's domain.  The new screentype is not transferred with a
   <CODE>Rescreen</CODE> event; instead, the child calls the parent's getScreenType
   method to respond to the event.  
       
<P><PRE>REVEAL VBTProvider.<A NAME="Remote">Remote</A> = BRANDED OBJECT METHODS
    connect(): Connection
  END;

END RPCVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
