<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/rpcvbt/VBTProvider.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/rpcvbt/VBTProvider.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> Cross-address space filter VBTs.
<P>
   A cross-address space <CODE>VBT</CODE> is a filter in which the parent and child
   are in different address spaces. The filter has no effect except to
   transport events between the address spaces. For example, the ivy
   text editor can use cross-address space <CODE>VBTs</CODE> to manage text
   subwindows of applications in other address spaces.
<P>
   The child side of a cross address space filter applies <CODE>ToRemote</CODE>
   to its provider, and passes the resulting <CODE>Remote</CODE> to the parent
   address space as a network object.  The parent side passes the <CODE>Remote</CODE>
   to <CODE>FromRemote</CODE> to obtain the parent side of the provider.  
    
   
<P><PRE>INTERFACE <interface><A HREF="VBTProvider.m3">VBTProvider</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>;

EXCEPTION Error(TEXT);

TYPE
  T = OBJECT METHODS apply(TEXT): VBT.T RAISES {Error};
  <A HREF="RPCVBT.i3#Remote">Remote</A> &lt;: ROOT;
  (* A &quot;Remote&quot; is an pure object type that can be passed or exported
     as a network object. *)

  (* The locking level of an apply method is VBT.mu.  The VBT.mu's for
     the different address spaces are ordered so that

      parent space VBT.mu &lt; child space VBT.mu .

   Clients must avoid using cross-address space filters in a way that
   would produce a cycle in this order.  *)

PROCEDURE <A HREF="VBTProvider.m3#ToRemote">ToRemote</A>(provider: T): Remote;

PROCEDURE <A HREF="VBTProvider.m3#FromRemote">FromRemote</A>(r: Remote): T RAISES {Error};

END VBTProvider.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
