<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/rpcvbt/VBTReceiver.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/rpcvbt/VBTReceiver.i3</H2></A><HR>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> VBTReceiver.def, by gnelson and msm. 
<PRE>&lt;*PRAGMA LL*&gt;

SAFE DEFINITION MODULE VBTReceiver;
</PRE> Parent side of cross-address space VBT filter.
<P>
   A cross-address space VBT is a filter in which the parent and child
   are in different address spaces. The filter has no effect except to
   transport events between the address spaces. For example, the ivy
   text editor can use cross-address space VBTs to manage text
   subwindows of applications in other address spaces.
<P>
   This is the interface that you use to create a filter in which the
   parent VBT is in your address space and the child is in a remote
   address space (called the provider). You identify the provider by two
   Text.Ts (see the interface VBTProvider for more details). You pass a
   Text.T to the provider to specify the kind of child VBT that you want
   it to provide. The interpretation of the Text.T is up to you and the
   provider.
<P>
   Index: VBT, cross-address space 

<P><PRE>IMPORT Text, VBT, RPC;

TYPE
  Instance = REF;

PROCEDURE Import(
    instance, subinstance: Text.T;
    localOnly: BOOLEAN := FALSE)
    : Instance
  RAISES {RPC.ImportFailed};
</PRE><BLOCKQUOTE><EM> Locates and returns the VBT provider identified by instance and
   subinstance. Typically, instance is the name of the machine providing
   the service, and subinstance identifies the type of service, e.g.
   <CODE>IvyVBT</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE New(
    inst: Instance;
    t: Text.T)
    : VBT.T
  RAISES {VBT.Error, RPC.CallFailed};
</PRE><BLOCKQUOTE><EM> Ask the VBT provider inst to create a child VBT determined by t,
   connect it via a cross-address space filter to a parent VBT in this
   address space, and return the parent. Relays errors generated by RPC
   or by the provider. </EM></BLOCKQUOTE><PRE>

END VBTReceiver.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
