<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/AnchorBtnVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/AnchorBtnVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> An <CODE>AnchorBtnVBT.T </CODE>is a button that activates a pull-down menu when 
   you click on it or roll into it from another anchor button. 
<P>
   Associated with each anchor button <CODE>b</CODE> is 
   <P>
   \medskip\bulletitem <CODE>b.menu</CODE>, the menu to be activated, 
   <P>
   \medskip\bulletitem <CODE>b.hfudge</CODE> and <CODE>b.vfudge</CODE>, dimensions in millimeters
   that control where the menu is popped up,
   <P>
   \medskip\bulletitem <CODE>b.n</CODE>, a count of the number of <CODE>ZSplit</CODE> ancestors
   of <CODE>b</CODE> to skip when looking for the <CODE>ZSplit</CODE> to insert the
   menu into.
<P>
   \medskip\noindent A down click on an anchor button <CODE>b</CODE> {\it activates} 
   it by: 
   <P>
   \medskip\bulletitem  calling the method <CODE>b.pre()</CODE>, and then   
<P>
   \medskip\bulletitem inserting the window <CODE>b.menu</CODE> so that its
   northwest corner is <CODE>b.hfudge</CODE> millimeters to the right and
   <CODE>b.vfudge</CODE> millimeters below the southwest corner of <CODE>b</CODE>.
   The menu will be inserted into the (<CODE>b.n</CODE>)th <CODE>ZSplit</CODE> ancestor of
   <CODE>b</CODE> (counting the first <CODE>ZSplit</CODE> ancestor as zero), or as an
   undecorated top-level window if <CODE>b</CODE> has at most <CODE>b.n</CODE> <CODE>ZSplit</CODE>
   ancestors.
<P>
   \medskip\noindent The anchor button will be deactivated when it gets
   another mouse transition or when the user rolls the mouse over a
   sibling anchor button, in which case the sibling will be activated.
   Two anchor buttons are siblings if they have the same ``anchor parent''.
   The anchor parent is specified when the anchor button is created;
   if it is <CODE>NIL</CODE>, then the normal parent is used as the anchor parent.
   When an anchor button is deactivated, its cancel method is called
   and its menu is deleted from its <CODE>ZSplit</CODE>.
   <P>
   The default <CODE>pre</CODE> method highlights the anchor button; the default
   <CODE>cancel</CODE> method unhighlights it.
<P>
   In the common case in which the user down-clicks on the anchor, rolls
   over the menu, and up-clicks on one of the items, the upclick will
   be delivered to the item first, which will invoke the appropriate
   action, and then will be delivered to the anchor button (since the
   anchor button has the mouse focus), which will delete the menu.
<P>
   A <CODE>HighlightVBT</CODE> is automatically inserted over the menu when it is 
   inserted, and discarded when the menu is deleted.  This allows the
   menu items to highlight themselves without interfering with the 
   highlighting of the anchor button.
<P>
   The <CODE>action</CODE> procedure and <CODE>post</CODE> method of an anchor button are never
   called.  The <CODE>pre</CODE> and <CODE>cancel</CODE> methods can be overridden; for
   example, the <CODE>pre</CODE> method could prepare the menu before it is
   inserted.  This is the reason the menu field is revealed in the type
   declaration.
<P>
   The same menu can be associated with several anchor buttons, provided
   that only one of them is active at a time.  

<P>
<P><PRE>INTERFACE <interface><A HREF="AnchorBtnVBT.m3">AnchorBtnVBT</A></interface>;

IMPORT <A HREF="ButtonVBT.i3">ButtonVBT</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="AnchorBtnVBT.m3#T">T</A> &lt;: Public;
  Public = ButtonVBT.T OBJECT
    menu: VBT.T
  METHODS &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(ch: VBT.T;
      menu: VBT.T;
      n: CARDINAL := 0;
      anchorParent: VBT.T := NIL;
      hfudge, vfudge := 0.0;
      ref: REFANY := NIL): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes the button with the given
   attributes, and adds <CODE>ref</CODE> to <CODE>v</CODE>'s property set if it is not <CODE>NIL</CODE>.
   This includes a call to <CODE>ButtonVBT.T.init(v, ch)</CODE>. 
   <P>
   You must not change the menu while the <CODE>AnchorBtnVBT</CODE> is active.

<P>
<P><PRE>PROCEDURE <A HREF="AnchorBtnVBT.m3#New">New</A>(
  ch: VBT.T;
  menu: VBT.T;
  n: CARDINAL := 0;
  anchorParent: VBT.T := NIL;
  hfudge, vfudge := 0.0;
  ref: REFANY := NIL): T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnchorBtnVBT.m3#SetParent">SetParent</A>(v: T; p: VBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the anchor parent of <CODE>v</CODE> to be <CODE>p</CODE>.  If <CODE>v</CODE> is active, this is a 
   checked runtime error. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnchorBtnVBT.m3#GetParent">GetParent</A>(v: T): VBT.T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the anchor parent of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnchorBtnVBT.m3#Set">Set</A>(v: T;  n: CARDINAL; hfudge, vfudge: REAL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the attributes of <CODE>v</CODE>.  If <CODE>v</CODE> is active, this is a 
   checked runtime error. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnchorBtnVBT.m3#Get">Get</A>(v: T; VAR n: CARDINAL;
  VAR hfudge, vfudge: REAL); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Fetch the attributes of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="AnchorBtnVBT.m3#IsActive">IsActive</A>(v: T): BOOLEAN; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if and only if <CODE>v</CODE> is active. </EM></BLOCKQUOTE><PRE>

END AnchorBtnVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
