<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/AnchorBtnVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/AnchorBtnVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="AnchorBtnVBT.i3">AnchorBtnVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="ZSplit.i3">ZSplit</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="ButtonVBT.i3">ButtonVBT</A>, <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>,
<A HREF="HighlightVBT.i3">HighlightVBT</A>, <A HREF="Split.i3">Split</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>;

FROM <A HREF="../vbt/VBT.i3">VBT</A> IMPORT ClickType;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    n: CARDINAL;
    anchorParent: VBT.T := NIL;
    hfudge, vfudge: REAL
  OVERRIDES
    mouse := Mouse;
    position := Position;
    init := Be
  END;

TYPE
  AnchorRef = REF RECORD activeAnchor: T END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(
  v: T;
  ch: VBT.T;
  menu: VBT.T;
  n: CARDINAL := 0;
  anchorParent: VBT.T := NIL;
  hfudge, vfudge := 0.0;
  ref: REFANY := NIL): T RAISES {} =
  BEGIN
    v.menu := menu;
    v.n := n;
    v.anchorParent := anchorParent;
    v.hfudge := hfudge;
    v.vfudge := vfudge;
    EVAL ButtonVBT.T.init(v, ch, NIL, ref);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
  ch: VBT.T;
  menu: VBT.T;
  n: CARDINAL := 0;
  anchorParent: VBT.T := NIL;
  hfudge, vfudge := 0.0;
  ref: REFANY := NIL): T RAISES {} =
  VAR res := NEW(T);
  BEGIN
    RETURN Be(res, ch, menu, n, anchorParent, hfudge, vfudge, ref)
  END New;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) RAISES {} =
  BEGIN
    Filter.T.mouse(v, cd);
    IF cd.clickType = ClickType.FirstDown THEN
       WITH ref = GetAnchorRef(v) DO
         ref.activeAnchor := v;
         Activate(v, ref)
       END
    ELSE
      WITH ref = GetAnchorRef(v) DO
        IF ref.activeAnchor # NIL THEN
          Deactivate(ref.activeAnchor);
          ref.activeAnchor := NIL
        END
      END
    END
  END Mouse;

PROCEDURE <A NAME="GetAnchorRef"><procedure>GetAnchorRef</procedure></A>(v: T): AnchorRef =
 VAR
   ref: AnchorRef;
   parent: VBT.T;
 BEGIN
   IF v.anchorParent = NIL THEN
     parent := VBT.Parent(v)
   ELSE
     parent := v.anchorParent
   END;
   ref := VBT.GetProp(parent, TYPECODE(AnchorRef));
   IF ref = NIL THEN
     ref := NEW(AnchorRef);
     VBT.PutProp(parent, ref)
   END;
   RETURN ref
  END GetAnchorRef;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(v: T; READONLY cd: VBT.PositionRec) RAISES {} =
  BEGIN
    Filter.T.position(v, cd);
    IF cd.cp.gone THEN VBT.SetCage(v, VBT.GoneCage); RETURN END;
    VBT.SetCage(v, VBT.InsideCage);
    WITH ref = GetAnchorRef(v) DO
      IF (ref.activeAnchor # NIL)
         AND (ref.activeAnchor # v) THEN
        Deactivate(ref.activeAnchor);
        ref.activeAnchor := v;
        Activate(v, ref)
      END
    END
  END Position;

PROCEDURE <A NAME="GetZSplit"><procedure>GetZSplit</procedure></A>(v: T): ZSplit.T =
  VAR m := v.n; z := v.parent;  BEGIN
    LOOP
      IF z = NIL THEN RETURN NIL END;
      IF ISTYPE(z, ZSplit.T) THEN
        IF m = 0 THEN RETURN z ELSE DEC(m) END
      END;
      z := z.parent
    END
  END GetZSplit;

PROCEDURE <A NAME="Activate"><procedure>Activate</procedure></A>(v: T; ref: AnchorRef) =
  VAR
    pt := Point.MoveHV(Rect.SouthWest(VBT.Domain(v)),
      ROUND(VBT.MMToPixels(v, v.hfudge, Axis.T.Hor)),
      ROUND(VBT.MMToPixels(v, v.vfudge, Axis.T.Ver)));
    z := GetZSplit(v);
    dom: Rect.T;
  BEGIN
    v.pre();
    IF v.menu.st # v.st THEN VBTClass.Rescreen(v.menu, v.st) END;
    IF z = NIL THEN
      (* insert menu as top-level window *)
      WITH srec = Trestle.ScreenOf(v, pt) DO
        IF srec.trsl # NIL THEN
          dom := Shift(MinRect(v.menu, srec.q), srec.dom);
          TRY
            Trestle.Attach(v.menu, srec.trsl);
            Trestle.Overlap(v.menu, srec.id, Rect.NorthWest(dom))
          EXCEPT
            TrestleComm.Failure =&gt; v.cancel(); ref.activeAnchor := NIL
          END
        END
      END
    ELSE
      (* insert menu in z *)
      dom := Shift(MinRect(v.menu, pt), VBT.Domain(z));
      ZSplit.Insert(z, HighlightVBT.New(v.menu), dom)
    END
  END Activate;

PROCEDURE <A NAME="Shift"><procedure>Shift</procedure></A>(READONLY menu, parent: Rect.T): Rect.T =
  (* Shift the menu left until it is entirely contained in parent or until its
     left edge coincides with the left edge of parent, unless it needs
     shifting to the right, in which shift until the left edge of menu is
     visible. Do the same thing vertically. *)
  VAR dh, dv: INTEGER;
  BEGIN
    dh := MAX(MIN(0, parent.east - menu.east), parent.west - menu.west);
    dv := MAX(MIN(0, parent.south - menu.south), parent.north - menu.north);
    RETURN Rect.MoveHV(menu, dh, dv);
  END Shift;

PROCEDURE <A NAME="MinRect"><procedure>MinRect</procedure></A>(v: VBT.T; READONLY pt: Point.T): Rect.T =
  BEGIN
    RETURN
      Rect.FromCorner(pt,
        VBTClass.GetShape(v, Axis.T.Hor, 0).lo,
        VBTClass.GetShape(v, Axis.T.Ver, 0).lo)
  END MinRect;

PROCEDURE <A NAME="Deactivate"><procedure>Deactivate</procedure></A>(v: T) =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    v.cancel();
    WITH z = GetZSplit(v) DO
      IF z = NIL THEN
        Trestle.Delete(v.menu)
      ELSE
        WITH highlighter = VBT.Parent(v.menu) DO
          Split.Delete(z, highlighter);
          Split.Delete(highlighter, v.menu);
          VBT.Discard(highlighter)
        END
      END
    END
  END Deactivate;

PROCEDURE <A NAME="IsActive"><procedure>IsActive</procedure></A>(v: T): BOOLEAN =
  BEGIN
    IF VBT.Parent(v) = NIL THEN RETURN FALSE END;
    WITH ref = GetAnchorRef(v) DO
      RETURN v = ref.activeAnchor
    END
  END IsActive;

PROCEDURE <A NAME="SetParent"><procedure>SetParent</procedure></A>(v: T; p: VBT.T) =
  BEGIN
    IF IsActive(v) THEN Crash() END;
    v.anchorParent := p
  END SetParent;

PROCEDURE <A NAME="GetParent"><procedure>GetParent</procedure></A>(v: T): VBT.T =
  BEGIN RETURN v.anchorParent END GetParent;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A>(v: T; n: CARDINAL;
  hfudge, vfudge: REAL) =
  BEGIN
    IF IsActive(v) THEN Crash() END;
    v.n := n; v.hfudge := hfudge; v.vfudge := vfudge
  END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(v: T; VAR n: CARDINAL; VAR hfudge, vfudge: REAL) =
  BEGIN
    n := v.n; hfudge := v.hfudge; vfudge := v.vfudge
  END Get;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;

BEGIN END AnchorBtnVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
