<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/BorderedVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/BorderedVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File: BorderedVBT.i3, by cgn, Tue Apr 21 22:00:25 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>BorderedVBT.T</CODE> is a filter whose parent's screen consists of the
   child's screen surrounded by a border.  The parent's shape is determined 
   from the child's shape by adding the border size.  

<P><PRE>INTERFACE <interface><A HREF="BorderedVBT.m3">BorderedVBT</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>;

TYPE
  <A HREF="BorderedVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(ch: VBT.T;
      size: REAL := Default;
      op: PaintOp.T := PaintOp.BgFg;
      txt: Pixmap.T := Pixmap.Solid): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes  <CODE>v</CODE> as a <CODE>BorderedVBT</CODE> with 
   child <CODE>ch</CODE> and marks <CODE>v</CODE> for redisplay. 
<P>
   The border size is given in millimeters.  The border will be painted
   in the untranslated texture <CODE>txt</CODE> using the paint op <CODE>op</CODE>.  
   
<P><PRE>CONST Default = 0.5;

PROCEDURE <A HREF="BorderedVBT.m3#New">New</A>(
    ch: VBT.T;
    size: REAL := Default;
    op: PaintOp.T := PaintOp.BgFg;
    txt: Pixmap.T := Pixmap.Solid)
    : T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BorderedVBT.m3#SetSize">SetSize</A>(v: T; newSize: REAL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the size of the border of <CODE>v</CODE> to <CODE>newSize</CODE> millimeters and
   mark <CODE>v</CODE> for redisplay.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BorderedVBT.m3#SetColor">SetColor</A>(
  v: T;
  op: PaintOp.T;
  txt := Pixmap.Solid);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the <CODE>op</CODE> and <CODE>texture</CODE> of <CODE>v</CODE> and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="BorderedVBT.m3#Get">Get</A>(
  v: T;
  VAR size: REAL;
  VAR op: PaintOp.T;
  VAR txt: Pixmap.T); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Fetch <CODE>v</CODE>'s parameters. </EM></BLOCKQUOTE><PRE>

END BorderedVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
