<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/BorderedVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/BorderedVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File: BorderedVBT.mod, by cgn, Tue Apr 21 22:00:25 1987 
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module>BorderedVBT</module> EXPORTS <A HREF="BorderedVBT.i3"><implements>BorderedVBT</A></implements>, <A HREF="BdrVBTClass.i3"><implements>BdrVBTClass</A></implements>;

IMPORT
  <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>,
  <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="FilterClass.i3">FilterClass</A>;

REVEAL
  <A NAME="T">T</A> = Private BRANDED OBJECT
        borderSize   : REAL;
        borderOp     : PaintOp.T;
        borderTexture: Pixmap.T;
      OVERRIDES
        repaintBorder := RepaintBorder;
        reshape       := Reshape;
        rescreen      := Rescreen;
        repaint       := Repaint;
        shape         := Shape;
        locate        := Locate;
        init          := Be
      END;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A>(v: T; READONLY pt: Point.T; VAR r: Rect.T): VBT.T =
  BEGIN
    RETURN VBT.Split.locate(v, pt, r)
  END Locate;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(
    v: T;
    ch: VBT.T;
    borderSize: REAL := Default;
    borderOp: PaintOp.T := PaintOp.Fg;
    borderTexture: Pixmap.T := Pixmap.Solid): T =
  BEGIN
    v.borderSize := borderSize;
    v.borderOp := borderOp;
    v.borderTexture := borderTexture;
    FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
      v.bSize[ax] := ROUND(VBT.MMToPixels(v, borderSize, ax))
    END;
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
    ch: VBT.T;
    borderSize: REAL := Default;
    borderOp: PaintOp.T := PaintOp.Fg;
    borderTexture: Pixmap.T := Pixmap.Solid)
    : T =
  BEGIN
    RETURN Be(NEW(T), ch, borderSize, borderOp, borderTexture)
  END New;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A>(v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange
  RAISES {} =
  VAR temp: VBT.SizeRange; bw := 2 * v.bSize[ax]; BEGIN
    IF v.ch = NIL THEN
      temp := VBT.DefaultShape
    ELSE
      IF n &gt; bw THEN
        n := n - bw
      ELSE
        n := 0
      END;
      temp := VBTClass.GetShape(v.ch, ax, n)
    END;
    RETURN VBT.SizeRange{lo := temp.lo + bw, hi := temp.hi + bw,
                         pref := temp.pref + bw}
  END Shape;

PROCEDURE <A NAME="SetSize"><procedure>SetSize</procedure></A>(v: T; newSize: REAL) =
  BEGIN
    IF newSize # v.borderSize THEN
      v.borderSize := newSize;
      FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
        v.bSize[ax] := ROUND(VBT.MMToPixels(v, newSize, ax))
      END;
      VBT.NewShape(v);
      VBT.Mark(v)
    END
  END SetSize;

PROCEDURE <A NAME="SetColor"><procedure>SetColor</procedure></A>(
  v: T;
  op: PaintOp.T;
  texture: Pixmap.T := Pixmap.Solid) =
  BEGIN
    v.borderOp := op;
    v.borderTexture := texture;
    VBT.Mark(v)
  END SetColor;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(
  v: T;
  VAR size: REAL;
  VAR op: PaintOp.T;
  VAR texture: Pixmap.T) =
  BEGIN
    size := v.borderSize;
    op := v.borderOp;
    texture := v.borderTexture
  END Get;

PROCEDURE <A NAME="RepaintBorder"><procedure>RepaintBorder</procedure></A>(v: T; READONLY clip: Rect.T) RAISES {} =
  (* repaint the part of v's border that lies within clip. LL = VBT.mu. *)
  VAR a: Rect.Partition;
  BEGIN
    Rect.Factor(
      Rect.Meet(v.domain, clip),
      ChDom(v), a, 0, 0);
    a[2] := a[4];
    VBT.PolyTexture(v, SUBARRAY(a, 0, 4),
      v.borderOp, v.borderTexture)
  END RepaintBorder;

PROCEDURE <A NAME="ChDom"><procedure>ChDom</procedure></A>(v: T): Rect.T =
</PRE><BLOCKQUOTE><EM> Compute child domain from v's domain and border sizes </EM></BLOCKQUOTE><PRE>
  BEGIN
    WITH dh = v.bSize[Axis.T.Hor], dv = v.bSize[Axis.T.Ver] DO
      RETURN Rect.Change(v.domain, dh, -dh, dv, -dv)
    END
  END ChDom;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  VAR chDom: Rect.T;
  BEGIN
    VBTClass.LocateChanged(v);
    IF v.ch # NIL THEN
      chDom := ChDom(v);
      VBTClass.Reshape(v.ch, new := chDom, saved := cd.saved)
    END;
    IF NOT Rect.IsEmpty(cd.new) THEN
      v.repaintBorder(cd.new)
    END
  END Reshape;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A>(v: T; READONLY cd: VBT.RescreenRec) RAISES {} =
  BEGIN
    FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
      v.bSize[ax] := ROUND(VBT.MMToPixels(v, v.borderSize, ax))
    END;
    VBT.NewShape(v);
    Filter.T.rescreen(v, cd)
  END Rescreen;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A>(v: T; READONLY badR: Region.T) RAISES {} =
  BEGIN
    Filter.T.repaint(v, badR);
    v.repaintBorder(badR.r)
  END Repaint;

BEGIN
END BorderedVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
