<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ButtonVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ButtonVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>ButtonVBT.T</CODE> is a filter with an associated action procedure that
   is called when the user clicks on the button or makes some other
   appropriate gesture.
<P>
   Different subtypes of <CODE>ButtonVBTs</CODE> invoke the action procedure on
   different user gestures, but all <CODE>ButtonVBTs</CODE> have the three methods
   <CODE>pre</CODE>, <CODE>post</CODE>, and <CODE>cancel</CODE>.  They all interpret user gestures in
   such a way that the sequence of calls will be in the regular
   expression
<P>
<PRE>
      ( (pre cancel) | (pre action post) )*
</PRE>
   The minimum, maximum, and preferred size of a <CODE>ButtonVBT</CODE> 
   are all equal to the minimum size of its child, in each axis.  

<P><PRE>INTERFACE <interface><A HREF="ButtonVBT.m3">ButtonVBT</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="PackSplit.i3">PackSplit</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>;

TYPE
  <A HREF="ButtonVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT (*CONST*)
    action: Proc
  METHODS
    &lt;* LL.sup = VBT.mu *&gt;
    pre();
    post();
    cancel();
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(ch: VBT.T;
      action: Proc;
      ref: REFANY := NIL): T;
  END;

  Proc =
    PROCEDURE(self: T; READONLY cd: VBT.MouseRec);
    &lt;* LL.sup = VBT.mu *&gt;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> with child <CODE>ch</CODE> and action
   proc <CODE>action</CODE> and adds <CODE>ref</CODE> to <CODE>v</CODE>'s property set if it is not
   <CODE>NIL</CODE>.  The action procedure can access <CODE>ref</CODE> (if it is not <CODE>NIL</CODE>)
   by calling <CODE>VBT.GetProp</CODE>.
<P>
   The mouse and position methods of a <CODE>ButtonVBT.T</CODE> call the
   <CODE>pre</CODE> method on a down click, and then call the <CODE>cancel</CODE> method if
   the user chords by clicking another mouse button or if the user
   moves the mouse out of the button.  Otherwise they call the action
   procedure <CODE>proc</CODE> if the user releases the mouse button.
<P>
   The default <CODE>pre</CODE> method highlights the button, the default <CODE>post</CODE> and 
   <CODE>cancel</CODE> methods unhighlight it.  Consequently there should be a 
   <CODE>HighlightVBT</CODE> somewhere above the button.  Since <CODE>Trestle.Install</CODE>
   automatically inserts a <CODE>HighlightVBT</CODE>, you usually don't have
   to worry about this.
<P>
   The action procedure is a field rather than a method in order to 
   allow buttons with different action procedures to share their 
   method suites. 

<P><PRE>PROCEDURE <A HREF="ButtonVBT.m3#New">New</A>(
  ch: VBT.T;
  action: Proc;
  ref: REFANY := NIL): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ButtonVBT.m3#MenuBar">MenuBar</A>(
  ch0, ch1, ch2, ch3, ch4, ch5,
    ch6, ch7, ch8, ch9: VBT.T := NIL;
  op: PaintOp.T := PaintOp.Bg)
  : PackSplit.T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>PackSplit</CODE> with the given children, left-justified,
   and with its background painted with <CODE>op</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>MenuBar</CODE> is convenient for building a horizontal row of buttons.
   If the row fills up, the extra buttons will wrap to the next line. 

<P><PRE>END ButtonVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
