<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ButtonVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ButtonVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="ButtonVBT.i3">ButtonVBT</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="HighlightVBT.i3">HighlightVBT</A>, <A HREF="BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="Split.i3">Split</A>,
  <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="PackSplit.i3">PackSplit</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>;

FROM <A HREF="../vbt/VBT.i3">VBT</A> IMPORT ClickType;

REVEAL
  <A NAME="T">T</A> = BtnVBTClass.T BRANDED OBJECT
    highlighter: HighlightVBT.T := NIL
  OVERRIDES
    mouse := Mouse;
    position := Position;
    shape := Shape;
    pre := Pre;
    post := Post;
    cancel := Post; (*sic*)
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: T; ch: VBT.T; p: Proc; ref: REFANY := NIL): T RAISES {} =
  BEGIN
    v.action := p;
    IF ref # NIL THEN VBT.PutProp(v, ref) END;
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
    ch: VBT.T;
    action: Proc;
    ref: REFANY := NIL): T RAISES {} =
  BEGIN
    RETURN Be(NEW(T), ch, action, ref)
  END New;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) RAISES {} =
  BEGIN
    Filter.T.mouse(v, cd);
    IF cd.clickType = ClickType.FirstDown THEN
      v.ready := TRUE;
      v.armed := TRUE;
      v.pre();
      VBT.SetCage(v, VBT.InsideCage)
    ELSE
      IF (cd.clickType = ClickType.LastUp) AND NOT cd.cp.gone AND v.armed
      THEN
        IF NOT v.ready THEN v.pre() END;
        v.action(v, cd);
        v.post()
      ELSIF v.ready THEN
        v.cancel()
      END;
      v.ready := FALSE;
      v.armed := FALSE
    END
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(v: T; READONLY cd: VBT.PositionRec) RAISES {} =
  BEGIN
    Filter.T.position(v, cd);
    IF v.armed THEN
      IF cd.cp.gone THEN
        IF v.ready THEN
          v.cancel();
          v.ready := FALSE
        END;
        VBT.SetCage(v, VBT.GoneCage)
      ELSE
        IF NOT v.ready THEN
          v.ready := TRUE;
          v.pre()
        END;
        VBT.SetCage(v, VBT.InsideCage)
      END
    ELSE
      VBT.SetCage(v, VBT.EverywhereCage)
    END
  END Position;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A>(v: T) RAISES {} =
  BEGIN
    v.highlighter := HighlightVBT.Find(v);
    HighlightVBT.Invert(v.highlighter, VBT.Domain(v), 99999)
  END Pre;

PROCEDURE <A NAME="Post"><procedure>Post</procedure></A>(v: T) RAISES {} =
  BEGIN
    HighlightVBT.SetRect(v.highlighter, Rect.Empty, 0);
    v.highlighter := NIL
  END Post;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A>(v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange RAISES {} =
  BEGIN
    WITH sh = VBTClass.GetShape(Filter.Child(v), ax, n) DO
      RETURN VBT.SizeRange{lo := sh.lo, hi := sh.lo+1, pref := sh.lo}
    END
  END Shape;

PROCEDURE <A NAME="MenuBar"><procedure>MenuBar</procedure></A>(
  ch0, ch1, ch2, ch3, ch4, ch5, ch6, ch7, ch8, ch9: VBT.T := NIL;
  op: PaintOp.T := PaintOp.Bg)
  : PackSplit.T RAISES {} =
  VAR res := NEW(Bar);
  BEGIN
    EVAL PackSplit.T.init(res, op := op);
    Split.AddChild(res, ch0, ch1, ch2, ch3, ch4, ch5, ch6, ch7, ch8, ch9);
    RETURN res
  END MenuBar;

PROCEDURE <A NAME="BarShape"><procedure>BarShape</procedure></A>(v: Bar; ax: Axis.T; n: CARDINAL): VBT.SizeRange RAISES {} =
  VAR sh := PackSplit.T.shape(v, ax, n); BEGIN
    IF ax # PackSplit.AxisOf(v) THEN sh.hi := sh.lo+1; sh.pref := sh.lo END;
    RETURN sh
  END BarShape;

TYPE Bar = PackSplit.T OBJECT OVERRIDES shape := BarShape END;

BEGIN END ButtonVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
