<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/ComposeKey.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/ComposeKey.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Jim Meehan and Mark Manasse                                            

<P><PRE>INTERFACE <interface><A HREF="ComposeKey.m3">ComposeKey</A></interface>;
</PRE> Software support for composing non-standard characters 

<P><PRE>IMPORT <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="ComposeKey.m3#T">T</A> &lt;: Public;
  Public =
    OBJECT
    METHODS
      filter  (cd: VBT.KeyRec): VBT.KeyRec;
      compose (k1, k2: VBT.KeySym): VBT.KeySym;
      feedback (composing: BOOLEAN)
    END;

END ComposeKey.
</PRE> On many keyboards, there is a key labeled <CODE>Compose</CODE> or <CODE>Compose
   Character</CODE>, which is used for typing non-standard characters such
   as an accented <CODE>e</CODE> or a copyright symbol. The two characters that
   are typed after the <CODE>Compose</CODE> key is pressed and released are
   combined to form one character.  For example, the key-sequence
   <CODE>Compose c comma</CODE> produces a lower-case c with a cedilla.
<P>
   Here is an example showing the intended use of this interface.
   Assume that <CODE>TextEditingVBT</CODE> is a subtype of <CODE>VBT</CODE> used for typing
   text, such as <CODE>TypeinVBT.T</CODE> or <CODE>TextPort.T</CODE>.  A client would
   override the <CODE>key</CODE> method in order to filter the keys delivered to
   the supertype's <CODE>key</CODE> method.
<P>
   Note that in some editing models, several keys can be generated from a
   single keystroke.  To support this, applications should keep invoking the
   filter method until the returned key is VBT.NoKey.  Subsequent calls
   to the method should use VBT.NoKey as the depressed key.  Here's an
   example of the use of this type:
<P>
<PRE>
      TYPE
        MyTextEditor =
          TextEditingVBT.T OBJECT
              comp: ComposeKey.T 
            OVERRIDES
              key := Key 
            END;
      
      PROCEDURE Key (v: MyTextEditor; READONLY inputCd; VBT.KeyRec) =
        VAR cd := inputCd; BEGIN
          IF inputCd.wentDown AND cd.whatChanged # VBT.NoKey THEN
            LOOP
              cd := v.comp.filter(cd);
              IF cd.whatChanged = VBT.NoKey THEN EXIT END;
              TextEditingVBT.T.key(v, cd);
              cd.whatChanged := VBT.NoKey
            END
          END
        END Key;
      
      VAR editor :=
        NEW (MyTextEditor, comp := NEW (ComposeKey.T));
</PRE>
   A <CODE>ComposeKey.T</CODE> maintains an internal state that keep track of the
   sequence of <CODE>VBT.KeyRec</CODE>s that are passed to the <CODE>filter</CODE> method.
   In its normal, initial state, the filter merely returns it
   argument.  For the first two keys in a composition-sequence, it
   returns a <CODE>VBT.KeyRec</CODE> whose <CODE>cd.whatChanged</CODE> is <CODE>VBT.NoKey</CODE>, and
   for the last key in the sequence, it returns a <CODE>VBT.KeyRec</CODE> whose
   <CODE>cd.whatChanged</CODE> represents the non-standard character.
<P>
   Using the previous example, three consecutive calls to <CODE>filter</CODE>
   with <CODE>Keyrec</CODE>s containing <CODE>Compose</CODE> (<CODE>KeyboardKey.Multi_key</CODE>), <CODE>c</CODE>,
   and <CODE>comma</CODE> will produce three <CODE>KeyRec</CODE>s. In the first two,
   <CODE>cd.whatChanged</CODE> will be <CODE>VBT.NoKey</CODE>; in the last one,
   <CODE>cd.whatChanged</CODE> will be <CODE>Latin1Key.ccedilla</CODE>.
<P>
   During the third call, <CODE>filter</CODE> passes the <CODE>KeySym</CODE>s for <CODE>c</CODE> and
   <CODE>comma</CODE> to <CODE>compose</CODE> to produce the non-standard character.  By
   default, the <CODE>compose</CODE> method uses VT220-style composition of ISO
   Latin-1 characters.  A client can override the <CODE>compose</CODE> method to
   produce some other style of composition.
  <P>
   The default <CODE>compose</CODE> method ignores case where there is no
   ambiguity.  For example, <CODE>c</CODE> and <CODE>o</CODE> can be combined to produce the
   copyright symbol; so can <CODE>C</CODE> and <CODE>O</CODE>, <CODE>c</CODE> and <CODE>O</CODE>, or <CODE>C</CODE> and <CODE>o</CODE>.
   By contrast, <CODE>e</CODE> and <CODE>`</CODE> can be combined to produce a lower-case
   <CODE>e</CODE> with a grave accent; <CODE>E</CODE> and <CODE>`</CODE>, however, produce an
   upper-case <CODE>E</CODE> with a grave accent.
<P>
   Unless both of the characters are alphanumeric, they can be
   combined in either order.  So <CODE>`</CODE> and <CODE>e</CODE> have the same effect as
   <CODE>e</CODE> and <CODE>`</CODE>, but <CODE>o</CODE> and <CODE>c</CODE> do {\em not} combine to form the
   copyright symbol.
<P>
   If there is no known combination for the two characters, then
   <CODE>compose</CODE> returns <CODE>VBT.NoKey</CODE>.
<P>
   The <CODE>ComposeKey</CODE> object is in one of two states; composing or not
   composing. When <CODE>filter</CODE> detects a state-change, it calls the
   <CODE>feedback</CODE> method with a flag indicating the state.  The default
   method is a no-op; a client may wish to override that in order to
   provide a visual cue to the user that key-composition is in effect
   (e.g., changing the cursor).  Otherwise, the user might not
   understand why typed character are not being ``echoed''.
<P>
   Here is the complete ISO Latin-1 combination-table (courtesy of
   Henri Gouraud of PRL).  The alternate keystroke sequences are ones
   where Bell Labs Plan 9 or the X consortium differ:
<P>
<PRE>
       ++    NUMBER SIGN
       '&lt;SP&gt; APOSTROPHE
       AA    AT SIGN
       ((    LEFT BRACKET
       //    BACKSLASH [also /&lt;]
       ))    RIGHT BRACKET
       ^&lt;SP&gt; CIRCUMFLEX [also &gt;&lt;SP&gt;]
       <KBD>&lt;SP&gt; GRAVE
|  (-    LEFT BRACE
|  /^    BAR [also vl]
|  )-    RIGHT BRACE
|  ~&lt;SP&gt; TILDE [also -&lt;SP&gt;]
| &lt;SP&gt;&lt;SP&gt;   NO-BREAK SPACE
|  !!    INVERTED EXCLAMATION MARK
|  c/    CENT SIGN [also c$, c|]
|  L-    POUND SIGN [also l$, l=]
|  XO    CURRENCY SIGN [also g$]
|  Y-    YEN SIGN [also y$, y=]
|  ||    BROKEN BAR [also vb, |^]
|  SO    SECTION SIGN [also SS (not ss!), s!] 
|  </KBD><KBD>    DIAERESIS
|  co    COPYRIGHT SIGN
|  a_    FEMININE ORDINAL INDICATOR [also sa]
|  &lt;&lt;    LEFT ANGLE QUOTATION MARK
|  -,    NOT SIGN [also no]
|  --    HYPHEN
|  RO    REGISTERED TRADE MARK SIGN
|  -^    MACRON [also __, _^]
|  0^    RING ABOVE, DEGREE SIGN [also de, 0*]
|  +-    PLUS-MINUS SIGN
|  2^    SUPERSCRIPT TWO [also s2]
|  3^    SUPERSCRIPT THREE [also s3]
|  ''    ACUTE ACCENT
|  /u    GREEK SMALL LETTER MU, MICRO SIGN [also *m] [BUT NOT mu!]
|  P!    PILCROW SIGN, PARAGRAPH [also pg]
|  .^    MIDDLE DOT [also ..]
|  ,,    CEDILLA
|  1^    SUPERSCRIPT ONE [also s1]
|  o_    MASCULINE ORDINAL INDICATOR [also s0, (sup 0)]
|  &gt;&gt;    RIGHT ANGLE QUOTATION MARK
|  14    VULGAR FRACTION ONE QUARTER
|  12    VULGAR FRACTION ONE HALF
|  34    VULGAR FRACTION THREE QUARTERS
|  ??    INVERTED QUESTION MARK
|  A</KBD>    LATIN CAPITAL LETTER A WITH GRAVE ACCENT
       A'    LATIN CAPITAL LETTER A WITH ACUTE ACCENT
       A^    LATIN CAPITAL LETTER A WITH CIRCUMFLEX ACCENT [also A&gt;]
       A~    LATIN CAPITAL LETTER A WITH TILDE [also A-]
       A&quot;    LATIN CAPITAL LETTER A WITH DIAERESIS
       A*    LATIN CAPITAL LETTER A WITH RING ABOVE [also oA]
       AE    CAPITAL DIPHTHONG AE
       C,    LATIN CAPITAL LETTER C WITH CEDILLA
       E<KBD>    LATIN CAPITAL LETTER E WITH GRAVE ACCENT 
|  E'    LATIN CAPITAL LETTER E WITH ACUTE ACCENT 
|  E^    LATIN CAPITAL LETTER E WITH CIRCUMFLEX ACCENT [also E&gt;]
|  E</KBD>    LATIN CAPITAL LETTER E WITH DIAERESIS
|  I</KBD>    LATIN CAPITAL LETTER I WITH GRAVE ACCENT 
       I'    LATIN CAPITAL LETTER I WITH ACUTE ACCENT 
       I^    LATIN CAPITAL LETTER I WITH CIRCUMFLEX ACCENT [also I&gt;]
       I&quot;    LATIN CAPITAL LETTER I WITH DIAERESIS
       D-    CAPITAL ICELANDIC LETTER ETH
       N~    LATIN CAPITAL LETTER N WITH TILDE [also N-]
       O<KBD>    LATIN CAPITAL LETTER O WITH GRAVE ACCENT 
|  O'    LATIN CAPITAL LETTER O WITH ACUTE ACCENT 
|  O^    LATIN CAPITAL LETTER O WITH CIRCUMFLEX ACCENT [also O&gt;]
|  O~    LATIN CAPITAL LETTER O WITH TILDE [also O-]
|  O</KBD>    LATIN CAPITAL LETTER O WITH DIAERESIS
|  xx    MULTIPLICATION SIGN [also mu]
|  O/    LATIN CAPITAL LETTER O WITH OBLIQUE STROKE
|  U</KBD>    LATIN CAPITAL LETTER U WITH GRAVE ACCENT 
       U'    LATIN CAPITAL LETTER U WITH ACUTE ACCENT 
       U^    LATIN CAPITAL LETTER U WITH CIRCUMFLEX [also U&gt;]
       U&quot;    LATIN CAPITAL LETTER U WITH DIAERESIS
       Y'    LATIN CAPITAL LETTER Y WITH ACUTE ACCEN
       TH    CAPITAL ICELANDIC LETTER THORN [also |P]
       ss    SMALL GERMAN LETTER SHARP s
       a<KBD>    LATIN SMALL LETTER a WITH GRAVE ACCENT
|  a'    LATIN SMALL LETTER a WITH ACUTE ACCENT
|  a^    LATIN SMALL LETTER a WITH CIRCUMFLEX ACCENT [also a&gt;]
|  a~    LATIN SMALL LETTER a WITH TILDE [also a-]
|  a</KBD>    LATIN SMALL LETTER a WITH DIAERESIS
|  a*    LATIN SMALL LETTER a WITH RING ABOVE [also oa]
|  ae    SMALL DIPHTHONG ae
|  c,    LATIN SMALL LETTER c WITH CEDILLA
|  e</KBD>    LATIN SMALL LETTER e WITH GRAVE ACCENT
       e'    LATIN SMALL LETTER e WITH ACUTE ACCENT
       e^    LATIN SMALL LETTER e WITH CIRCUMFLEX ACCENT [also e&gt;]
       e&quot;    LATIN SMALL LETTER e WITH DIAERESIS
       i<KBD>    LATIN SMALL LETTER i WITH GRAVE ACCENT
|  i'    LATIN SMALL LETTER i WITH ACUTE ACCENT
|  i^    LATIN SMALL LETTER i WITH CIRCUMFLEX ACCENT [also i&gt;]
|  i</KBD>    LATIN SMALL LETTER i WITH DIAERESIS
|  d-    SMALL ICELANDIC LETTER ETH
|  n~    LATIN SMALL LETTER n WITH TILDE [also n-]
|  o</KBD>    LATIN SMALL LETTER o WITH GRAVE ACCENT
       o'    LATIN SMALL LETTER o WITH ACUTE ACCENT
       o^    LATIN SMALL LETTER o WITH CIRCUMFLEX ACCENT [also o&gt;]
       o~    LATIN SMALL LETTER o WITH TILDE [also o-]
       o&quot;    LATIN SMALL LETTER o WITH DIAERESIS
       -:    DIVISION SIGN
       o/    LATIN SMALL LETTER o WITH OBLIQUE STROKE
       u<KBD>    LATIN SMALL LETTER u WITH GRAVE ACCENT
|  u'    LATIN SMALL LETTER u WITH ACUTE ACCENT
|  u^    LATIN SMALL LETTER u WITH CIRCUMFLEX ACCENT [also u&gt;]
|  u</KBD>    LATIN SMALL LETTER u WITH DIAERESIS
|  y'    LATIN SMALL LETTER y WITH ACUTE ACCENT
|  th    SMALL ICELANDIC LETTER THORN [also |p]
|  y<KBD>    LATIN SMALL LETTER y WITH DIAERESIS


*)
 
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
