<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/DblBufferUtil.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/DblBufferUtil.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

UNSAFE MODULE <module><implements><A HREF="DblBufferUtil.i3">DblBufferUtil</A></implements></module>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Path.i3">Path</A>, <A HREF="#x1">PathPrivate</A>, <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../vbt/BatchRep.i3">BatchRep</A>,
  <A HREF="../vbt/PaintPrivate.i3">PaintPrivate</A>, <A HREF="../vbt/PaintExt.i3">PaintExt</A>, <A HREF="../../../word/src/Word.i3">Word</A>, <A HREF="../../../arith/src/Math.i3">Math</A>;

TYPE Com = PaintPrivate.PaintCommand;

CONST
  MiterLimit = 11.0d0;	    (* in degrees *)
  ToRadians = 3.14159265358979324d0 / 180.0d0;

VAR (* CONST *)
  MiterFactor: LONGREAL;    (* 1.0 / sin((ToRadians * MiterLimit) / 2.0) *)

PROCEDURE <A NAME="Tighten"><procedure>Tighten</procedure></A>(ba: Batch.T) =
  VAR
    cptr: PaintPrivate.CommandPtr := BatchUtil.Succ(ba, NIL);
    doClip := ba.clipped = BatchUtil.ClipState.Unclipped;
    baClip := ba.clip;
    res := Rect.Empty;
  BEGIN
    WHILE cptr # NIL DO
      IF doClip AND NOT Rect.Subset(cptr.clip, baClip) THEN
        (* clip the command's &quot;clip&quot; to the batch's &quot;clip&quot; *)
        IF cptr.command = Com.TextCom THEN
          VAR tptr := LOOPHOLE(cptr, PaintPrivate.TextPtr); BEGIN
            tptr.props := tptr.props +
              PaintPrivate.Props{PaintPrivate.Prop.Clipped}
          END
        END;
        cptr.clip := Rect.Meet(cptr.clip, baClip)
      END;
      IF cptr.command = Com.ExtensionCom THEN
        VAR
          eptr := LOOPHOLE(cptr, PaintPrivate.ExtensionPtr);
          rect := ExtensionBB(eptr);
        BEGIN
          cptr.clip := Rect.Meet(cptr.clip, rect);
          res := Rect.Join(res, cptr.clip);
          (* clip any following &quot;RepeatCom&quot;'s by &quot;rect&quot; *)
          LOOP
            cptr := BatchUtil.Succ(ba, cptr);
            IF cptr = NIL OR cptr.command # Com.RepeatCom THEN EXIT END;
            IF doClip THEN cptr.clip := Rect.Meet(cptr.clip, baClip) END;
            cptr.clip := Rect.Meet(cptr.clip, rect);
            res := Rect.Join(res, cptr.clip)
          END
        END
      ELSE
        res := Rect.Join(res, cptr.clip);
        cptr := BatchUtil.Succ(ba, cptr)
      END;
    END;
    ba.clip := res;
    ba.clipped := BatchUtil.ClipState.Tight
  END Tighten;

PROCEDURE <A NAME="ExtensionBB"><procedure>ExtensionBB</procedure></A>(eptr: PaintPrivate.ExtensionPtr): Rect.T =
  VAR res: Rect.T; BEGIN
    CASE eptr.subCommand OF
      PaintExt.FillCommand =&gt;
        VAR fptr := LOOPHOLE(eptr, PaintExt.FillPtr); BEGIN
          res := PathBB(eptr, ADR(fptr.path))
        END
    | PaintExt.StrokeCommand =&gt;
        VAR sptr := LOOPHOLE(eptr, PaintExt.StrokePtr); grow: INTEGER; BEGIN
          res := PathBB(eptr, ADR(sptr.path));
          IF sptr.width # 0 THEN
            grow := (sptr.width + 1) DIV 2;
            IF sptr.join = VBT.JoinStyle.Miter THEN
              grow := CEILING(FLOAT(grow, LONGREAL) * MiterFactor)
            END;
            res := Rect.Inset(res, -grow)
          END
        END
    | PaintExt.LineCommand =&gt;
        VAR lptr := LOOPHOLE(eptr, PaintExt.LinePtr); BEGIN
          res := RectHull(lptr.p, lptr.q);
          IF lptr.width # 0 THEN
            res := Rect.Inset(res, -((lptr.width + 1) DIV 2))
          END
        END
    ELSE
        RETURN Rect.Full
    END;
    RETURN Rect.Add(res, eptr.delta)
  END ExtensionBB;

PROCEDURE <A NAME="RectHull"><procedure>RectHull</procedure></A>(READONLY p, q: Point.T): Rect.T =
  BEGIN
    RETURN Rect.T{
      MIN(p.h, q.h), MAX(p.h, q.h) + 1,
      MIN(p.v, q.v), MAX(p.v, q.v) + 1}
  END RectHull;

PROCEDURE <A NAME="PathBB"><procedure>PathBB</procedure></A>(
    eptr: PaintPrivate.ExtensionPtr;
    pptr: PaintExt.PathPtr)
  : Rect.T =
  &lt;* FATAL Path.Malformed *&gt;
  VAR path := NEW(Path.T); BEGIN
    path.curveCount := pptr.curveCount;
    path.start := pptr + ADRSIZE(pptr^); (* skip &quot;curveCount&quot; field *)
    VAR end := eptr + (eptr.szOfRec * ADRSIZE(Word.T)); BEGIN
      path.next := end;
      path.end := end;
      path.current := end
    END;
    RETURN Path.BoundingBox(path)
  END PathBB;

BEGIN
  (* initialize MiterFactor *)
  MiterFactor := 1.0d0 / Math.sin((ToRadians * MiterLimit) / 2.0d0);
END DblBufferUtil.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface PathPrivate is in:
</A><UL>
<LI><A HREF="../../../geometry/src/PathPrivate.i3#0TOP0">geometry/src/PathPrivate.i3</A>
<LI><A HREF="../../../mg/src/PathPrivate.i3#0TOP0">mg/src/PathPrivate.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
