<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/DblBufferVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/DblBufferVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

INTERFACE <interface><A HREF="DblBufferVBT.m3">DblBufferVBT</A></interface>;
</PRE> A <CODE>DblBufferVBT.T</CODE> is a filter that redirects its child's painting
   operations to an off-screen buffer, and then updates its screen from the
   buffer whenever its <CODE>sync</CODE> method is invoked.
<P>
   The child coordinate system of a double-buffer VBT is a translation of its
   parent's coordinate system. You can compute the translation vector between
   the parent and child by subtracting the northwest corners of their domains.
<P>
   A double-buffer VBT <CODE>v</CODE> does not forward repaint events to its child;
   instead, it repaints by copying from the off-screen buffer.
<P>
   A double-buffer VBT maintains a {\it damaged rectangle}, which contains all
   points in the off-screen buffer that have been painted since the last time
   the damaged rectangle was reset. Calling <CODE>VBT.Sync</CODE> on a double-buffer VBT
   resets its damaged rectangle to be empty. 

<P><PRE>IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>;

TYPE <A HREF="DblBufferVBT.m3#T">T</A> &lt;: Filter.T;
</PRE> The call <CODE>NEW(DblBufferVBT.T).init(ch)</CODE> returns a newly initialized
   double-buffer VBT with child <CODE>ch</CODE>. 

<P><PRE>PROCEDURE <A HREF="DblBufferVBT.m3#GetDamaged">GetDamaged</A>(v: VBT.Leaf): Rect.T; &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Requires that some proper ancestor of <CODE>v</CODE> be a <CODE>T</CODE>. Returns the damaged
   rectangle for the first such ancestor. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="DblBufferVBT.m3#SetDamaged">SetDamaged</A>(v: VBT.Leaf; READONLY r: Rect.T); &lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Requires that some proper ancestor of <CODE>v</CODE> be a <CODE>T</CODE>. Sets the damaged
   rectangle for the first such ancestor to be <CODE>r</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>GetDamaged</CODE> and <CODE>SetDamaged</CODE> force all paint batches from <CODE>v</CODE> up to the
   first proper ancestor double-buffer <CODE>db</CODE> to guarantee that the damaged
   rectangle reflects painting done to these decendants. This will work
   smoothly if <CODE>v</CODE> is the only leaf decendant of <CODE>db</CODE> (i.e., if all splits
   between them are filters). Otherwise, you may get the wrong answer due to
   unforced paint batches on other leaf decendants. 

<P><PRE>END DblBufferVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
