<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/DblBufferVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/DblBufferVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="DblBufferVBT.i3">DblBufferVBT</A></implements></module>;

IMPORT <A HREF="Filter.i3">Filter</A>, <A HREF="FilterClass.i3">FilterClass</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>,
  <A HREF="../vbt/Trestle.i3">Trestle</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../trestle/InstalledVBT.i3">InstalledVBT</A>, <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>,
  <A HREF="../vbt/MouseSplit.i3">MouseSplit</A>, <A HREF="DblBufferUtil.i3">DblBufferUtil</A>;
</PRE> A <CODE>DblBufferVBT.T</CODE> <CODE>v</CODE> is implemented by creating a VBT <CODE>offscreen(v)</CODE> that
   is installed off-screen. The <CODE>paintbatch</CODE> method is overridden to forward
   paint batches to <CODE>offscreen(v)</CODE>. The operation <CODE>VBT.Sync(v)</CODE> updates the
   on-screen VBT from the portion of <CODE>offscreen(v)</CODE> that has changed since the
   last update.
<P>
   Because <CODE>offscreen(v)</CODE> is installed off screen, the northwest corner of its
   domain has the coordinates <CODE>(0, 0)</CODE>. The <CODE>reshape</CODE> method arranges for the
   double-buffer's child's domain to agree with the domain of <CODE>offscreen(v)</CODE>.
   The double-buffer maintains a vector <CODE>delta(v)</CODE>, which is the difference
   between the parent's and child's coordinate systems. In practice, <CODE>delta(v)
   = Rect.Northwest(VBT.Domain(v))</CODE>.
<P>
   The double-buffer also maintains a rectangle <CODE>badRect(v)</CODE> in the child's
   coordinate system. The rectangle <CODE>badRect(v)</CODE> is a (not necessarily
   tightest) bounding box on the portion of <CODE>offscreen(v)</CODE> that has changed
   since the last update. 

<P><PRE>REVEAL
  <A NAME="T">T</A> = Filter.T BRANDED OBJECT
    &lt;* LL &gt;= { VBT.mu.SELF, SELF } *&gt;
    delta := Point.Origin;          (* child coord + delta = parent coord. *)
    screenId: VBT.ScreenID := -1;
    &lt;* LL &gt;= { SELF } *&gt;
    offScreen: VBT.T := NIL;
    badRect, damaged: Rect.T;                   (* in child coordinates *)
  OVERRIDES
    (* split methods *)
    &lt;* LL &gt;= {VBT.mu, SELF, ch} *&gt;
    beChild := BeChild;

    (* VBT down methods *)
    &lt;* LL.sup = VBT.mu.SELF *&gt;
    reshape := Reshape;
    repaint := Repaint;
    rescreen := Rescreen;
    &lt;* LL.sup = VBT.mu *&gt;
    mouse := Mouse;
    position := Position;

    (* VBT up methods *)
    &lt;* LL.sup = ch *&gt;
    setcage := SetCage;
    setcursor := SetCursor;
    paintbatch := PaintBatch;
    sync := Sync;
    capture := Capture;
    screenOf := ScreenOf;
  END;
</PRE> Split Method Implementations -------------------------------------------- 

<P><PRE>PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A>(v: T; ch: VBT.T) RAISES {} =
  &lt;* LL &gt;= {VBT.mu, v, ch} *&gt;
  BEGIN
    Filter.T.beChild(v, ch);
    VBTClass.ClearShortCircuit(ch)
  END BeChild;
</PRE> Down Method Implementations --------------------------------------------- 

<P> In the down direction, argument points and rectangles must be translated
   from the parent's coordinate system to the child's coordinate system. This
   is accomplished by subtracting <CODE>delta(prnt)</CODE>. 

<P><PRE>PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(prnt: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
</PRE><BLOCKQUOTE><EM> Create and install a new off-screen VBT with <CODE>prnt</CODE>'s width and height, set
   the new value <CODE>delta(prnt)</CODE>, and recursively reshape the child so it has
   the same domain as <CODE>offscreen(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu.prnt *&gt;
  VAR child := prnt.ch; delta := Rect.NorthWest(cd.new); BEGIN
    SetupOffScreen(prnt);
    IF child # NIL THEN
      LOCK prnt DO prnt.delta := delta END;
      VBTClass.Reshape(child, Rect.Sub(cd.new, delta), Rect.Empty)
    END
  END Reshape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A>(prnt: T; READONLY rgn: Region.T) RAISES {} =
</PRE><BLOCKQUOTE><EM> Merge <CODE>rgn</CODE> with <CODE>badRect(prnt)</CODE>, and then update the on-screen VBT. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu.prnt *&gt;
  BEGIN
    LOCK prnt DO
      prnt.badRect := Rect.Join(prnt.badRect, Rect.Sub(rgn.r, prnt.delta))
    END;
    Update(prnt)
  END Repaint;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A>(prnt: T; READONLY cd: VBT.RescreenRec) =
</PRE><BLOCKQUOTE><EM> Cache the current screen-id, and then call the parent type's <CODE>rescreen</CODE>
   method. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu.prnt *&gt;
  VAR screen := Trestle.ScreenOf(prnt, Point.Origin); BEGIN
    LOCK prnt DO prnt.screenId := screen.id END;
    Filter.T.rescreen(prnt, cd)
  END Rescreen;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(prnt: T; READONLY cd: VBT.MouseRec) RAISES {} =
</PRE><BLOCKQUOTE><EM> If <CODE>NOT cd.cp.gone</CODE>, invoke the parent type's <CODE>mouse</CODE> method with the mouse
   location translated by <CODE>-delta(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu *&gt;
  VAR cdP: VBT.MouseRec; child := prnt.ch; BEGIN
    IF prnt.ch # NIL THEN
      cdP := cd;
      IF NOT cd.cp.gone THEN
        cdP.cp.pt := Point.Sub(cdP.cp.pt, prnt.delta)
      END;
      VBTClass.Mouse(child, cdP)
    END
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(prnt: T; READONLY cd: VBT.PositionRec) RAISES {} =
</PRE><BLOCKQUOTE><EM> If <CODE>NOT cd.cp.offScreen</CODE>, invoke the parent type's <CODE>position</CODE> method with
   the mouse location translated by <CODE>-delta(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu *&gt;
  VAR cdP: VBT.PositionRec; child := prnt.ch; BEGIN
    IF prnt.ch # NIL THEN
      cdP := cd;
      IF NOT cd.cp.offScreen THEN
        cdP.cp.pt := Point.Sub(cd.cp.pt, prnt.delta)
      END;
      VBTClass.Position(child, cdP)
    END
  END Position;
</PRE> Up Method Implementations ----------------------------------------------- 

<P> In the up direction, argument points and rectangles must be translated
   from the child's coordinate system to the parent's coordinate system. This
   is accomplished by adding <CODE>delta(prnt)</CODE>. 

<P><PRE>PROCEDURE <A NAME="SetCage"><procedure>SetCage</procedure></A>(prnt: T; ch: VBT.T) RAISES {} =
</PRE><BLOCKQUOTE><EM> If the child <CODE>ch</CODE>'s cage is non-trivial and refers to the same screen as
   that of its parent <CODE>prnt</CODE>, then translate the cage to parent coordinates
   and recursively propagate the message up the VBT tree. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = ch *&gt;
  VAR cg := VBTClass.Cage(ch); BEGIN
    LOCK prnt DO
      IF cg.rect # Rect.Full AND prnt.screenId = cg.screen THEN
        cg.rect := Rect.Add(cg.rect, prnt.delta)
      END;
      VBTClass.SetCage(prnt, cg)
    END
  END SetCage;

PROCEDURE <A NAME="SetCursor"><procedure>SetCursor</procedure></A>(prnt: T; ch: VBT.T) RAISES {} =
  VAR cs := ch.getcursor();
  BEGIN (* LL=ch *)
    LOCK prnt DO
      IF cs # prnt.effectiveCursor THEN
        prnt.effectiveCursor := cs;
        IF prnt.parent # NIL THEN prnt.parent.setcursor(prnt) END
      END
    END
  END SetCursor;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A>(prnt: T; &lt;*UNUSED*&gt; ch: VBT.T; ba: Batch.T) RAISES {} =
</PRE><BLOCKQUOTE><EM> Merge <CODE>badRect(prnt)</CODE> with a bounding box of the painting commands <CODE>ba</CODE>;
   then forward the paint batch to <CODE>offscreen(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = ch *&gt;
  VAR offScreen: VBT.T; clip: Rect.T; BEGIN
    DblBufferUtil.Tighten(ba);
    clip := BatchUtil.GetClip(ba);
    LOCK prnt DO
      offScreen := prnt.offScreen;
      prnt.badRect := Rect.Join(prnt.badRect, clip);
      prnt.damaged := Rect.Join(prnt.damaged, clip)
    END;
    VBTClass.PaintBatch(offScreen, ba)
  END PaintBatch;

PROCEDURE <A NAME="Sync"><procedure>Sync</procedure></A>(prnt: T; &lt;*UNUSED*&gt; ch: VBT.T; wait: BOOLEAN) =
</PRE><BLOCKQUOTE><EM> Update the on-screen VBT from <CODE>offscreen(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = ch *&gt;
  BEGIN
    Update(prnt, wait);
    LOCK prnt DO prnt.damaged := Rect.Empty END
  END Sync;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY rect: Rect.T;
    VAR (*OUT*) br: Region.T)
    : ScrnPixmap.T RAISES {} =
</PRE><BLOCKQUOTE><EM> The rectangle <CODE>rect</CODE> is in <CODE>ch</CODE>'s coordinate system. Capture the rectangle
   <CODE>rect</CODE> from the VBT <CODE>offscreen(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = ch *&gt;
  VAR offScreen: VBT.T; BEGIN
    LOCK prnt DO offScreen := prnt.offScreen END;
    RETURN VBT.Capture(offScreen, rect, br)
  END Capture;

PROCEDURE <A NAME="ScreenOf"><procedure>ScreenOf</procedure></A>(
    prnt: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY pt: Point.T)
    : Trestle.ScreenOfRec RAISES {} =
</PRE><BLOCKQUOTE><EM> The point <CODE>pt</CODE> is in <CODE>ch</CODE>'s coordinate system. Recurse on <CODE>prnt</CODE> with the
   point <CODE>pt</CODE> translated by <CODE>delta(prnt)</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = ch *&gt;
  VAR delta: Point.T; BEGIN
    LOCK prnt DO delta := prnt.delta END;
    RETURN Trestle.ScreenOf(prnt, Point.Add(pt, delta));
  END ScreenOf;

PROCEDURE <A NAME="ForceBatches"><procedure>ForceBatches</procedure></A>(v: VBT.Leaf): T =
</PRE><BLOCKQUOTE><EM> Force the paint batches of all ancestors of <CODE>v</CODE> up to a VBT of type <CODE>T</CODE>,
   and return that VBT. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup &lt; v *&gt;
  BEGIN
    WHILE NOT ISTYPE(v, T) DO
      LOCK v DO VBTRep.ForceBatch(v) END;
      v := VBT.Parent(v)
    END;
    &lt;* ASSERT v # NIL *&gt;
    RETURN v
  END ForceBatches;

PROCEDURE <A NAME="GetDamaged"><procedure>GetDamaged</procedure></A>(v: VBT.Leaf): Rect.T =
   &lt;* LL.sup &lt; v *&gt;
   VAR db: T := ForceBatches(v); BEGIN
     LOCK db DO RETURN db.damaged END
   END GetDamaged;

PROCEDURE <A NAME="SetDamaged"><procedure>SetDamaged</procedure></A>(v: VBT.Leaf; READONLY r: Rect.T) =
   &lt;* LL.sup &lt; v *&gt;
   VAR db: T := ForceBatches(v); BEGIN
     LOCK db DO db.damaged := r END
   END SetDamaged;
</PRE> Create/capture the off-screen VBT --------------------------------------- 

<P><PRE>PROCEDURE <A NAME="SetupOffScreen"><procedure>SetupOffScreen</procedure></A>(v: T) =
</PRE><BLOCKQUOTE><EM> Initialize <CODE>v</CODE>'s off-screen VBT. The VBT installed offscreen is a
   <CODE>Filter.T</CODE> containing a <CODE>VBT.Leaf</CODE>. The field <CODE>v.offScreen</CODE> is set to the
   leaf. The offscreen VBT is created with the same width and height as <CODE>v</CODE>.
   This procedure also has the side-effect of initializing <CODE>v.badRect</CODE> to
   <CODE>Rect.Full</CODE>. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup = VBT.mu.v *&gt;
  VAR offScreen: VBT.T; BEGIN
    (* Delete and discard the current off-screen VBT (if any) *)
    LOCK v DO
      offScreen := v.offScreen;
      v.offScreen := NIL
    END;
    IF offScreen # NIL THEN
      Trestle.Delete(offScreen);
      VBT.Discard(offScreen)
    END;
    offScreen := NEW(VBT.Leaf);
    VAR
      dom := VBT.Domain(v);
      tso := Trestle.ScreenOf(v, Point.Origin);
      trsl := tso.trsl;
      stInstall := VBT.ScreenTypeOf(InstalledVBT.Child(v));
      st := VBT.ScreenTypeOf(v);
    &lt;* FATAL TrestleComm.Failure *&gt;
    BEGIN
      IF trsl # NIL AND st # NIL THEN
        (* Install a Filter above &quot;offScreen&quot; so that it can have a ScreenType
           that Trestle likes in the case where &quot;v&quot; has an &quot;unusual&quot; screen
           type (i.e.  there is a scale filter) *)
        WITH filter = NEW(Filter.T).init(offScreen) DO
          Trestle.Attach(filter, trsl);
          Trestle.InstallOffscreen(
            filter, dom.east - dom.west, dom.south - dom.north, stInstall);
          IF filter.st # st THEN
            (* duke it out with trestle to set the screen type and domain *)
            VBTClass.Rescreen(offScreen, st);
            VBTClass.Reshape(offScreen, filter.domain, Rect.Empty);
          END
        END
      END
    END;
    LOCK v DO
      v.offScreen := offScreen;
      v.badRect := Rect.Empty;
      v.damaged := Rect.Empty
    END
  END SetupOffScreen;

PROCEDURE <A NAME="Update"><procedure>Update</procedure></A>(v: T; wait := TRUE) =
</PRE><BLOCKQUOTE><EM> Update <CODE>v</CODE> from <CODE>offscreen(v)</CODE>, and set <CODE>badRect(v)</CODE> to the empty
   rectangle. </EM></BLOCKQUOTE><PRE>
  &lt;* LL.sup &lt; v *&gt;
  VAR badRect: Rect.T; offScreen: VBT.T; delta: Point.T; BEGIN
    LOCK v DO
      badRect := v.badRect;
      offScreen := v.offScreen;
      delta := v.delta
    END;
    IF offScreen # NIL AND badRect # Rect.Empty THEN
      VAR
        dummy: Region.T;
        pixmap := VBT.Capture(offScreen, badRect, dummy);
      BEGIN
	IF pixmap # NIL THEN
	  VBT.PaintScrnPixmap(v, src := pixmap, delta := delta);
          VBT.Sync(v, wait);
          &lt;* FATAL TrestleComm.Failure *&gt;
	  BEGIN pixmap.free() END;
          LOCK v DO v.badRect := Rect.Empty END
	END
      END
    END
  END Update;

BEGIN
END DblBufferVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
