<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/Filter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/Filter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>Filter.T</CODE> is a <CODE>Split.T</CODE> with at most one child. 

<P><PRE>INTERFACE <interface><A HREF="Filter.m3">Filter</A></interface>;

IMPORT <A HREF="Split.i3">Split</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="FilterClass.m3#T">T</A> &lt;: Public;
  Public = Split.T OBJECT METHODS
     &lt;* LL.sup &lt;= VBT.mu *&gt;
     init(ch: VBT.T): T
   END;
</PRE> The call <CODE>v.init(ch)</CODE> initializes <CODE>v</CODE> as a filter with 
   child <CODE>ch</CODE> and returns <CODE>v</CODE>. 

<P> <CODE>Split.Move</CODE> on a filter is a noop.  <CODE>Split.Insert</CODE> replaces the child, 
   if any, and detaches it. 

<P><PRE>PROCEDURE <A HREF="Filter.m3#Child">Child</A>(v: T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the child of <CODE>v</CODE>, or <CODE>NIL</CODE> if there is no child. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Filter.Child(v)</CODE> is equivalent to <CODE>Split.Succ(v, NIL)</CODE>. 

<P><PRE>PROCEDURE <A HREF="Filter.m3#Replace">Replace</A>(v: T; ch: VBT.T): VBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Replace <CODE>v</CODE>'s child by <CODE>ch</CODE>, detach and return <CODE>v</CODE>'s old child, and
   mark <CODE>v</CODE> for redisplay.  </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Filter.Replace</CODE> is similar to <CODE>Split.Replace</CODE>, except that it
   returns the old child instead of taking the old child as an argument,
   and if <CODE>ch</CODE> is <CODE>NIL</CODE> it is similar to <CODE>Split.Delete</CODE>.  

<P><PRE>END Filter.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
