<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/FilterClass.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/FilterClass.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module>FilterClass</module> EXPORTS <A HREF="FilterClass.i3"><implements>FilterClass</A></implements>;

IMPORT <A HREF="Filter.i3">Filter</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>;

REVEAL Filter.<A NAME="T">T</A> = Public BRANDED OBJECT
  OVERRIDES
    beChild := BeChild;
    succ := Succ;
    pred := Succ; (*sic*)
    nth := Nth;
    index := Index;
    locate := Locate;
    replace := Replace;
    insert := InsertAfter;
    move := NoOp;
    misc := MiscCode;
    key := KeyCode;
    read := Read;
    write := Write;
    reshape := Reshape;
    shape := Shape;
    axisOrder := AxisOrder;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(v: Filter.T; ch: VBT.T): Filter.T RAISES {} =
  BEGIN
    LOCK v DO v.ch := NIL END;
    EVAL Filter.Replace(v, ch);
    RETURN v
  END Be;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A>(v: Filter.T; &lt;*UNUSED*&gt;READONLY pt: Point.T; VAR (*out*) r: Rect.T)
  : VBT.T RAISES {} =
  BEGIN (* LL = VBT.mu *)
    r := Rect.Full;
    RETURN v.ch
  END Locate;

PROCEDURE <A NAME="BeChild"><procedure>BeChild</procedure></A>(v: Filter.T; ch: VBT.T) RAISES {} =
  BEGIN
    VBT.Split.beChild(v, ch);
    v.ch := ch
  END BeChild;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A>(v: Filter.T; ch: VBT.T): VBT.T RAISES {} =
  BEGIN
    IF ch = NIL THEN RETURN v.ch ELSE RETURN NIL END
  END Succ;

PROCEDURE <A NAME="Nth"><procedure>Nth</procedure></A>(v: Filter.T; n: CARDINAL): VBT.T RAISES {} =
  BEGIN
    IF n=0 THEN RETURN v.ch ELSE RETURN NIL END
  END Nth;

PROCEDURE <A NAME="Index"><procedure>Index</procedure></A>(v: Filter.T; ch: VBT.T): CARDINAL RAISES {} =
  BEGIN
    IF ch = v.ch THEN RETURN 0 ELSE RETURN 1 END
  END Index;

PROCEDURE <A NAME="MiscCode"><procedure>MiscCode</procedure></A>(v: Filter.T; READONLY cd: VBT.MiscRec) RAISES {} =
  BEGIN
    IF v.ch # NIL THEN VBTClass.Misc(v.ch, cd) END
  END MiscCode;

PROCEDURE <A NAME="KeyCode"><procedure>KeyCode</procedure></A>(v: Filter.T; READONLY cd: VBT.KeyRec) RAISES {} =
  BEGIN
    IF v.ch # NIL THEN VBTClass.Key(v.ch, cd) END
  END KeyCode;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: Filter.T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  BEGIN
    IF v.ch # NIL THEN VBTClass.Reshape(v.ch, cd.new, cd.saved) END
  END Reshape;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A>(v: Filter.T; ch, new: VBT.T) RAISES {} =
  BEGIN
    IF ch = NIL THEN ch := v.ch END;
    IF new # NIL THEN
      LOCK new DO LOCK v DO v.beChild(new) END END
    ELSE
      LOCK v DO v.ch := NIL END
    END;
    VBTClass.LocateChanged(v);
    IF ch # NIL THEN VBTClass.Detach(ch) END
  END Replace;

PROCEDURE <A NAME="InsertAfter"><procedure>InsertAfter</procedure></A>(v: Filter.T; ch, new: VBT.T) RAISES {} =
  BEGIN
    IF ch = NIL THEN ch := v.ch END;
    IF new # NIL THEN
      LOCK new DO LOCK v DO v.beChild(new) END END
    ELSE
      LOCK v DO v.ch := NIL END
    END;
    VBTClass.LocateChanged(v);
    IF ch # NIL THEN VBTClass.Detach(ch); VBT.Discard(ch) END
  END InsertAfter;

PROCEDURE <A NAME="NoOp"><procedure>NoOp</procedure></A>(&lt;*UNUSED*&gt; v: Filter.T; &lt;*UNUSED*&gt; pred, ch: VBT.T) RAISES {} =
  BEGIN END NoOp;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A>(v: Filter.T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  BEGIN
    IF v.ch = NIL THEN
      RETURN VBT.DefaultShape
    ELSE
      RETURN VBTClass.GetShape(v.ch, ax, n)
    END
  END Shape;

PROCEDURE <A NAME="AxisOrder"><procedure>AxisOrder</procedure></A>(v: Filter.T): Axis.T =
  BEGIN
    IF v.ch = NIL THEN
      RETURN Axis.T.Hor
      (* Split.T.axisOrder(v) *)
    ELSE
      RETURN v.ch.axisOrder()
    END
  END AxisOrder;

PROCEDURE <A NAME="Read"><procedure>Read</procedure></A>(
  v: Filter.T;
  s: VBT.Selection;
  tc: CARDINAL)
  : VBT.Value RAISES {VBT.Error}  =
  VAR owner: VBT.T; BEGIN
    LOCK v DO owner := v.ch END;
    IF owner = NIL THEN
      RAISE VBT.Error(VBT.ErrorCode.UnownedSelection)
    ELSE
      RETURN owner.read(s, tc)
    END
  END Read;

PROCEDURE <A NAME="Write"><procedure>Write</procedure></A>(
  v: Filter.T;
  s: VBT.Selection;
  val: VBT.Value;
  tc: CARDINAL)
  RAISES {VBT.Error} =
  VAR owner: VBT.T; BEGIN
    LOCK v DO owner := v.ch END;
    IF owner = NIL THEN
      RAISE VBT.Error(VBT.ErrorCode.UnownedSelection)
    ELSE
      owner.write(s, val, tc)
    END
  END Write;

BEGIN END FilterClass.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
