<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/Gray.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/Gray.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="Gray.i3">Gray</A></implements></module>;
IMPORT <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>;

TYPE
  A3 = ARRAY [0..2] OF [0..9];
CONST
  Intense3 = ARRAY [0..2] OF A3 {A3 {7, 9, 5},
                                 A3 {2, 1, 4},
                                 A3 {6, 3, 8}};

PROCEDURE <A NAME="New3x3"><procedure>New3x3</procedure></A>(intensity:[0..9]):Pixmap.T =
VAR bounds := Rect.FromSize(3, 3);
    raw := ScrnPixmap.NewRaw(1, bounds);
BEGIN
  FOR h := 0 TO 2 DO
    FOR v := 0 TO 2 DO
      IF intensity &gt;= Intense3[h, v] THEN
        raw.set(Point.FromCoords(h,v), 1);
      ELSE
        raw.set(Point.FromCoords(h,v), 0);
      END;
    END;
  END;
  RETURN Pixmap.FromBitmap(raw);
END New3x3;

TYPE
  A4 = ARRAY [0..3] OF [0..16];
CONST
  Intense4 = ARRAY [0..3] OF A4 {A4 { 1,  9,  3, 11},
                                 A4 {13,  5, 15,  7},
                                 A4 { 4, 12,  2, 10},
                                 A4 {16,  8, 14,  6}};

PROCEDURE <A NAME="New4x4"><procedure>New4x4</procedure></A>(intensity:[0..16]):Pixmap.T =
VAR bounds := Rect.FromSize(4, 4);
    raw := ScrnPixmap.NewRaw(1, bounds);
BEGIN
  FOR h := 0 TO 3 DO
    FOR v := 0 TO 3 DO
      IF intensity &gt;= Intense4[h,v] THEN
        raw.set(Point.FromCoords(h,v), 1);
      ELSE
        raw.set(Point.FromCoords(h,v), 0);
      END;
    END;
  END;
  RETURN Pixmap.FromBitmap(raw);
END New4x4;

BEGIN
END Gray.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
