<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/HVBar.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/HVBar.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> HVBar.def, by CGN and MSM, Tue Sep 30 17:24:31 1986 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> An <CODE>HVBar.T</CODE> is an adjustable bar that allows a user to
   adjust the division of space between the children of an <CODE>HVSplit</CODE>.
<P>
   An <CODE>HVBar</CODE> must be a child of an <CODE>HVSplit</CODE>.  When the user pushes
   a mouse button over the bar, the cursor changes shape and the outline
   of the bar is highlighted.  The highlight follows the cursor as long
   as the button is down.  When the button comes up, the bar calls
   <CODE>HVSplit.Adjust</CODE> to move the bar to the currently highlighted
   position.  If the user tries to move the bar outside the range of
   positions that are consistent with the size constraints of the
   children of the parent <CODE>HVSplit</CODE>, the highlighted bar will not
   follow the cursor.  If the user chords while dragging, then adjusting 
   mode is cancelled.
<P>
   The bar has methods that you can override that are called each
   time the bar is moved, or continuously during adjustment.
<P>
   In order for the bar to highlight correctly, some ancestor of the
   <CODE>HVSplit</CODE> on which it is installed must be a <CODE>HighlightVBT</CODE>. 
   Since <CODE>Trestle.Install</CODE> automatically inserts a <CODE>HighlightVBT</CODE>
   over top-level windows, you usually don't have to worry about this.
   

<P><PRE>INTERFACE <interface><A HREF="HVBar.m3">HVBar</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="TextureVBT.i3">TextureVBT</A>;

TYPE
  <A HREF="HVBar.m3#T">T</A> &lt;: Public;
  Public = TextureVBT.T OBJECT METHODS
    &lt;* LL = VBT.mu *&gt;
    pre(READONLY cd: VBT.MouseRec);
    post(READONLY cd: VBT.MouseRec);
    during(n: INTEGER);
    &lt;* LL &lt;= VBT.mu *&gt;
    init(size: REAL := DefaultSize;
      op: PaintOp.T := PaintOp.BgFg;
      txt: Pixmap.T := Pixmap.Gray): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as an <CODE>HVBar</CODE> with
   the given properties and returns <CODE>v</CODE>.  This includes
   calling  <CODE>TextureVBT.T.init(v, op, txt)</CODE>.
    <P>
   The argument <CODE>size</CODE> gives the number of millimeters that the bar
   will occupy in the parent <CODE>HVSplit</CODE>.  
<P>
   An adjusting bar <CODE>b</CODE> calls <CODE>b.pre(cd)</CODE> when it begins adjusting
   in response to a mouse click <CODE>cd</CODE>.  It calls <CODE>b.during(k)</CODE> each
   time the mouse moves during dragging, where <CODE>k</CODE> is the coordinate that 
   the <CODE>lo</CODE> (i.e., west or north) edge of the bar would move to if 
   dragging were stopped at that instant.  Finally, the bar calls
   <CODE>b.post(cd)</CODE> when it stops adjusting in response to an upclick
   or chord <CODE>cd</CODE>.  The <CODE>HVSplit</CODE> will be adjusted (but not redisplayed)
   before <CODE>b.post(cd)</CODE> is called. 
<P>
   The default <CODE>pre</CODE> and <CODE>during</CODE> methods highlight the position the
   bar would move to if dragging were stopped.  The default <CODE>post</CODE> 
   method removes the highlighting.  

<P><PRE>CONST
  DefaultSize = 2.5;

PROCEDURE <A HREF="HVBar.m3#New">New</A>(
    size := DefaultSize;
    op := PaintOp.BgFg;
    txt := Pixmap.Gray): T; &lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

END HVBar.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
