<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/HVBar.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/HVBar.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="HVBar.i3">HVBar</A></implements></module>;

IMPORT <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../vbt/Cursor.i3">Cursor</A>, <A HREF="HighlightVBT.i3">HighlightVBT</A>, <A HREF="HVSplit.i3">HVSplit</A>, <A HREF="../../../geometry/src/Interval.i3">Interval</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>,
  <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="Split.i3">Split</A>, <A HREF="TextureVBT.i3">TextureVBT</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
     highlighter: HighlightVBT.T := NIL;
     sizeMM: REAL;
     adjusting := FALSE;
     range: Interval.T;
     offset: INTEGER;
     (* The distance from the top (or left) of the barOutline to the cursor
         position *)
     barOutline: Rect.T;
  OVERRIDES
    pre := PreDefault;
    post := PostDefault;
    during := DuringDefault;
    position := Position;
    mouse := Mouse;
    shape := Shape;
    reshape := Reshape;
    init := Be
  END;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; READONLY cd: VBT.ReshapeRec) =
  VAR
    hv := HVSplit.AxisOf(VBT.Parent(v));
  BEGIN
    TextureVBT.T.reshape(v, cd);
    VBT.SetCursor(v, cursors[hv])
  END Reshape;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(
  v: T;
  size: REAL;
  op: PaintOp.T;
  src: Pixmap.T): T RAISES {} =
  BEGIN
    EVAL TextureVBT.T.init(v, op, src);
    v.sizeMM := size;
    VBT.SetCursor(v, Cursor.TextPointer);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
    size: REAL;
    op: PaintOp.T := PaintOp.BgFg;
    texture: Pixmap.T := Pixmap.Gray)
    : T =
  BEGIN
    RETURN Be(NEW(T), size, op, texture)
  END New;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A>(v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange RAISES {} =
  VAR
    hv: Axis.T;
    sr: VBT.SizeRange;
  BEGIN
    hv := HVSplit.AxisOf(VBT.Parent(v));
    IF hv = ax THEN
      sr.lo := ROUND(VBT.MMToPixels(v, v.sizeMM, hv));
      sr.pref := sr.lo;
      sr.hi := sr.lo + 1;
      RETURN sr
    ELSE
      RETURN VBT.Leaf.shape(v, ax, n)
    END
  END Shape;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) =
  &lt;*FATAL Split.NotAChild*&gt;
  VAR
    parent: HVSplit.T := VBT.Parent(v);
    hv := HVSplit.AxisOf(parent);
    dom := VBT.Domain(v);
    pdom := VBT.Domain(parent);
    adjust:    BOOLEAN;
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      v.adjusting := TRUE;
      IF hv = Axis.T.Hor THEN
        v.range := Interval.Move(
          HVSplit.FeasibleRange(parent, Split.Pred(parent, v)), pdom.west);
        IF Interval.IsEmpty(v.range) THEN
          v.range := Interval.FromBound(dom.west, 1)
        END;
        v.offset := cd.cp.pt.h - dom.west;
      ELSE
        v.range := Interval.Move(
          HVSplit.FeasibleRange(parent, Split.Pred(parent, v)), pdom.north);
        IF Interval.IsEmpty(v.range) THEN
          v.range := Interval.FromBound(dom.north, 1)
        END;
        v.offset := cd.cp.pt.v - dom.north;
      END;
      v.barOutline := dom;
      v.pre(cd);
      Position2(v, cd.cp)
    ELSE
      IF v.adjusting THEN
        v.adjusting := FALSE;
        adjust := (cd.clickType = VBT.ClickType.LastUp) AND
          NOT Rect.Equal(v.barOutline, dom);
        IF adjust THEN
          IF hv = Axis.T.Hor THEN
            HVSplit.Adjust(parent, v, v.barOutline.east - pdom.west)
          ELSE
            HVSplit.Adjust(parent, v, v.barOutline.south - pdom.north)
          END
        END;
        v.post(cd)
      END
    END
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A>(v: T; READONLY cd: VBT.PositionRec) RAISES {} =
  BEGIN Position2(v, cd.cp)  END Position;

PROCEDURE <A NAME="Position2"><procedure>Position2</procedure></A>(v: T; READONLY cp: VBT.CursorPosition) =
  VAR
    parent: HVSplit.T := VBT.Parent(v);
    lo: INTEGER;
  BEGIN
    IF v.adjusting AND NOT cp.offScreen THEN
      IF HVSplit.AxisOf(parent) = Axis.T.Hor THEN
        lo := MAX(MIN(cp.pt.h - v.offset, v.range.hi - 1), v.range.lo);
        v.barOutline := Rect.MoveH(v.barOutline, lo - v.barOutline.west);
        v.during(v.barOutline.west)
      ELSE
        lo := MAX(MIN(cp.pt.v - v.offset, v.range.hi - 1), v.range.lo);
        v.barOutline := Rect.MoveV(v.barOutline, lo - v.barOutline.north);
        v.during(v.barOutline.north)
      END
    END;
    IF v.adjusting THEN
      VBT.SetCage(v, VBT.CageFromPosition(cp, trackOutside := TRUE))
    ELSE
      VBT.SetCage(v, VBT.EverywhereCage)
    END
  END Position2;

PROCEDURE <A NAME="PreDefault"><procedure>PreDefault</procedure></A>(v: T; &lt;*UNUSED*&gt; READONLY cd: VBT.MouseRec) RAISES {} =
  BEGIN
    v.highlighter := HighlightVBT.Find(v);
    HighlightVBT.SetTexture(v.highlighter, Pixmap.Gray, Point.T{0,1})
  END PreDefault;

PROCEDURE <A NAME="PostDefault"><procedure>PostDefault</procedure></A>(v: T; &lt;*UNUSED*&gt; READONLY cd: VBT.MouseRec) RAISES {} =
  BEGIN
    HighlightVBT.SetRect(v.highlighter, Rect.Empty, 0);
    v.highlighter := NIL
  END PostDefault;

CONST BorderThickness = 2;

PROCEDURE <A NAME="DuringDefault"><procedure>DuringDefault</procedure></A>(v: T; &lt;*UNUSED*&gt; lo: INTEGER) RAISES {} =
  BEGIN
    HighlightVBT.SetRect(v.highlighter, Rect.Meet(VBT.Domain(VBT.Parent(v)),
      Rect.Inset(v.barOutline, -BorderThickness)), BorderThickness)
  END DuringDefault;

VAR cursors: ARRAY Axis.T OF Cursor.T;

BEGIN
  cursors[Axis.T.Hor] :=
    Cursor.FromName(ARRAY OF TEXT {&quot;XC_sb_h_double_arrow&quot;});
  cursors[Axis.T.Ver] :=
    Cursor.FromName(ARRAY OF TEXT {&quot;XC_sb_v_double_arrow&quot;})
END HVBar.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
