<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/HVSplit.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/HVSplit.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File HVSplit.i3 coded by MSM and CGN, Mon Nov 18 21:52:15 1985 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> An <CODE>HVSplit.T</CODE> is a parent window that splits its screen into a
   row or column of child windows, depending on the {\it axis} of
   the split.
<P>
   If the axis is horizontal, <CODE>Split.Succ</CODE> enumerates the children 
   from west to east; if the axis is vertical, it enumerates them 
   from north to south.
<P>
   An <CODE>HVSplit</CODE> can be {\it adjustable} or {\it unadjustable}, a 
   property that affects the way its space is divided between its children.    
<P>
   The {\it size} of a child is the extent of its domain in the 
   axis of split, the {\it cross-size} is its extent in the other axis.  
   For example, for a vertical split, a child's size is its height 
   and its cross-size is its width.
<P>
   The children of an <CODE>HVSplit</CODE> all have the same cross-size as the
   parent.  To determine the sizes of the children, the <CODE>HVSplit</CODE> begins
   by computing the range of desirable sizes and the preferred size
   for each child by calling its shape method, passing the method the
   cross-size, so that, for example, the height of a child of a vertical
   split can depend on its width.  At this point there are several cases.
<P>
   If the sum of the minimum sizes of the children is greater than the
   size of the parent, then the split is said to be {\it overfull}.
   In this case the children are considered in order and given their
   minimum sizes, as long as there is room.  The first child that
   doesn't fit is given all the space that's left, and the remaining
   children are given size zero.
<P>
   If the split is not overfull, then the children are stretched
   according to the TeX model of boxes and glue.  The details depend
   on whether the split is adjustable or unadjustable.  For an
   adjustable split, each child's {\it stretchability} is its maximum
   desirable size minus its current size, and its {\it shrinkability}
   is its current size minus its minimum desirable size.  If the size
   of the parent is increased by some amount <CODE>X</CODE>, then the sizes of
   the children are increased by amounts that total to <CODE>X</CODE> and are
   proportional to the children's stretchabilities.  Similarly, if the
   size of the parent is decreased by some amount <CODE>X</CODE>, then the sizes
   of the children are decreased by amounts that total to <CODE>X</CODE> and are
   proportional to the children's shrinkabilities.
<P>
   For a non-adjustable split, all the children's sizes are first set
   to their preferred sizes, and then they are stretched or shrunk the
   same as an adjustable split.  Thus for a non-adjustable split each
   redistribution of space depends only on the children's shape methods,
   not on their current sizes.
<P>
   A non-adjustable split is best if the layout can be controlled purely
   by stretchability and shrinkability.  If the layout is also changed
   under user or program control, an adjustable split is required.  For
   example, in a column of editable text windows, you should make the
   vertical split adjustable, since if the user makes one window big,
   and then the parent changes size slightly, you do not want the big
   window child to snap back to being small.  On the other hand if you
   are using a horizontal split to center a <CODE>ButtonVBT</CODE> between two
   stretchy <CODE>TextureVBTs</CODE>, you should make it unadjustable, since in
   this case you always want to compute the division of space from the
   children's original shapes.
<P>
   If the sum of the maximum sizes of the children is less than the
   size of the parent, the split is said to be {\it underfull}.  There
   are no special rules for the underfull case: the TeX stretching
   algorithm is used without change.  This produces a state in which
   the children are stretched larger than their maximum sizes.
<P>
   A split is {\it infeasible} if it is overfull or underfull, and {\it
   feasible} otherwise.
    <P>
   The shape of an <CODE>HVSplit</CODE> is computed as follows: its maximum,
   minimum, and preferred sizes are obtained by adding up the
   corresponding values of its children.  The cross-size range is the
   intersection of the cross-size ranges of its children (if this
   intersection is empty, the children's maximum cross-sizes are
   increased until the intersection is non-empty).  The preferred
   cross-size of <CODE>v</CODE> is the maximum of the preferred cross-sizes
   of its children, projected into <CODE>v</CODE>'s cross-size range.  

<P>   
<P><PRE>INTERFACE <interface><A HREF="HVSplit.m3">HVSplit</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="Split.i3">Split</A>, <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../../geometry/src/Interval.i3">Interval</A>;

TYPE
  <A HREF="HVSplit.m3#T">T</A> &lt;: Public;
  <A HREF="HVSplit.m3#Private">Private</A> &lt;: Split.T;
  Public = Private OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(hv: Axis.T;
      saveBits := FALSE;
      parlim := -1;
      adjustable := TRUE): T
  END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as an <CODE>HVSplit</CODE> with axis 
   <CODE>hv</CODE> and no children.
<P>
   If <CODE>saveBits</CODE> is <CODE>TRUE</CODE>, the implementation will try to save the
   children's old bits when reshaping; if the children don't use them
   anyway, it is faster to let <CODE>saveBits</CODE> default to <CODE>FALSE</CODE>.  The value of
   <CODE>parlim</CODE> is the minimum area of a child for which a separate thread
   will be forked to <CODE>reshape</CODE> or <CODE>repaint</CODE>; if it is <CODE>-1</CODE>, it is set
   to an appropriate default (see the <CODE>VBTTuning</CODE> interface).  

<P>
<P><PRE>PROCEDURE <A HREF="HVSplit.m3#New">New</A>(
    hv: Axis.T;
    saveBits := FALSE;
    parlim := -1;
    adjustable := TRUE): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HVSplit.m3#AxisOf">AxisOf</A>(v: T): Axis.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the axis of <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Inserting children} 

<P> See the <CODE>Split</CODE> interface to insert and reorder children.  

<P><PRE>PROCEDURE <A HREF="HVSplit.m3#Cons">Cons</A>(
    hv: Axis.T;
    ch0, ch1, ch2, ch3, ch4,
      ch5, ch6, ch7, ch8, ch9: VBT.T := NIL;
    saveBits := FALSE;
    parlim := -1;
    adjustable := TRUE): T; &lt;* LL.sup = VBT.mu *&gt;
 (* Create an &quot;HVSplit&quot; with axis &quot;hv&quot; and children &quot;ch0&quot;, &quot;ch1&quot;, .... *)
</PRE> <CODE>Cons</CODE> is equivalent to the following:
<P>
<PRE>
      result := New(hv, saveBits, parlim, adjustable);
      Split.AddChild(result, ch0, ch1, ..., ch9);
      RETURN result
</PRE>


<P>
<P><PRE>PROCEDURE <A HREF="HVSplit.m3#ConsArray">ConsArray</A>(
    hv: Axis.T;
    READONLY ch: ARRAY OF VBT.T;
    saveBits := FALSE;
    parlim := -1;
    adjustable := TRUE): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Create an <CODE>HVSplit</CODE> with axis <CODE>hv</CODE> and children <CODE>ch[0]</CODE>, <CODE>ch[1]</CODE>, .... </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>ConsArray</CODE> ignores any <CODE>NILs</CODE> in the array <CODE>ch</CODE>.  It is equivalent to:
<P>
<PRE>
      VAR result := New(hv, saveBits, parlim, adjustable);
      BEGIN
        Split.AddChildArray(result, ch);
        RETURN result
      END
</PRE>
  

<P> \subsubsection{Adjusting the division of space} 

<P> The {\it division point after a child} is the sum of the sizes of
   all children up to and including the child. 
   
<P>
<P><PRE>PROCEDURE <A HREF="HVSplit.m3#Adjust">Adjust</A>(v: T; ch: VBT.T; totsz: INTEGER)
RAISES {Split.NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the sizes of the children of <CODE>v</CODE> so that the division point
   after <CODE>ch</CODE> is as close to <CODE>totsz</CODE> as possible, and mark <CODE>v</CODE> for
   redisplay. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Adjust</CODE> respects the size constraints on the children, and resizes
   children near the division point in preference to children far from
   the division point.  For example, a sufficiently small adjustment
   will be made by resizing only <CODE>ch</CODE> and its successor.  An adjustment
   large enough to make one of these children reach its max or min size
   will also resize the neighbor of that child, and so forth.
<P>
   <CODE>Adjust</CODE> is a no-op if the split is infeasible or non-adjustable. 

<P>
<P><PRE>PROCEDURE <A HREF="HVSplit.m3#FeasibleRange">FeasibleRange</A>(v: T; ch: VBT.T): Interval.T
RAISES {Split.NotAChild}; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the interval of feasible positions for the division point
   after <CODE>ch</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HVSplit.m3#AvailSize">AvailSize</A>(v: T): CARDINAL;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the largest size of a child that can be inserted into <CODE>v</CODE>
   without making <CODE>v</CODE> infeasible. </EM></BLOCKQUOTE><PRE>
</PRE> If the split is infeasible, <CODE>AvailSize</CODE> returns 0 and <CODE>FeasibleRange</CODE> 
   returns the empty interval.  Both procedures assume the 
   total size available is the total of all child sizes. 

<P>
<P><PRE>END HVSplit.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
