<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/HighlightVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/HighlightVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> File: HighlightVBT.i3, by cgn, Tue Apr 21 22:00:25 1987 
<PRE>&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>HighlightVBT.T</CODE> is a filter that highlights a rectangular outline
   over its child.
<P>
   The parent screen is obtained from the child screen by
   texturing an outline inset in a rectangle, using an inverting
   painting operation.
    <P>
   The parent keeps its screen correct as the child paints.  Since the
   parent screen is always correct, it never needs to mark itself
   for redisplay.  

<P><PRE>INTERFACE <interface><A HREF="HighlightVBT.m3">HighlightVBT</A></interface>;

IMPORT <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>;

TYPE
  <A HREF="HighlightVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT METHODS
    &lt;* LL.sup &lt;= VBT.mu *&gt;
    init(ch: VBT.T;
      op: PaintOp.T := PaintOp.TransparentSwap;
      txt: Pixmap.T := Pixmap.Gray;
      READONLY delta := Point.T{h := 0, v := 1}): T
  END;
</PRE> The call <CODE>v.init(ch, ...)</CODE> initializes <CODE>v</CODE> as a <CODE>HighlightVBT</CODE> with 
   child <CODE>ch</CODE> and the given parameters, and returns <CODE>v</CODE>.
<P>
   The highlight rectangle is initially empty.  The filter brings up 
   the highlight by calling 
   <P>
<PRE>
      VBT.PaintTexture(v, <KBD>highlight region</KBD>, op, txt, delta)
</PRE>
   and brings down the highlight the same way; therefore the painting 
   operation must be its own inverse for the filter to work correctly.
   <P>
   The default values for the texture and delta are such that the
   highlight will be visible over white, black, or the standard gray
   texture.  (If delta were <CODE>(0,0)</CODE> instead of <CODE>(0,1)</CODE>, the highlight
   would look fine over white or black but would be barely noticeable
   over standard gray.)  

<P><PRE>PROCEDURE <A HREF="HighlightVBT.m3#New">New</A>(
  ch: VBT.T;
  op := PaintOp.TransparentSwap;
  txt: Pixmap.T := Pixmap.Gray;
  READONLY delta := Point.T{h := 0, v := 1}) : T ;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HighlightVBT.m3#Find">Find</A>(v: VBT.T): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the lowest (possibly improper) ancestor of <CODE>v</CODE> that is a
   <CODE>HighlightVBT.T</CODE> or <CODE>NIL</CODE> if there isn't one. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HighlightVBT.m3#SetRect">SetRect</A>(
  v: VBT.T;
  READONLY rect: Rect.T;
  inset: CARDINAL := 2);
 &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the rectangle and inset of <CODE>Find(v)</CODE> to the given values. </EM></BLOCKQUOTE><PRE>
</PRE> The inset is given in pixels, not in millimeters. 

<P><PRE>PROCEDURE <A HREF="HighlightVBT.m3#SetTexture">SetTexture</A>(
  v: VBT.T;
  txt: Pixmap.T;
  READONLY delta := Point.Origin;
  op := PaintOp.TransparentSwap);
 &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the <CODE>txt</CODE>, <CODE>delta</CODE>, and <CODE>op</CODE> of <CODE>Find(v)</CODE> to the given 
   values.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HighlightVBT.m3#Get">Get</A>(
  v: VBT.T;
  VAR rect: Rect.T;
  VAR inset: CARDINAL;
  VAR txt: Pixmap.T;
  VAR delta: Point.T;
  VAR op: PaintOp.T): BOOLEAN; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Fetch the parameters for the <CODE>HighlightVBT</CODE> above <CODE>v</CODE>, and return <CODE>TRUE</CODE>.
   If <CODE>v</CODE> has no such ancestor, return <CODE>FALSE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="HighlightVBT.m3#Invert">Invert</A>(v: VBT.T;
  READONLY r: Rect.T;
  inset: CARDINAL); &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM>  Highlight the outline inset into the rectangle <CODE>r</CODE> with width
    <CODE>inset</CODE>, using a solid texture. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>Invert</CODE> operates on <CODE>Find(v)</CODE>.  It is equivalent to:
<P>
  <PRE>
      SetTexture(v, Pixmap.Solid);
        SetRect(v, r, inset)


<P> <CODE></PRE>
SetRect</CODE>, <CODE>SetTexture</CODE>, and <CODE>Invert</CODE> are no-ops if <CODE>Find(v)</CODE> is <CODE>NIL</CODE>. 

<P><PRE>END HighlightVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
