<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/HighlightVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/HighlightVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman, Mark Manasse and Greg Nelson           
<PRE>&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="HighlightVBT.i3">HighlightVBT</A></implements></module>;

IMPORT <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../vbt/BatchRep.i3">BatchRep</A>, <A HREF="FilterClass.i3">FilterClass</A>,
  <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../../geometry/src/Point.i3">Point</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>,
  <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="Filter.i3">Filter</A>;

REVEAL <A NAME="T">T</A> = Public BRANDED OBJECT
    txt: Pixmap.T;
    op: PaintOp.T;
    delta: Point.T;
    rect: Rect.T;
    border: CARDINAL
  OVERRIDES
    reshape := Reshape;
    capture := Capture;
    paintbatch := PaintBatch;
    init := Be
  END;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A>(
  v: T;
  ch: VBT.T;
  op: PaintOp.T := PaintOp.TransparentSwap;
  texture: Pixmap.T := Pixmap.Gray;
  READONLY offset: Point.T): T =
  BEGIN
    v.op := op;
    v.txt := texture;
    v.delta := offset;
    v.rect := Rect.Empty;
    v.border := 0;
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(
  ch: VBT.T;
  op: PaintOp.T := PaintOp.TransparentSwap;
  texture: Pixmap.T := Pixmap.Gray;
  READONLY delta:Point.T): T =
  BEGIN
    RETURN Be(NEW(T), ch, op, texture, delta)
  END New;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A>(v: T; READONLY cd: VBT.ReshapeRec) RAISES {} =
  VAR cdP := cd;
  BEGIN
    IF NOT Rect.Subset(Rect.Meet(v.rect, cd.saved), cd.new) THEN
      (* Can't allow scrolling of saved into new, since the saved pixels
         might be highlighted, and we can't unhighlight them without
         generating bad rectangles, so: *)
      cdP.saved := Rect.Meet(cd.new, cd.saved)
    END;
    Filter.T.reshape(v, cdP)
  END Reshape;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A>(
    self: T;
    &lt;*UNUSED*&gt; ch: VBT.T;
    READONLY rect: Rect.T;
    VAR (* OUT *) br: Region.T)
    : ScrnPixmap.T
  RAISES {} =
  VAR res: ScrnPixmap.T;
  BEGIN
    InvertHighlight(self, rect);
    res := VBT.Capture(self, rect, br);
    InvertHighlight(self, rect);
    RETURN res;
  END Capture;

PROCEDURE <A NAME="InvertHighlight"><procedure>InvertHighlight</procedure></A>(v: T; READONLY clip: Rect.T) =
  (* Invert all highlighted bits contained in clip.  LL = v.ch *)
  VAR a: Rect.Partition;
      rect := Rect.Meet(v.rect, clip);
      inset := Rect.Inset(v.rect, v.border);
  BEGIN
    IF Rect.Subset(rect, inset) THEN RETURN END;
    Rect.Factor(rect, inset, a, 0, 0);
    a[2] := a[4];
    VBT.PolyTexture(v, SUBARRAY(a, 0, 4), v.op, v.txt, v.delta)
  END InvertHighlight;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A>(v: T; &lt;*UNUSED*&gt; ch: VBT.T; ba: Batch.T) RAISES {} =
  BEGIN
    IF Rect.IsEmpty(v.rect)
       OR Rect.IsEmpty(ba.scrollSource) AND NOT Rect.Overlap(v.rect, ba.clip)
    THEN
      VBTClass.PaintBatch(v, ba)
    ELSE
      VAR
        rect: Rect.T;
        inset := Rect.Inset(v.rect, v.border);
        a: Rect.Partition;
      BEGIN
        BatchUtil.Tighten(ba);
        rect := Rect.Meet(v.rect, Rect.Join(ba.clip, ba.scrollSource));
        IF Rect.Subset(rect, inset) THEN
          VBTClass.PaintBatch(v, ba)
        ELSE
          Rect.Factor(rect, inset, a, 0, 0);
          a[2] := a[4];
          VBT.PolyTexture(v, SUBARRAY(a, 0, 4), v.op, v.txt, v.delta);
          VBTClass.PaintBatch(v, ba);
          VBT.PolyTexture(v, SUBARRAY(a, 0, 4), v.op, v.txt, v.delta)
        END
      END
    END
  END PaintBatch;

PROCEDURE <A NAME="SetTexture"><procedure>SetTexture</procedure></A>(
  w: VBT.T;
  txt: Pixmap.T;
  READONLY delta := Point.Origin;
  op := PaintOp.TransparentSwap) =
  VAR v := Find(w); BEGIN
    IF v = NIL OR (v.txt = txt) AND Point.Equal(v.delta, delta)
    AND op = v.op THEN
      RETURN
    ELSIF v.ch = NIL THEN
      v.txt := txt;
      v.delta := delta;
      v.op := op
    ELSE
      LOCK v.ch DO
        InvertHighlight(v, Rect.Full);
        v.txt := txt;
        v.delta := delta;
        v.op := op;
        InvertHighlight(v, Rect.Full)
      END
    END
  END SetTexture;

PROCEDURE <A NAME="SetRect"><procedure>SetRect</procedure></A>(w: VBT.T; READONLY r: Rect.T; border: CARDINAL) =
  VAR v := Find(w); BEGIN
    IF v = NIL OR Rect.Equal(v.rect, r) AND v.border = border THEN
      RETURN
    ELSIF v.ch = NIL THEN
      v.rect := r;
      v.border := border
    ELSE
      InnerSetRect(v, r, border)
    END
  END SetRect;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(
  v: VBT.T;
  VAR rect: Rect.T;
  VAR inset: CARDINAL;
  VAR txt: Pixmap.T;
  VAR delta: Point.T;
  VAR op: PaintOp.T): BOOLEAN =
  VAR w := Find(v); BEGIN
    IF w = NIL THEN RETURN FALSE END;
    rect := w.rect;
    inset := w.border;
    txt := w.txt;
    delta := w.delta;
    op := w.op;
    RETURN TRUE
  END Get;

PROCEDURE <A NAME="Find"><procedure>Find</procedure></A>(v: VBT.T): T =
  BEGIN
    LOOP
      TYPECASE v OF
        T(v) =&gt; RETURN v
      ELSE v := v.parent
      END
    END
  END Find;

PROCEDURE <A NAME="InnerSetRect"><procedure>InnerSetRect</procedure></A>(v: T; READONLY r: Rect.T; bd: CARDINAL) =
  VAR
    oldb, newb: Rect.Partition;

  PROCEDURE PaintDiff(READONLY r1, r2: Rect.T) =
    (* Add the nonempty rectangles in the difference of r1 and r2 to the
       batch. *)
    VAR a: Rect.Partition;
    BEGIN
      IF Rect.Subset(r1, r2) THEN RETURN END;
      Rect.Factor(r1, r2, a, 0, 0);
      a[2] := a[4];
      VBT.PolyTexture(v, SUBARRAY(a, 0, 4), v.op, v.txt, v.delta)
    END PaintDiff;

  BEGIN
    LOCK v.ch DO
      Rect.Factor(Rect.Meet(v.rect, v.domain),
        Rect.Inset(v.rect, v.border), oldb, 1, 1);
      v.border := bd;
      IF bd = 0 THEN v.rect := Rect.Empty ELSE v.rect := r END;
      Rect.Factor(Rect.Meet(v.rect, v.domain),
        Rect.Inset(v.rect, v.border), newb, 1, 1);
      FOR i := 0 TO 4 DO
        IF (i # 2) THEN
          (* paint symmetric difference of edge i *)
          PaintDiff(newb[i], oldb[i]);
          PaintDiff(oldb[i], newb[i]);
        END
      END
    END
  END InnerSetRect;

PROCEDURE <A NAME="Invert"><procedure>Invert</procedure></A>(v: VBT.T; READONLY r: Rect.T; border: CARDINAL) =
  VAR h := Find(v); BEGIN
    SetTexture(h, Pixmap.Solid, Point.Origin);
    SetRect(h, r, border)
  END Invert;

BEGIN END HighlightVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
