<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinCMap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinCMap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="JoinCMap.i3">JoinCMap</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnColorMap.i3">ScrnColorMap</A>, <A HREF="JoinScreen.i3">JoinScreen</A>;

REVEAL
  <A NAME="Oracle">Oracle</A> = ScrnColorMap.Oracle BRANDED OBJECT
    st: JoinScreen.T;
  OVERRIDES
    standard := ColorMapDefault;
    new := ColorMapNew;
    list := ColorMapList;
    lookup := ColorMapLookup
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE <A NAME="ColorMapNew"><procedure>ColorMapNew</procedure></A> (&lt;* UNUSED *&gt; orc      : Oracle;
                       &lt;* UNUSED *&gt; nm       : TEXT := NIL;
                       &lt;* UNUSED *&gt; preLoaded       := TRUE ): ScrnColorMap.T =
  BEGIN
    Crash(); &lt;*ASSERT FALSE*&gt;
    (* IF orc.st.sts = NIL THEN Crash(); END; RETURN
       orc.st.sts[0].cmap.new(nm, preLoaded); *)
  END ColorMapNew;

PROCEDURE <A NAME="ColorMapDefault"><procedure>ColorMapDefault</procedure></A> (&lt;* UNUSED *&gt; orc: Oracle): ScrnColorMap.T
  RAISES {} =
  BEGIN
    Crash(); &lt;*ASSERT FALSE*&gt;
    (* IF orc.st.sts = NIL THEN Crash(); END; RETURN
       orc.st.sts[0].cmap.standard(); *)
  END ColorMapDefault;

PROCEDURE <A NAME="ColorMapList"><procedure>ColorMapList</procedure></A> (&lt;* UNUSED *&gt; orc       : Oracle;
                        &lt;* UNUSED *&gt; pat       : TEXT;
                        &lt;* UNUSED *&gt; maxResults: CARDINAL):
  REF ARRAY OF TEXT RAISES {} =
  BEGIN
    Crash(); &lt;*ASSERT FALSE*&gt;
    (* IF orc.st.sts = NIL THEN Crash(); END; RETURN
       orc.st.sts[0].cmap.list(pat, maxResults); *)
  END ColorMapList;

PROCEDURE <A NAME="ColorMapLookup"><procedure>ColorMapLookup</procedure></A> (&lt;* UNUSED *&gt; orc: Oracle; &lt;* UNUSED *&gt; pat: TEXT):
  ScrnColorMap.T RAISES {} =
  BEGIN
    Crash(); &lt;*ASSERT FALSE*&gt;
    (* IF orc.st.sts = NIL THEN Crash(); END; RETURN
       orc.st.sts[0].cmap.lookup(pat); *)
  END ColorMapLookup;

EXCEPTION FatalError;

PROCEDURE <A NAME="Crash"><procedure>Crash</procedure></A> () =
  &lt;*FATAL FatalError*&gt;
  BEGIN
    RAISE FatalError
  END Crash;

BEGIN
END JoinCMap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
