<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinCursor.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinCursor.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="JoinCursor.i3">JoinCursor</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnCursor.i3">ScrnCursor</A>, <A HREF="JoinScreen.i3">JoinScreen</A>, <A HREF="../vbt/Cursor.i3">Cursor</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/PlttFrnds.i3">PlttFrnds</A>,<A HREF="../vbt/VBTRep.i3">VBTRep</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (st: JoinScreen.T; cs: Cursor.T) =
  VAR i: INTEGER; t := st.succ(NIL, i);
  BEGIN
    WHILE t # NIL DO EVAL Palette.ResolveCursor(t, cs); t := st.succ(t, i) END
  END Resolve;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (           st: JoinScreen.T;
                 &lt;*UNUSED*&gt; cl: Palette.CursorClosure;
                            cs: Cursor.T               ): ScrnCursor.T =
  VAR res := st.cursors[cs.cs];
  BEGIN
    Resolve(st, cs);
    IF res # NIL AND res # PlttFrnds.noCursor THEN RETURN res END;
    RETURN NEW(T, id := 2 * cs.cs + 1, st := st);
  END Apply;

REVEAL
  <A NAME="Oracle">Oracle</A> = ScrnCursor.Oracle BRANDED OBJECT
             st: JoinScreen.T;
           (*
           OVERRIDES
             load    := Register;
             list    := List;
             lookup  := Lookup;
             builtIn := BuiltIn
           *)
           END;

TYPE
  T = ScrnCursor.T OBJECT
        st: JoinScreen.T;
      (*
      OVERRIDES
        localize := Localize;
        unload   := Unload
      *)
      END;
</PRE><P>
TYPE
  Registered = T OBJECT
                 raw: ScrnCursor.Raw
               OVERRIDES
                 localize := RegisteredLocalize
               END;
<P>
  Lookedup = T OBJECT name: TEXT END;
<P>
  Builtin = T OBJECT cs: Cursor.Predefined END;


<P>
PROCEDURE Localize (cs: T): ScrnCursor.Raw
  RAISES {TrestleComm.Failure, ScrnCursor.Failure} =
  BEGIN
    IF cs.buddy = NIL THEN RAISE ScrnCursor.Failure END;
    RETURN cs.buddy.localize()
  END Localize;


<P>  
PROCEDURE Register (         orc: Oracle;
                    READONLY c  : ScrnCursor.Raw;
                             nm : TEXT             := NIL): ScrnCursor.T
  RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].cursor.load(c, nm);
  END Register;


<P>
PROCEDURE List (orc: Oracle; pat: TEXT; maxResults: CARDINAL := 1):
  REF ARRAY OF TEXT RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].cursor.list(pat, maxResults);
  END List;


<P>
PROCEDURE Lookup (orc: Oracle; name: TEXT): ScrnCursor.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].cursor.lookup(name);
  END Lookup;


<P>
PROCEDURE BuiltIn (orc: Oracle; cs: Cursor.Predefined): ScrnCursor.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    IF orc.st.sts[0].cursors[cs] = PlttFrnds.noCursor THEN
      EVAL Palette.ResolveCursor(orc.st.sts[0], Cursor.T{cs});
    END;                        (* if 
    <PRE>RETURN orc.st.sts[0].cursors[cs];
  END BuiltIn;
*)
</PRE><P>
EXCEPTION FatalError;
<P>
PROCEDURE Crash () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;


<P><PRE>BEGIN END JoinCursor.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
