<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinFont.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinFont.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="JoinFont.i3">JoinFont</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnFont.i3">ScrnFont</A>, <A HREF="JoinScreen.i3">JoinScreen</A>, <A HREF="../vbt/Font.i3">Font</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/PlttFrnds.i3">PlttFrnds</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (st: JoinScreen.T; fnt: Font.T) =
  VAR i: INTEGER; t := st.succ(NIL, i);
  BEGIN
    WHILE t # NIL DO EVAL Palette.ResolveFont(t, fnt); t := st.succ(t, i) END
  END Resolve;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (           st : JoinScreen.T;
                 &lt;*UNUSED*&gt; cl : Palette.FontClosure;
                            fnt: Font.T               ): ScrnFont.T =
  VAR res := st.fonts[fnt.fnt];
  BEGIN
    Resolve(st, fnt);
    IF res = NIL OR res = PlttFrnds.noFont THEN
      res := NEW(T, id := 2 * fnt.fnt + 1, st := st)
    END;
    VAR
      i: INTEGER;
      t          := st.succ(NIL, i);
    BEGIN
      IF t = NIL THEN
        res.metrics := EmptyMetrics
      ELSE
        res.metrics := Palette.ResolveFont(t, fnt).metrics
      END
    END;
    RETURN res
  END Apply;

REVEAL
  <A NAME="Oracle">Oracle</A> = ScrnFont.Oracle BRANDED OBJECT
             st: JoinScreen.T;
           (*
           OVERRIDES
             match   := Match;
             list    := List;
             lookup  := Lookup;
             builtIn := BuiltIn
           *)
           END;

TYPE
  T = ScrnFont.T OBJECT
        st: JoinScreen.T;
      (*
      OVERRIDES
        localize := Localize;
        unload   := Unload
      *)
      END;
</PRE><P>
PROCEDURE FontMatch(orc: FontOracle; 
                    family: TEXT;
                    pointSize: INTEGER;
                    slant: ScrnFont.Slant;
                    maxResults: CARDINAL;
                    weightName: TEXT;
                    version: TEXT;
                    foundry: TEXT;
                    width: TEXT;
                    pixelsize: INTEGER;
                    hres, vres: INTEGER;
                    spacing: ScrnFont.Spacing;
                    averageWidth: INTEGER;
                    charsetRegistry: TEXT;
                    charsetEncoding: TEXT)
                    : REF ARRAY OF TEXT =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].font.match(family, pointSize, slant, maxResults,
                             weightName, version, foundry, width,
                             pixelsize, hres, vres, spacing,
                             averageWidth, charsetRegistry, charsetEncoding);
  END FontMatch;
                    <P>
PROCEDURE FontBuiltIn(orc: FontOracle; id: Font.Predefined): ScrnFont.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].font.builtIn(id);
  END FontBuiltIn;
<P>
PROCEDURE FontList(orc: FontOracle;
                   pat: TEXT;
                   maxResults: INTEGER) : REF ARRAY OF TEXT =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].font.list(pat, maxResults);
  END FontList;
<P>
PROCEDURE FontLookup(orc: FontOracle; name: TEXT): ScrnFont.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].font.lookup(name);
  END FontLookup;
<P>
EXCEPTION FatalError;
<P>
PROCEDURE Crash () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;


<P><PRE>VAR
  EmptyMetrics := NEW(NullMetrics,
                      minBounds := ScrnFont.CharMetric{0, Rect.Empty},
                      maxBounds := ScrnFont.CharMetric{0, Rect.Empty},
                      firstChar := 0, lastChar := 0, selfClearing := TRUE,
                      charMetrics := NIL);

TYPE
  NullMetrics = ScrnFont.Metrics OBJECT
                OVERRIDES
                  intProp  := NullIntProp;
                  textProp := NullTextProp
                END;

PROCEDURE <A NAME="NullIntProp"><procedure>NullIntProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                       &lt;*UNUSED*&gt; name: TEXT;
                       &lt;*UNUSED*&gt; ch  : INTEGER       := -1): INTEGER
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullIntProp;

PROCEDURE <A NAME="NullTextProp"><procedure>NullTextProp</procedure></A> (&lt;*UNUSED*&gt; self: NullMetrics;
                        &lt;*UNUSED*&gt; name: TEXT;
                        &lt;*UNUSED*&gt; ch  : INTEGER       := -1): TEXT
  RAISES {ScrnFont.Failure} =
  BEGIN
    RAISE ScrnFont.Failure
  END NullTextProp;

BEGIN END JoinFont.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
