<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinPaintOp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinPaintOp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="JoinPaintOp.i3">JoinPaintOp</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="JoinScreen.i3">JoinScreen</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/PaintOp.i3">PaintOp</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="../vbt/PlttFrnds.i3">PlttFrnds</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (st: JoinScreen.T; op: PaintOp.T) =
  VAR i: INTEGER; t := st.succ(NIL, i);
  BEGIN
    WHILE t # NIL DO EVAL Palette.ResolveOp(t, op); t := st.succ(t, i) END
  END Resolve;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (           st: JoinScreen.T;
                 &lt;*UNUSED*&gt; cl: Palette.OpClosure;
                            op: PaintOp.T          ): ScrnPaintOp.T =
  VAR res := st.ops[op.op];
  BEGIN
    Resolve(st, op);
    IF res # NIL AND res # PlttFrnds.noOp THEN RETURN res END;
    RETURN NEW(T, id := 2 * op.op + 1, st := st);
  END Apply;

REVEAL
  <A NAME="Oracle">Oracle</A> = ScrnPaintOp.Oracle BRANDED OBJECT
             st: JoinScreen.T;
           (*
           OVERRIDES
             opaque      := Opaque;
             bgfg        := Bgfg;
             swap        := Swap;
             transparent := Transparent;
             copy        := Copy;
             builtIn     := OpBuiltIn;
           *)
           END;

TYPE T = ScrnPaintOp.T OBJECT st: JoinScreen.T;  END;
</PRE><P>
PROCEDURE OpBuiltIn(orc: OpOracle;
                    op: PaintOp.Predefined) : ScrnPaintOp.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    IF orc.st.sts[0].ops[op] = PlttFrnds.noOp THEN
       EVAL Palette.ResolveOp(orc.st.sts[0], PaintOp.T{op});
    END; (* if 
    <PRE>RETURN orc.st.sts[0].ops[op];
  END OpBuiltIn;

PROCEDURE Bgfg(orc: OpOracle;
               bg, fg: ScrnPaintOp.T): ScrnPaintOp.T
    RAISES {ScrnPaintOp.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].op.bgfg(bg, fg);
  END Bgfg;

PROCEDURE Copy(orc: OpOracle): ScrnPaintOp.T RAISES {} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].op.copy();
  END Copy;

PROCEDURE Opaque(orc: OpOracle; pix: ScrnPaintOp.Pixel)
  : ScrnPaintOp.T RAISES {} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].op.opaque(pix);
  END Opaque;

PROCEDURE Swap(orc: OpOracle; p,q: ScrnPaintOp.Pixel)
    : ScrnPaintOp.T RAISES {} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].op.swap(p, q);
  END Swap;

PROCEDURE Transparent(orc: OpOracle): ScrnPaintOp.T RAISES {}=
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].op.transparent();
  END Transparent;

EXCEPTION FatalError;

PROCEDURE Crash () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;
*)

BEGIN END JoinPaintOp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
