<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinPixmap.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinPixmap.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;

MODULE <module><implements><A HREF="JoinPixmap.i3">JoinPixmap</A></implements></module>;

IMPORT <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="JoinScreen.i3">JoinScreen</A>, <A HREF="../vbt/Pixmap.i3">Pixmap</A>, <A HREF="../vbt/Palette.i3">Palette</A>, <A HREF="../vbt/PlttFrnds.i3">PlttFrnds</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>,
       <A HREF="../../derived/STypeMapSeq.i3">STypeMapSeq</A>, <A HREF="../../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../vbt/ScreenType.i3">ScreenType</A>, <A HREF="STypeMap.i3">STypeMap</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE <A NAME="ResolvePix"><procedure>ResolvePix</procedure></A> (st: JoinScreen.T; pm: Pixmap.T) =
  VAR i: INTEGER; t := st.succ(NIL, i);
  BEGIN
    WHILE t # NIL DO EVAL Palette.ResolvePixmap(t, pm); t := st.succ(t, i) END
  END ResolvePix;

PROCEDURE <A NAME="Apply"><procedure>Apply</procedure></A> (           st: JoinScreen.T;
                 &lt;*UNUSED*&gt; cl: Palette.PixmapClosure;
                            pm: Pixmap.T               ): ScrnPixmap.T =
  VAR res := st.pixmaps[pm.pm];
  BEGIN
    ResolvePix(st, pm);
    IF res = NIL OR res = PlttFrnds.noPixmap THEN
      res := NEW(T, id := 2 * pm.pm + 1, st := st)
    END;
    VAR
      i: INTEGER;
      t          := st.succ(NIL, i);
    BEGIN
      IF t = NIL THEN
        res.depth := 1;
        res.bounds := Rect.Empty
      ELSE
        WITH tpm = Palette.ResolvePixmap(t, pm) DO
          res.depth := tpm.depth;
          res.bounds := tpm.bounds
        END
      END
    END;
    RETURN res
  END Apply;

REVEAL
  <A NAME="Oracle">Oracle</A> = ScrnPixmap.Oracle BRANDED OBJECT
             st: JoinScreen.T;
             jpms: IntRefTbl.Default := NIL;
             pmcount: CARDINAL := 2 (* non-zero, positive, and even *)
           (*
           OVERRIDES
             load    := Register;
             list    := List;
             lookup  := Lookup;
             builtIn := BuiltIn
           *)
           END;

REVEAL
  <A NAME="T">T</A> = ScrnPixmap.T BRANDED OBJECT
        st: JoinScreen.T;
        map: STypeMapSeq.T := NIL;
      OVERRIDES
      (*
        localize := Localize;
        unload   := Unload
      *)
        free := Free;
      END;
</PRE><P>
PROCEDURE PixmapRegister(orc: PixmapOracle; 
                         READONLY pm: ScrnPixmap.Raw; 
                         nm: TEXT := NIL): ScrnPixmap.T 
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].pixmap.load(pm, nm);
  END PixmapRegister;
<P>
PROCEDURE PixmapList(orc: PixmapOracle;  pat: TEXT;
                     maxResults: CARDINAL := 1) : REF ARRAY OF TEXT 
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].pixmap.list(pat, maxResults);
  END PixmapList;
<P>
PROCEDURE PixmapLookup(orc: PixmapOracle;
                       name: TEXT) : ScrnPixmap.T
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].pixmap.lookup(name);
  END PixmapLookup;
  <P>
PROCEDURE PixmapBuiltIn(orc: PixmapOracle;
                        pm: Pixmap.Predefined): ScrnPixmap.T =
  BEGIN
    IF orc.st.sts = NIL THEN Crash(); END;
    RETURN orc.st.sts[0].pixmap.builtIn(pm);
  END PixmapBuiltIn;
<P>
EXCEPTION FatalError;
<P>
PROCEDURE Crash () =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Crash;


<P><PRE>VAR mu := NEW(MUTEX);

PROCEDURE <A NAME="Free"><procedure>Free</procedure></A> (pm: T) RAISES {TrestleComm.Failure} =
  VAR
    map : STypeMapSeq.T;
    elem: STypeMap.T;
    o   : Oracle        := pm.st.pixmap;
    ra: REFANY;
  BEGIN
    LOCK mu DO
      map := pm.map;
      pm.map := NIL;
      IF o.jpms # NIL THEN EVAL o.jpms.delete(pm.id, ra) END
    END;
    IF map = NIL THEN RETURN END;
    WHILE map.size() # 0 DO
      elem := map.remlo();
      IF elem.pm # NIL THEN elem.pm.free() END
    END
  END Free;

PROCEDURE <A NAME="Create"><procedure>Create</procedure></A> (st: JoinScreen.T; READONLY clip: Rect.T): T =
  VAR res: T := NEW(T, depth := st.depth, bounds := clip, st := st);
      o: Oracle := st.pixmap;
  BEGIN
    LOCK mu DO
      IF st # st.bits THEN res.id := o.pmcount ELSE res.id := -o.pmcount END;
      INC(o.pmcount, 2);
      IF o.jpms = NIL THEN o.jpms := NEW(IntRefTbl.Default).init() END;
      EVAL o.jpms.put(res.id, res)
    END;
    RETURN res
  END Create;

PROCEDURE <A NAME="AddPixmap"><procedure>AddPixmap</procedure></A>(p: T; st: ScreenType.T; pm: ScrnPixmap.T) =
  VAR elem := STypeMap.T{st := st, pm := pm};
  BEGIN
    LOCK mu DO
      IF p.map = NIL THEN p.map := NEW(STypeMapSeq.T).init() END;
      p.map.addhi(elem)
    END
  END AddPixmap;

PROCEDURE <A NAME="Resolve"><procedure>Resolve</procedure></A> (jst: JoinScreen.T; pst: ScreenType.T; n: INTEGER):
  ScrnPixmap.T =
  VAR p: T; o: Oracle := jst.pixmap; ra: REFANY; elem: STypeMap.T;
  BEGIN
    LOCK mu DO
      IF o.jpms = NIL OR NOT o.jpms.get(n, ra) THEN RETURN NIL END;
      p := ra;
      IF p = NIL OR p.map = NIL THEN RETURN NIL END;
      FOR i := 0 TO p.map.size() - 1 DO
        elem := p.map.get(i);
        IF elem.st = pst THEN RETURN elem.pm END
      END;
      RETURN NIL
    END
  END Resolve;

BEGIN END JoinPixmap.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
