<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinedVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinedVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>JoinedVBT.T</CODE> allows many parent <CODE>VBT</CODE>s to view the screen
   of a single child <CODE>VBT</CODE>.  One parent's view of the child's
   domain may overlap with another parent's view, and it might
   not cover the entire child domain.
<P>
   The domain of the child of a <CODE>JoinedVBT.T</CODE> is the union of the parent
   domains; you should wrap the child in a filter if you want to make the
   child domain have some other shape.  Since the domains of the parents may
   not always be in the most convenient coordinate system, you may
   want to use <CODE>TranslateVBT</CODE> or something similar to change domains.
<P>
   Event-time operations on the child are performed on the
   event-time parent (the parent that last received a mouse
   click, or as set by method calls on the VBT.  When the event-time parent
   changes, all selections held by the old event-time parent
   are released (if the parents are on different Trestles).  These
   event-time operations are handled by making the parent an
   <CODE>ETAgent</CODE> and inserting a filter between the parent and the
   child.  When a parent receives a <CODE>VBT.Deleted</CODE> code, it removes
   itself (and the filter).  Other miscellaneous codes are
   handled as an <CODE>ETAgent</CODE>.
<P>
   The value of <CODE>v.parent</CODE> is <CODE>NIL</CODE> if the <CODE>JoinedVBT</CODE> <CODE>v</CODE> has
   no parents; otherwise it is an arbitrary parent (or rather
   the filter below the parent---these will not be explicitly
   mentioned hereafter).
<P>
   Those who are familiar with the rules for using concurrency
   while reformatting splits will note that two parents of a Joined
   may be reformatted concurrently.  These reformat procedures
   may wish to call <CODE>Reshape</CODE>, or <CODE>Redisplay</CODE>.
   Therefore, an internal lock is used by the JoinedVBT to
   serialize these operations; their locking level is <CODE>LL &lt;= VBT.mu</CODE>
   instead of <CODE>LL = VBT.mu</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="JoinedVBT.m3">JoinedVBT</A></interface>;

IMPORT <A HREF="Filter.i3">Filter</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="JoinedVBT.m3#T">T</A> &lt;: Public;
  Public = Filter.T OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (ch: VBT.T): T
           END;
</PRE> The call <CODE>v.init(ch)</CODE> initializes <CODE>v</CODE> as a <CODE>JoinedVBT</CODE> with
     child <CODE>ch</CODE>, and returns <CODE>v</CODE>. 

<P><PRE>PROCEDURE <A HREF="JoinedVBT.m3#New">New</A> (ch: VBT.T): T;
&lt;* LL.sup &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

END JoinedVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
