<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/JoinedVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/JoinedVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="JoinedVBT.i3">JoinedVBT</A></implements></module>;
</PRE> Since JoinVBT is being used inside Trestle to tee the screen for
   Mirage and JoinScreen, it needs to be efficient in the normal case of
   a single parent. A paint short-circuiting similar to that of ZSplit
   is used 

<P><PRE>IMPORT <A HREF="../vbt/Batch.i3">Batch</A>, <A HREF="../vbt/BatchRep.i3">BatchRep</A>, <A HREF="../vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="Filter.i3">Filter</A>, <A HREF="FilterClass.i3">FilterClass</A>, <A HREF="../vbt/MouseSplit.i3">MouseSplit</A>, <A HREF="../../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../../../geometry/src/Region.i3">Region</A>, <A HREF="../vbt/ScrnCursor.i3">ScrnCursor</A>, <A HREF="../vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../vbt/VBT.i3">VBT</A>, <A HREF="../vbt/VBTClass.i3">VBTClass</A>, <A HREF="../vbt/VBTRep.i3">VBTRep</A>, <A HREF="JoinParent.i3">JoinParent</A>,
       <A HREF="../../../geometry/src/Axis.i3">Axis</A>, <A HREF="JoinPixmap.i3">JoinPixmap</A>, <A HREF="JoinScreen.i3">JoinScreen</A>;

REVEAL
  <A NAME="T">T</A> = JoinParent.Join BRANDED OBJECT
      OVERRIDES
        paintbatch := PaintBatch;
        capture    := Capture;
        sync       := Sync;
        discard    := Discard;
        newShape   := NewShape;
        redisplay  := Redisplay;
        rescreen   := Rescreen;
        reshape    := Reshape;
        repaint    := Repaint;
        position   := Position;
        shape      := Shape;
        init       := Be;
        setcursor  := SetCursor
      END;

TYPE
  ParentList = JoinParent.T;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A> (v: T; &lt;* UNUSED *&gt; ch: VBT.T; ba: Batch.T) =
  VAR saved, pl: ParentList;
  bb: Batch.T;
  BEGIN                          (* LL = ch *)
    LOCK v DO
      pl := v.parents;
      IF pl = NIL THEN Batch.Free(ba); RETURN END;
      BatchUtil.Tighten(ba);
      WHILE pl # NIL
              AND (pl.st = NIL OR NOT Rect.Overlap(ba.clip, pl.domain)) DO
        pl := pl.link
      END;
      IF pl = NIL THEN Batch.Free(ba); RETURN END;
      saved := pl;
      pl := pl.link;
      WHILE pl # NIL DO
        IF pl.st # NIL AND Rect.Overlap(ba.clip, pl.domain) THEN
          bb := BatchUtil.Copy(ba);
          VBTClass.PaintBatch(pl.ch, bb)
        END;
        pl := pl.link
      END;
      VBTClass.PaintBatch(saved.ch, ba)
    END
  END PaintBatch;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A> (                         v   : T;
                   &lt;* UNUSED *&gt;             ch  : VBT.T;
                                READONLY    clip: Rect.T;
                                VAR (*out*) br  : Region.T): ScrnPixmap.T =
  VAR
    pl : ParentList;
    bad: Region.T;
    res: JoinPixmap.T;
  BEGIN
    LOCK v DO
      pl := v.parents;
      IF pl = NIL THEN br := Region.FromRect(clip); RETURN NIL END;
      IF pl.link = NIL OR NOT ISTYPE(v.st, JoinScreen.T) THEN
        RETURN VBT.Capture(pl.ch, clip, br)
      END;
      br := Region.Empty;
      res := JoinPixmap.Create(v.st, clip);
      WHILE pl # NIL DO
        JoinPixmap.AddPixmap(res, pl.st, VBT.Capture(pl.ch, clip, bad));
        br := Region.Join(br, bad);
        pl := pl.link
      END;
      RETURN res
    END;
  END Capture;

PROCEDURE <A NAME="Sync"><procedure>Sync</procedure></A>(v: T; &lt;* UNUSED *&gt; ch: VBT.T; wait := TRUE)  =
  VAR
    pl: ParentList;
  BEGIN
    LOCK v DO
      pl := v.parents;
      WHILE pl # NIL DO
        VBT.Sync(pl.ch, wait);
        pl := pl.link
      END
    END;
  END Sync;

PROCEDURE <A NAME="SetCursor"><procedure>SetCursor</procedure></A> (v: T; ch: VBT.T) =
  BEGIN                          (* LL = ch *)
    Public.setcursor(v, ch);
    UpdateCursor(v);
  END SetCursor;

PROCEDURE <A NAME="UpdateCursor"><procedure>UpdateCursor</procedure></A> (v: T) =
  VAR
    pl: ParentList;
    cs: ScrnCursor.T;
  BEGIN
    LOCK v DO
      cs := v.getcursor();
      pl := v.parents;
      WHILE pl # NIL DO JoinParent.SetCursor(pl, cs); pl := pl.link END;
    END;
  END UpdateCursor;

PROCEDURE <A NAME="Discard"><procedure>Discard</procedure></A> (v: T) =
  VAR pl: ParentList;
  BEGIN
    LOOP
      LOCK v DO pl := v.parents END;
      IF pl = NIL THEN EXIT END;
      JoinParent.Rem(pl)
    END;
    Filter.T.discard(v);
  END Discard;
</PRE> some prop munging stolen from VBT.NewShape 
<PRE>PROCEDURE <A NAME="NewShape"><procedure>NewShape</procedure></A> (v: T;  &lt;* UNUSED *&gt;ch: VBT.T) =
  VAR
    pl: ParentList;
  BEGIN
    LOCK v DO
      v.props := v.props + VBTRep.Props{VBTRep.Prop.HasNewShape,
                                        VBTRep.Prop.BlockNewShape};
      pl := v.parents;
      WHILE pl # NIL DO VBT.NewShape(pl.ch); pl := pl.link; END;
    END;
  END NewShape;

PROCEDURE <A NAME="ReallyRescreen"><procedure>ReallyRescreen</procedure></A>(v: VBT.T; st: VBT.ScreenType) =
  BEGIN
    IF st # NIL AND v.st = st THEN VBTClass.Rescreen(v, NIL) END;
    VBTClass.Rescreen(v, st)
  END ReallyRescreen;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A> (v: T) =
  BEGIN
    IF JoinParent.NeedsRescreen(v) THEN
      ReallyRescreen(v, JoinParent.ST(v))
    END;
    IF v.domain # JoinParent.Domain(v) THEN
      VBTClass.Reshape(v, JoinParent.Domain(v), Rect.Empty)
    ELSIF v.ch # NIL THEN
      VBTClass.Repaint(v.ch, Region.Empty)
    END
  END Redisplay;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    Public.rescreen(v, cd);
    UpdateCursor(v);
    IF cd.marked AND v.domain # JoinParent.Domain(v) THEN
      VBTClass.Reshape(v, JoinParent.Domain(v), Rect.Empty)
    END
  END Rescreen;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (v: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF cd.marked AND JoinParent.NeedsRescreen(v) THEN
      ReallyRescreen(v, JoinParent.ST(v));
      VBTClass.Reshape(v, cd.new, Rect.Empty)
    ELSE
      Public.reshape(v, cd)
    END
  END Reshape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY br: Region.T) =
  BEGIN
    IF VBT.IsMarked(v) THEN
      IF JoinParent.NeedsRescreen(v) THEN
        ReallyRescreen(v, JoinParent.ST(v))
      END;
      IF v.domain # JoinParent.Domain(v) THEN
        VBTClass.Reshape(v, JoinParent.Domain(v), Rect.Empty)
      ELSE
        Public.repaint(v, br)
      END
    ELSE
      Public.repaint(v, br)
    END;
  END Repaint;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: T; axis: Axis.T; n: CARDINAL): VBT.SizeRange =
  BEGIN
    IF VBT.IsMarked(v) AND JoinParent.NeedsRescreen(v) THEN
      ReallyRescreen(v, JoinParent.ST(v))
    END;
    RETURN JoinParent.Join.shape(v, axis, n)
  END Shape;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    Public.position(v, cd);
    UpdateCursor(v)
  END Position;

PROCEDURE <A NAME="Be"><procedure>Be</procedure></A> (v: T; ch: VBT.T): T =
  BEGIN
    LOCK v DO VBTClass.ClearShortCircuit(v); END;
    RETURN Filter.T.init(v, ch);
  END Be;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(ch: VBT.T): T  =
  BEGIN
    RETURN NEW(T).init(ch)
  END New;

BEGIN
END JoinedVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
