<HTML>
<HEAD>
<TITLE>SRC Modula-3: ui/src/split/MenuBtnVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>ui/src/split/MenuBtnVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>MenuBtnVBT.T</CODE> is a button suitable for the items in pop-up
   and pull-down menus.
<P>
   When the cursor rolls into a menu button, the <CODE>pre</CODE> method is called
   and the button is {\it readied}.  If it receives a mouse transition
   of type <CODE>LastUp</CODE> while it is readied, the <CODE>action</CODE> and <CODE>post</CODE> methods
   are called.  The <CODE>cancel</CODE> method is called if the cursor leaves the
   button or the user chords with the mouse while the button is readied
   .  

<P><PRE>INTERFACE <interface><A HREF="MenuBtnVBT.m3">MenuBtnVBT</A></interface>;

IMPORT <A HREF="ButtonVBT.i3">ButtonVBT</A>, <A HREF="../vbt/VBT.i3">VBT</A>;

TYPE <A HREF="MenuBtnVBT.m3#T">T</A> &lt;: ButtonVBT.T;
</PRE> The call <CODE>v.init(ch, action, ref)</CODE> initializes <CODE>v</CODE> as a menu button 
   with child <CODE>ch</CODE> and action procedure <CODE>action</CODE>, and adds <CODE>ref</CODE> to
   <CODE>v</CODE>'s property set if it is not <CODE>NIL</CODE>. 

<P><PRE>PROCEDURE <A HREF="MenuBtnVBT.m3#New">New</A>(
  ch: VBT.T; action: ButtonVBT.Proc;
  ref: REFANY := NIL): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> <CODE>New(...)</CODE> is equivalent to <CODE>NEW(T).init(...)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="MenuBtnVBT.m3#TextItem">TextItem</A>(
  name: TEXT; action: ButtonVBT.Proc;
  ref: REFANY := NIL): T; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a menu button that displays the text <CODE>name</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>TextItem</CODE> is a convenience procedure for making a menu button with
   a <CODE>TextVBT</CODE> child.  The borders are initialized to make the button
   suitable for stacking into a menu using a vertical <CODE>HVSplit</CODE>.  More
   precisely, <CODE>TextItem</CODE> is equivalent to:
<P>
<PRE>
      New(TextVBT.New(name, 0.0, 0.5, 3.0, 0.5), 
          action, ref)
</PRE>


<P><PRE>END MenuBtnVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
